/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.core.utils.SslSocketWrapper;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class SSLCertMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(SSLCertMonitor.class);
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_DAYS = 7;
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_DAYS = "days";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_PORT, (int)-1);
        if (port == -1) {
            throw new RuntimeException("Required parameter 'port' is not present in supplied properties.");
        }
        int validityDays = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_DAYS, (int)7);
        if (validityDays <= 0) {
            throw new RuntimeException("Required parameter 'days' must be a positive value.");
        }
        Calendar calValid = GregorianCalendar.getInstance();
        Calendar calCurrent = GregorianCalendar.getInstance();
        calValid.setTimeInMillis(calCurrent.getTimeInMillis());
        calValid.add(5, validityDays);
        Calendar calBefore = GregorianCalendar.getInstance();
        Calendar calAfter = GregorianCalendar.getInstance();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("poll: address={}, port={}, {}", new Object[]{hostAddress, port, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("Connected to host: {} on port: {}", (Object)ipv4Addr, (Object)port);
                SSLSocket sslSocket = (SSLSocket)this.getSocketWrapper().wrapSocket(socket);
                serviceStatus = PollStatus.unresponsive();
                Certificate[] certs = sslSocket.getSession().getPeerCertificates();
                for (int i = 0; i < certs.length && !serviceStatus.isAvailable(); ++i) {
                    if (!(certs[i] instanceof X509Certificate)) continue;
                    X509Certificate certx = (X509Certificate)certs[i];
                    LOG.debug("Checking validity against dates: [current: {}, valid: {}], NotBefore: {}, NotAfter: {}", new Object[]{calCurrent.getTime(), calValid.getTime(), certx.getNotBefore(), certx.getNotAfter()});
                    calBefore.setTime(certx.getNotBefore());
                    calAfter.setTime(certx.getNotAfter());
                    if (calCurrent.before(calBefore)) {
                        LOG.debug("Certificate is invalid, current time is before start time");
                        serviceStatus = PollStatus.unavailable((String)"Certificate is invalid, current time is before start time");
                    } else if (calCurrent.before(calAfter)) {
                        if (calValid.before(calAfter)) {
                            LOG.debug("Certificate is valid, and does not expire before validity check date");
                            serviceStatus = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                        } else {
                            String reason2 = "Certificate is valid, but will expire in " + validityDays + " days.";
                            LOG.debug(reason2);
                            serviceStatus = PollStatus.unavailable((String)reason2);
                        }
                    } else {
                        LOG.debug("Certificate has expired.");
                        serviceStatus = PollStatus.unavailable((String)"Certificate has expired.");
                    }
                    break;
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
                break;
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    LOG.debug("poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    protected SocketWrapper getSocketWrapper() {
        return new SslSocketWrapper();
    }
}

