/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class PercMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(PercMonitor.class);
    private static final String SERVICE_NAME = "PERC";
    private static final String LOGICAL_BASE_OID = ".1.3.6.1.4.1.3582.1.1.2.1.3";
    private static final String PHYSICAL_BASE_OID = ".1.3.6.1.4.1.3582.1.1.3.1.4";
    private static final String ARRAY_POSITION_BASE_OID = ".1.3.6.1.4.1.3582.1.1.3.1.5";

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            LOG.error("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        String arrayNumber = ParameterMap.getKeyedString(parameters, (String)"array", (String)"0.0");
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        try {
            LOG.debug("PercMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId snmpObjectId = SnmpObjId.get((String)(".1.3.6.1.4.1.3582.1.1.2.1.3." + arrayNumber));
            String returnValue = "";
            SnmpValue value = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)snmpObjectId);
            if (value.toInt() != 2) {
                LOG.debug("PercMonitor.poll: Bad Disk Found");
                returnValue = "log vol(" + arrayNumber + ") degraded";
                SnmpObjId arrayPositionSnmpObject = SnmpObjId.get((String)ARRAY_POSITION_BASE_OID);
                SnmpObjId diskStatesSnmpObject = SnmpObjId.get((String)PHYSICAL_BASE_OID);
                Map arrayDisks = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"PercMonitor", (SnmpObjId)arrayPositionSnmpObject);
                Map diskStates = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"PercMonitor", (SnmpObjId)diskStatesSnmpObject);
                Iterator iterator = arrayDisks.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry disk = iterator.next();
                    if (((SnmpValue)disk.getValue()).toString().contains("A" + arrayNumber + "-") && ((SnmpValue)diskStates.get(disk.getKey())).toInt() != 3) {
                        returnValue = returnValue + "phy drv(" + disk.getKey() + ")";
                    }
                    return PollStatus.unavailable((String)returnValue);
                }
            }
            status = PollStatus.available();
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable((String)reason);
        }
        return status;
    }
}

