/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class Dot1qTpFdbTableTracker
extends TableTracker {
    public static final SnmpObjId DOT1Q_TP_FDB_PORT = SnmpObjId.get((String)".1.3.6.1.2.1.17.7.1.2.2.1.2");
    public static final SnmpObjId DOT1Q_TP_FDB_STATUS = SnmpObjId.get((String)".1.3.6.1.2.1.17.7.1.2.2.1.3");
    public static SnmpObjId[] ms_elemList = new SnmpObjId[]{DOT1Q_TP_FDB_PORT, DOT1Q_TP_FDB_STATUS};

    public Dot1qTpFdbTableTracker() {
        super(ms_elemList);
    }

    public Dot1qTpFdbTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, ms_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1qTpFdbRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1qTpFdbRow((Dot1qTpFdbRow)row);
    }

    public void processDot1qTpFdbRow(Dot1qTpFdbRow row) {
    }

    public static class Dot1qTpFdbRow
    extends SnmpRowResult {
        public Dot1qTpFdbRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public String getDot1qTpFdbAddress() {
            int[] identifiers = this.getInstance().getIds();
            StringBuilder sb = new StringBuilder();
            for (int i = identifiers.length - 6; i < identifiers.length; ++i) {
                if (identifiers[i] >= 16) {
                    sb.append(Integer.toHexString(identifiers[i]));
                    continue;
                }
                sb.append("0").append(Integer.toHexString(identifiers[i]));
            }
            return sb.toString();
        }

        public Integer getDot1qTpFdbPort() {
            if (this.getValue(DOT1Q_TP_FDB_PORT) != null) {
                return this.getValue(DOT1Q_TP_FDB_PORT).toInt();
            }
            return null;
        }

        public Integer getDot1qTpFdbStatus() {
            if (this.getValue(DOT1Q_TP_FDB_STATUS) != null) {
                return this.getValue(DOT1Q_TP_FDB_STATUS).toInt();
            }
            return null;
        }

        public BridgeMacLink getLink() {
            BridgeMacLink link = new BridgeMacLink();
            link.setBridgePort(this.getDot1qTpFdbPort());
            link.setMacAddress(this.getDot1qTpFdbAddress());
            if (this.getDot1qTpFdbStatus() != null) {
                link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.get((Integer)this.getDot1qTpFdbStatus()));
            }
            return link;
        }
    }
}

