/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dot1dStpPortTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(Dot1dStpPortTableTracker.class);
    public static final SnmpObjId DOT1D_STP_PORT = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.1");
    public static final SnmpObjId DOT1D_STP_PORT_PRIORITY = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.2");
    public static final SnmpObjId DOT1D_STP_PORT_STATE = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.3");
    public static final SnmpObjId DOT1D_STP_PORT_ENABLE = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.4");
    public static final SnmpObjId DOT1D_STP_PORT_PATH_COST = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.5");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_ROOT = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.6");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_COST = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.7");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_BRIDGE = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.8");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_PORT = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.9");
    public static final SnmpObjId[] stpport_elemList = new SnmpObjId[]{DOT1D_STP_PORT, DOT1D_STP_PORT_PRIORITY, DOT1D_STP_PORT_STATE, DOT1D_STP_PORT_ENABLE, DOT1D_STP_PORT_PATH_COST, DOT1D_STP_PORT_DESIGNATED_ROOT, DOT1D_STP_PORT_DESIGNATED_COST, DOT1D_STP_PORT_DESIGNATED_BRIDGE, DOT1D_STP_PORT_DESIGNATED_PORT};

    public Dot1dStpPortTableTracker() {
        super(stpport_elemList);
    }

    public Dot1dStpPortTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, stpport_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1dStpPortRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1dStpPortRow((Dot1dStpPortRow)row);
    }

    public void processDot1dStpPortRow(Dot1dStpPortRow row) {
    }

    public static class Dot1dStpPortRow
    extends SnmpRowResult {
        public Dot1dStpPortRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public Integer getDot1dStpPort() {
            return this.getValue(DOT1D_STP_PORT).toInt();
        }

        public Integer getDot1dStpPortPriority() {
            return this.getValue(DOT1D_STP_PORT_PRIORITY).toInt();
        }

        public Integer getDot1dStpPortState() {
            return this.getValue(DOT1D_STP_PORT_STATE).toInt();
        }

        public Integer getDot1dStpPortEnable() {
            return this.getValue(DOT1D_STP_PORT_ENABLE).toInt();
        }

        public Integer getDot1dStpPortPathCost() {
            return this.getValue(DOT1D_STP_PORT_PATH_COST).toInt();
        }

        public String getDot1dStpPortDesignatedRoot() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_ROOT).toHexString();
        }

        public Integer getDot1dStpPortDesignatedCost() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_COST).toInt();
        }

        public String getDot1dStpPortDesignatedBridge() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_BRIDGE).toHexString();
        }

        public String getDot1dStpPortDesignatedPort() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_PORT).toHexString();
        }

        public BridgeStpLink getLink() {
            LOG.info("processStpPortRow: row count: {}", (Object)this.getColumnCount());
            BridgeStpLink link = new BridgeStpLink();
            link.setStpPort(this.getDot1dStpPort());
            link.setStpPortPriority(this.getDot1dStpPortPriority());
            link.setStpPortState(BridgeStpLink.BridgeDot1dStpPortState.get((Integer)this.getDot1dStpPortState()));
            link.setStpPortEnable(BridgeStpLink.BridgeDot1dStpPortEnable.get((Integer)this.getDot1dStpPortEnable()));
            link.setStpPortPathCost(this.getDot1dStpPortPathCost());
            link.setDesignatedRoot(this.getDot1dStpPortDesignatedRoot());
            link.setDesignatedCost(this.getDot1dStpPortDesignatedCost());
            link.setDesignatedBridge(this.getDot1dStpPortDesignatedBridge());
            link.setDesignatedPort(this.getDot1dStpPortDesignatedPort());
            return link;
        }
    }
}

