/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpInterfacePortNameGetter
extends TableTracker {
    public static final SnmpObjId CDP_INTERFACE_NAME = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.1.1.1.6");
    public static final SnmpObjId MIB2_INTERFACE_NAME = SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.2");
    private SnmpAgentConfig m_agentConfig;
    private static final Logger LOG = LoggerFactory.getLogger(CdpInterfacePortNameGetter.class);

    public CdpInterfacePortNameGetter(SnmpAgentConfig peer) {
        super(new SnmpObjId[0]);
        this.m_agentConfig = peer;
    }

    public CdpLink get(CdpLink link) {
        SnmpValue ifName = this.getInterfaceNameFromCiscoCdpMib(link.getCdpCacheIfIndex());
        if (ifName == null) {
            ifName = this.getInterfaceNameFromMib2(link.getCdpCacheIfIndex());
        }
        if (ifName != null) {
            link.setCdpInterfaceName(ifName.toDisplayString());
        }
        return link;
    }

    public SnmpValue getInterfaceNameFromCiscoCdpMib(Integer ifindex) {
        SnmpObjId instance = SnmpObjId.get((int[])new int[]{ifindex});
        SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((SnmpObjId)CDP_INTERFACE_NAME, (SnmpObjId)instance)};
        SnmpValue[] val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId[])oids);
        LOG.info("get: oid '{}' found value '{}'", (Object)oids[0], (Object)val);
        if (val == null || val.length != 1 || val[0] == null || val[0].isError()) {
            return null;
        }
        return val[0];
    }

    public SnmpValue getInterfaceNameFromMib2(Integer ifindex) {
        SnmpObjId instance = SnmpObjId.get((int[])new int[]{ifindex});
        SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((SnmpObjId)MIB2_INTERFACE_NAME, (SnmpObjId)instance)};
        SnmpValue[] val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId[])oids);
        LOG.info("get: oid '{}' found value '{}'", (Object)oids[0], (Object)val);
        if (val == null || val.length != 1 || val[0] == null || val[0].isError()) {
            return null;
        }
        return val[0];
    }
}

