/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.collection.support.AbstractCollectionSet;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.config.httpdatacollection.Attrib;
import org.opennms.netmgt.config.httpdatacollection.HttpCollection;
import org.opennms.netmgt.config.httpdatacollection.Parameter;
import org.opennms.netmgt.config.httpdatacollection.Uri;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCollector.class);
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final int DEFAULT_SO_TIMEOUT = 3000;
    private static final NumberFormat PARSER = NumberFormat.getNumberInstance();
    private static final NumberFormat RRD_FORMATTER;

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
        HttpCollectionSet collectionSet = new HttpCollectionSet(agent, parameters);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.collect();
        return collectionSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doCollection(HttpCollectionSet collectionSet, HttpCollectionResource collectionResource) throws HttpCollectorException {
        HttpRequestBase method = null;
        HttpClientWrapper clientWrapper = null;
        try {
            HttpVersion httpVersion = HttpCollector.computeVersion(collectionSet.getUriDef());
            clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(collectionSet.getParameters(), (String)ServiceParameters.ParameterName.TIMEOUT.toString(), (int)3000))).setSocketTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(collectionSet.getParameters(), (String)ServiceParameters.ParameterName.TIMEOUT.toString(), (int)3000))).useBrowserCompatibleCookies();
            if ("https".equals(collectionSet.getUriDef().getUrl().getScheme())) {
                clientWrapper.useRelaxedSSL("https");
            }
            String key = ServiceParameters.ParameterName.RETRY.toString();
            if (collectionSet.getParameters().containsKey(ServiceParameters.ParameterName.RETRIES.toString())) {
                key = ServiceParameters.ParameterName.RETRIES.toString();
            }
            Integer retryCount = ParameterMap.getKeyedInteger(collectionSet.getParameters(), (String)key, (int)2);
            clientWrapper.setRetries(retryCount);
            method = HttpCollector.buildHttpMethod(collectionSet);
            method.setProtocolVersion((ProtocolVersion)httpVersion);
            String userAgent = HttpCollector.determineUserAgent(collectionSet);
            if (userAgent != null && !userAgent.trim().isEmpty()) {
                clientWrapper.setUserAgent(userAgent);
            }
            HttpClientWrapper wrapper = clientWrapper;
            if (collectionSet.getUriDef().getUrl().getUserInfo() != null) {
                String userInfo = collectionSet.getUriDef().getUrl().getUserInfo();
                String[] streetCred = userInfo.split(":", 2);
                if (streetCred.length == 2) {
                    wrapper.addBasicCredentials(streetCred[0], streetCred[1]);
                } else {
                    LOG.warn("Illegal value found for username/password HTTP credentials: {}", (Object)userInfo);
                }
            }
            LOG.info("doCollection: collecting using method: {}", (Object)method);
            CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)method);
            HttpCollector.persistResponse(collectionSet, collectionResource, (HttpResponse)response);
        }
        catch (URISyntaxException e) {
            try {
                throw new HttpCollectorException("Error building HttpClient URI", e);
                catch (IOException e2) {
                    throw new HttpCollectorException("IO Error retrieving page", e2);
                }
                catch (PatternSyntaxException e3) {
                    throw new HttpCollectorException("Invalid regex specified in HTTP collection configuration", e3);
                }
                catch (Throwable e4) {
                    throw new HttpCollectorException("Unexpected exception caught during HTTP collection", e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(clientWrapper);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)clientWrapper);
    }

    private static List<HttpCollectionAttribute> processResponse(Locale responseLocale, String responseBodyAsString, HttpCollectionSet collectionSet, HttpCollectionResource collectionResource) {
        LOG.debug("processResponse:");
        LOG.debug("responseBody = {}", (Object)responseBodyAsString);
        LOG.debug("getmatches = {}", (Object)collectionSet.getUriDef().getUrl().getMatches());
        LinkedList<HttpCollectionAttribute> butes = new LinkedList<HttpCollectionAttribute>();
        int flags = 0;
        if (collectionSet.getUriDef().getUrl().getCanonicalEquivalence()) {
            flags |= 0x80;
        }
        if (collectionSet.getUriDef().getUrl().getCaseInsensitive()) {
            flags |= 2;
        }
        if (collectionSet.getUriDef().getUrl().getComments()) {
            flags |= 4;
        }
        if (collectionSet.getUriDef().getUrl().getDotall()) {
            flags |= 0x20;
        }
        if (collectionSet.getUriDef().getUrl().getLiteral()) {
            flags |= 0x10;
        }
        if (collectionSet.getUriDef().getUrl().getMultiline()) {
            flags |= 8;
        }
        if (collectionSet.getUriDef().getUrl().getUnicodeCase()) {
            flags |= 0x40;
        }
        if (collectionSet.getUriDef().getUrl().getUnixLines()) {
            flags |= 1;
        }
        LOG.debug("flags = {}", (Object)flags);
        Pattern p = Pattern.compile(collectionSet.getUriDef().getUrl().getMatches(), flags);
        Matcher m = p.matcher(responseBodyAsString);
        boolean matches = m.matches();
        if (matches) {
            LOG.debug("processResponse: found matching attributes: {}", (Object)matches);
            List attribDefs = collectionSet.getUriDef().getAttributes().getAttribCollection();
            AttributeGroupType groupType = new AttributeGroupType(collectionSet.getUriDef().getName(), "all");
            ArrayList<Locale> locales = new ArrayList<Locale>();
            if (responseLocale != null) {
                locales.add(responseLocale);
            }
            locales.add(Locale.getDefault());
            if (Locale.getDefault() != Locale.ENGLISH) {
                locales.add(Locale.ENGLISH);
            }
            for (Attrib attribDef : attribDefs) {
                String type = attribDef.getType();
                String value = null;
                try {
                    value = m.group(attribDef.getMatchGroup());
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("IndexOutOfBoundsException thrown while trying to find regex group, your regex does not contain the following group index: {}", (Object)attribDef.getMatchGroup());
                    LOG.error("Regex statement: {}", (Object)collectionSet.getUriDef().getUrl().getMatches());
                    continue;
                }
                if (!type.matches("^([Oo](ctet|CTET)[Ss](tring|TRING))|([Ss](tring|TRING))$")) {
                    Number num = null;
                    for (Locale locale : locales) {
                        try {
                            num = NumberFormat.getNumberInstance(locale).parse(value);
                            LOG.debug("processResponse: found a parsable number with locale \"{}\".", (Object)locale);
                            break;
                        }
                        catch (ParseException e) {
                            LOG.warn("attribute {} failed to match a parsable number with locale \"{}\"! Matched \"{}\" instead.", new Object[]{attribDef.getAlias(), locale, value});
                        }
                    }
                    if (num == null) {
                        LOG.warn("processResponse: gave up attempting to parse numeric value, skipping group {}", (Object)attribDef.getMatchGroup());
                        continue;
                    }
                    HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionResource, new HttpCollectionAttributeType(attribDef, groupType), num);
                    LOG.debug("processResponse: adding found numeric attribute: {}", (Object)bute);
                    butes.add(bute);
                    continue;
                }
                HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionResource, new HttpCollectionAttributeType(attribDef, groupType), value);
                LOG.debug("processResponse: adding found string attribute: {}", (Object)bute);
                butes.add(bute);
            }
        } else {
            LOG.debug("processResponse: found matching attributes: {}", (Object)matches);
        }
        return butes;
    }

    private static void persistResponse(HttpCollectionSet collectionSet, HttpCollectionResource collectionResource, HttpResponse response) throws IOException {
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        if (responseString != null && !"".equals(responseString)) {
            List<HttpCollectionAttribute> attributes;
            Locale responseLocale = null;
            Header[] headers = response.getHeaders("Content-Language");
            if (headers != null) {
                LOG.debug("doCollection: Trying to devise response's locale from Content-Language header.");
                if (headers.length == 1) {
                    if (headers[0].getValue().split(",").length == 1) {
                        String[] values = headers[0].getValue().split("-");
                        LOG.debug("doCollection: Found one Content-Language header with value: {}", (Object)headers[0].getValue());
                        switch (values.length) {
                            case 1: {
                                responseLocale = new Locale(values[0]);
                                break;
                            }
                            case 2: {
                                responseLocale = new Locale(values[0], values[1]);
                                break;
                            }
                            default: {
                                LOG.warn("doCollection: Ignoring Content-Language header with value {}. No support for more than 1 language subtag!", (Object)headers[0].getValue());
                                break;
                            }
                        }
                    } else {
                        LOG.warn("doCollection: Multiple languages specified. That doesn't make sense. Ignoring...");
                    }
                } else {
                    LOG.warn("doCollection: More than 1 Content-Language headers received. Ignoring them!");
                }
            }
            if ((attributes = HttpCollector.processResponse(responseLocale, responseString, collectionSet, collectionResource)).isEmpty()) {
                LOG.warn("doCollection: no attributes defined by the response: {}", (Object)responseString.trim());
                throw new HttpCollectorException("No attributes specified were found: ");
            }
            collectionSet.storeResults(attributes, collectionResource);
        }
    }

    private static String determineUserAgent(HttpCollectionSet collectionSet) {
        String userAgent = collectionSet.getUriDef().getUrl().getUserAgent();
        return userAgent == null ? null : userAgent;
    }

    private static HttpVersion computeVersion(Uri uri) {
        return new HttpVersion(Integer.parseInt(uri.getUrl().getHttpVersion().substring(0, 1)), Integer.parseInt(uri.getUrl().getHttpVersion().substring(2)));
    }

    private static HttpRequestBase buildHttpMethod(HttpCollectionSet collectionSet) throws URISyntaxException {
        URI uri = HttpCollector.buildUri(collectionSet);
        Object method = "GET".equals(collectionSet.getUriDef().getUrl().getMethod()) ? HttpCollector.buildGetMethod(uri, collectionSet) : HttpCollector.buildPostMethod(uri, collectionSet);
        String virtualHost = collectionSet.getUriDef().getUrl().getVirtualHost();
        if (virtualHost != null && !virtualHost.trim().isEmpty()) {
            method.setHeader("Host", virtualHost);
        }
        return method;
    }

    private static HttpPost buildPostMethod(URI uri, HttpCollectionSet collectionSet) {
        HttpPost method = new HttpPost(uri);
        List<NameValuePair> postParams = HttpCollector.buildRequestParameters(collectionSet);
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postParams, "UTF-8");
            method.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return method;
    }

    private static HttpGet buildGetMethod(URI uri, HttpCollectionSet collectionSet) {
        URI uriWithQueryString = null;
        List<NameValuePair> queryParams = HttpCollector.buildRequestParameters(collectionSet);
        try {
            List params;
            StringBuffer query = new StringBuffer();
            query.append(URLEncodedUtils.format(queryParams, (String)"UTF-8"));
            if (uri.getQuery() != null && !uri.getQuery().trim().isEmpty()) {
                if (query.length() > 0) {
                    query.append("&");
                }
                query.append(uri.getQuery());
            }
            URIBuilder ub = new URIBuilder(uri);
            if (query.length() > 0 && !(params = URLEncodedUtils.parse((String)query.toString(), (Charset)Charset.forName("UTF-8"))).isEmpty()) {
                ub.setParameters(params);
            }
            uriWithQueryString = ub.build();
            return new HttpGet(uriWithQueryString);
        }
        catch (URISyntaxException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return new HttpGet(uri);
        }
    }

    private static List<NameValuePair> buildRequestParameters(HttpCollectionSet collectionSet) {
        ArrayList<NameValuePair> retval = new ArrayList<NameValuePair>();
        if (collectionSet.getUriDef().getUrl().getParameters() == null) {
            return retval;
        }
        List parameters = collectionSet.getUriDef().getUrl().getParameters().getParameterCollection();
        for (Parameter p : parameters) {
            retval.add((NameValuePair)new BasicNameValuePair(p.getKey(), p.getValue()));
        }
        return retval;
    }

    private static URI buildUri(HttpCollectionSet collectionSet) throws URISyntaxException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("ipaddr", InetAddressUtils.str((InetAddress)((InetAddress)collectionSet.getAgent().getAddress())));
        substitutions.put("nodeid", Integer.toString(collectionSet.getAgent().getNodeId()));
        URIBuilder ub = new URIBuilder();
        ub.setScheme(collectionSet.getUriDef().getUrl().getScheme());
        ub.setHost(HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getHost(), "getHost"));
        ub.setPort(collectionSet.getPort());
        ub.setPath(HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getPath(), "getURL"));
        String query = HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getQuery(), "getQuery");
        List params = URLEncodedUtils.parse((String)query, (Charset)Charset.forName("UTF-8"));
        ub.setParameters(params);
        ub.setFragment(HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getFragment(), "getFragment"));
        return ub.build();
    }

    private static String substituteKeywords(Map<String, String> substitutions, String urlFragment, String desc) {
        String newFragment = urlFragment;
        if (newFragment != null) {
            for (Map.Entry<String, String> entry : substitutions.entrySet()) {
                String key = entry.getKey();
                newFragment = newFragment.replaceAll("\\$\\{" + key + "\\}", entry.getValue());
            }
            if (LOG.isDebugEnabled() && newFragment.compareTo(urlFragment) != 0) {
                LOG.debug("doSubs: {} substituted as \"{}\"", (Object)desc, (Object)newFragment);
            }
        }
        return newFragment;
    }

    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        LOG.debug("initialize: Initializing HttpCollector.");
        HttpCollector.initHttpCollectionConfig();
        HttpCollector.initializeRrdRepository();
    }

    private static void initHttpCollectionConfig() {
        try {
            LOG.debug("initialize: Initializing collector: {}", (Object)HttpCollector.class.getSimpleName());
            HttpCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            LOG.error("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LOG.error("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            LOG.error("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void initializeRrdRepository() throws CollectionInitializationException {
        LOG.debug("initializeRrdRepository: Initializing RRD repo from HttpCollector...");
        HttpCollector.initializeRrdDirs();
    }

    private static void initializeRrdDirs() throws CollectionInitializationException {
        File f = new File(HttpCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            StringBuffer sb = new StringBuffer();
            sb.append("initializeRrdDirs: Unable to create RRD file repository.  Path doesn't already exist and could not make directory: ");
            sb.append(HttpCollectionConfigFactory.getInstance().getRrdPath());
            LOG.error(sb.toString());
            throw new CollectionInitializationException(sb.toString());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        LOG.debug("initialize: Initializing HTTP collection for agent: {}", (Object)agent);
    }

    public void release() {
    }

    public void release(CollectionAgent agent) {
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return HttpCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    static {
        ((DecimalFormat)PARSER).setParseBigDecimal(true);
        RRD_FORMATTER = NumberFormat.getNumberInstance();
        RRD_FORMATTER.setMinimumFractionDigits(0);
        RRD_FORMATTER.setMaximumFractionDigits(Integer.MAX_VALUE);
        RRD_FORMATTER.setMinimumIntegerDigits(1);
        RRD_FORMATTER.setMaximumIntegerDigits(Integer.MAX_VALUE);
        RRD_FORMATTER.setGroupingUsed(false);
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }

    private static class HttpCollectionAttributeType
    extends AbstractCollectionAttributeType {
        private final Attrib m_attribute;

        public HttpCollectionAttributeType(Attrib attribute, AttributeGroupType groupType) {
            super(groupType);
            this.m_attribute = attribute;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            if ("string".equalsIgnoreCase(this.m_attribute.getType())) {
                persister.persistStringAttribute(attribute);
            } else {
                persister.persistNumericAttribute(attribute);
            }
        }

        public String getName() {
            return this.m_attribute.getAlias();
        }

        public String getType() {
            return this.m_attribute.getType();
        }
    }

    private static class HttpCollectionResource
    implements CollectionResource {
        private final CollectionAgent m_agent;
        private final AttributeGroup m_attribGroup;

        public HttpCollectionResource(CollectionAgent agent, Uri uriDef) {
            this.m_agent = agent;
            this.m_attribGroup = new AttributeGroup((CollectionResource)this, new AttributeGroupType(uriDef.getName(), "all"));
        }

        public void storeResults(List<HttpCollectionAttribute> results) {
            for (HttpCollectionAttribute attrib : results) {
                this.m_attribGroup.addAttribute((CollectionAttribute)attrib);
            }
        }

        public boolean rescanNeeded() {
            return false;
        }

        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public String getOwnerName() {
            return this.m_agent.getHostAddress();
        }

        public Path getPath() {
            return this.m_agent.getStorageDir().toPath();
        }

        public void visit(CollectionSetVisitor visitor) {
            visitor.visitResource((CollectionResource)this);
            this.m_attribGroup.visit(visitor);
            visitor.completeResource((CollectionResource)this);
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }

        public String getInterfaceLabel() {
            return null;
        }

        public String getParent() {
            return this.m_agent.getStorageDir().toString();
        }

        public TimeKeeper getTimeKeeper() {
            return null;
        }
    }

    public static class HttpCollectorException
    extends RuntimeException {
        private static final long serialVersionUID = 4413332529546573490L;

        HttpCollectorException(String message) {
            super(message);
        }

        HttpCollectorException(String message, Throwable e) {
            super(message);
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.toString());
            buffer.append(": client URL: ");
            return buffer.toString();
        }
    }

    private static class HttpCollectionAttribute
    extends AbstractCollectionAttribute {
        private final Object m_value;

        public HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, Number value) {
            super((CollectionAttributeType)attribType, (CollectionResource)resource);
            this.m_value = value;
        }

        public HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, String value) {
            super((CollectionAttributeType)attribType, (CollectionResource)resource);
            this.m_value = value;
        }

        public Number getNumericValue() {
            if (this.m_value instanceof Number) {
                return (Number)this.m_value;
            }
            try {
                return Double.valueOf(this.m_value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.debug("Value for attribute {} does not appear to be a number, skipping", (Object)this);
                return null;
            }
        }

        public String getStringValue() {
            return this.m_value.toString();
        }

        public String getValueAsString() {
            if (this.m_value instanceof Number) {
                return RRD_FORMATTER.format(this.m_value);
            }
            return this.m_value.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof HttpCollectionAttribute) {
                HttpCollectionAttribute other = (HttpCollectionAttribute)((Object)obj);
                return this.getName().equals(other.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("HttpAttribute: ");
            buffer.append(this.getName());
            buffer.append(":");
            buffer.append(this.getType());
            buffer.append(":");
            buffer.append(this.getValueAsString());
            return buffer.toString();
        }

        public String getMetricIdentifier() {
            return "Not_Supported_Yet_HTTP_" + this.getAttributeType().getName();
        }
    }

    private static class HttpCollectionSet
    extends AbstractCollectionSet {
        private final CollectionAgent m_agent;
        private final Map<String, Object> m_parameters;
        private Uri m_uriDef;
        private int m_status;
        private List<HttpCollectionResource> m_collectionResourceList;
        private Date m_timestamp;

        public Uri getUriDef() {
            return this.m_uriDef;
        }

        public HttpCollectionSet(CollectionAgent agent, Map<String, Object> parameters) {
            this.m_agent = agent;
            this.m_parameters = parameters;
            this.m_status = 1;
        }

        public void collect() {
            String collectionName = ParameterMap.getKeyedString(this.m_parameters, (String)ServiceParameters.ParameterName.COLLECTION.toString(), null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(this.m_parameters, (String)ServiceParameters.ParameterName.HTTP_COLLECTION.toString(), null);
            }
            if (collectionName == null) {
                LOG.debug("no collection name found in parameters");
                this.m_status = 2;
                return;
            }
            HttpCollection collection = HttpCollectionConfigFactory.getInstance().getHttpCollection(collectionName);
            this.m_collectionResourceList = new ArrayList<HttpCollectionResource>();
            List uriDefs = collection.getUris().getUriCollection();
            Iterator iterator = uriDefs.iterator();
            while (iterator.hasNext()) {
                Uri uriDef;
                this.m_uriDef = uriDef = (Uri)iterator.next();
                HttpCollectionResource collectionResource = new HttpCollectionResource(this.m_agent, uriDef);
                try {
                    HttpCollector.doCollection(this, collectionResource);
                    this.m_collectionResourceList.add(collectionResource);
                }
                catch (HttpCollectorException e) {
                    LOG.warn("collect: http collection failed", (Throwable)e);
                    this.m_status = 2;
                }
            }
        }

        public CollectionAgent getAgent() {
            return this.m_agent;
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public int getStatus() {
            return this.m_status;
        }

        public void storeResults(List<HttpCollectionAttribute> results, HttpCollectionResource collectionResource) {
            collectionResource.storeResults(results);
        }

        public void visit(CollectionSetVisitor visitor) {
            visitor.visitCollectionSet((CollectionSet)this);
            for (HttpCollectionResource collectionResource : this.m_collectionResourceList) {
                collectionResource.visit(visitor);
            }
            visitor.completeCollectionSet((CollectionSet)this);
        }

        public Date getCollectionTimestamp() {
            return this.m_timestamp;
        }

        public void setCollectionTimestamp(Date timestamp) {
            this.m_timestamp = timestamp;
        }

        public int getPort() {
            int port = this.getUriDef().getUrl().getPort();
            if (port == 80 && this.m_parameters.containsKey(ServiceParameters.ParameterName.PORT.toString())) {
                try {
                    port = Integer.parseInt(this.m_parameters.get(ServiceParameters.ParameterName.PORT.toString()).toString());
                    LOG.debug("getPort: using service provided HTTP port {}", (Object)port);
                }
                catch (Exception e) {
                    LOG.warn("Malformed HTTP port on service definition.");
                }
            }
            return port;
        }
    }
}

