/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.nio.file.Path;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.snmp.SnmpInstId;

public class GenericIndexResource
extends SnmpCollectionResource {
    private final SnmpInstId m_inst;
    private final String m_name;
    private String m_resourceLabel;

    public GenericIndexResource(ResourceType def, String name, SnmpInstId inst) {
        super(def);
        this.m_name = name;
        this.m_inst = inst;
    }

    public Path getPath() {
        return this.getStrategy().getRelativePathForAttribute(this.getParent(), this.getInterfaceLabel());
    }

    public String toString() {
        return "node[" + this.getCollectionAgent().getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getInstance() + "]";
    }

    @Override
    public int getSnmpIfType() {
        return -1;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return ((GenericIndexResourceType)this.getResourceType()).getPersistenceSelectorStrategy().shouldPersist((CollectionResource)this);
    }

    public String getResourceTypeName() {
        return this.m_name;
    }

    public String getInstance() {
        return this.m_inst.toString();
    }

    private StorageStrategy getStrategy() {
        return ((GenericIndexResourceType)this.getResourceType()).getStorageStrategy();
    }

    public String getParent() {
        return this.getCollectionAgent().getStorageDir().toString();
    }

    public String getInterfaceLabel() {
        if (this.m_resourceLabel == null) {
            this.m_resourceLabel = this.getStrategy().getResourceNameFromIndex((CollectionResource)this);
        }
        return this.m_resourceLabel;
    }
}

