/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogConnection
implements Callable<Callable<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogConnection.class);
    private final DatagramPacket _packet;
    private final String _matchPattern;
    private final int _hostGroup;
    private final int _messageGroup;
    private final String _discardUei;
    private final UeiList _ueiList;
    private final HideMessage _hideMessages;

    public SyslogConnection(DatagramPacket packet, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this._packet = SyslogConnection.copyPacket(packet);
        this._matchPattern = matchPattern;
        this._hostGroup = hostGroup;
        this._messageGroup = messageGroup;
        this._discardUei = discardUei;
        this._ueiList = ueiList;
        this._hideMessages = hideMessages;
    }

    public SyslogConnection(InetSocketAddress source, ByteBuffer buffer, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this._packet = SyslogConnection.copyPacket(source, buffer);
        this._matchPattern = matchPattern;
        this._hostGroup = hostGroup;
        this._messageGroup = messageGroup;
        this._discardUei = discardUei;
        this._ueiList = ueiList;
        this._hideMessages = hideMessages;
    }

    @Override
    public SyslogProcessor call() {
        ConvertToEvent re = null;
        try {
            re = ConvertToEvent.make(this._packet, this._matchPattern, this._hostGroup, this._messageGroup, this._ueiList, this._hideMessages, this._discardUei);
            LOG.debug("Sending received packet to the SyslogProcessor queue");
            return new SyslogProcessor(re);
        }
        catch (UnsupportedEncodingException e1) {
            LOG.debug("Failure to convert package", (Throwable)e1);
        }
        catch (MessageDiscardedException e) {
            LOG.debug("Message discarded, returning without enqueueing event.", (Throwable)e);
        }
        return null;
    }

    private static DatagramPacket copyPacket(DatagramPacket packet) {
        byte[] message = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, message, 0, packet.getLength());
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(packet.getAddress().getHostName(), packet.getAddress().getAddress());
            DatagramPacket retPacket = new DatagramPacket(message, packet.getOffset(), packet.getLength(), addr, packet.getPort());
            return retPacket;
        }
        catch (UnknownHostException e) {
            LOG.warn("unable to clone InetAddress object for {}", (Object)packet.getAddress());
            return null;
        }
    }

    private static DatagramPacket copyPacket(InetSocketAddress source, ByteBuffer buffer) {
        byte[] message = new byte[65535];
        int i = 0;
        while (buffer.hasRemaining()) {
            message[i++] = buffer.get();
        }
        DatagramPacket retPacket = new DatagramPacket(message, 0, i, source.getAddress(), source.getPort());
        return retPacket;
    }
}

