/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.ReadonlyContext;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.jmx.MBeanServer;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.jmx.JmxUtils;
import org.opennms.netmgt.jmx.connection.JmxConnectionManager;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultConnectionManager;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.jmx.wrappers.ObjectNameWrapper;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public abstract class JMXMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JMXMonitor.class);
    private static final JexlEngine JEXL_ENGINE = new JexlEngine();
    public static final String PARAM_BEAN_PREFIX = "beans.";
    public static final String PARAM_TEST_PREFIX = "tests.";
    public static final String PARAM_TEST = "test";
    public static final String PARAM_PORT = "port";
    protected JmxConfigDao m_jmxConfigDao = null;

    protected abstract String getConnectionName();

    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        MBeanServer mBeanServer;
        if (this.m_jmxConfigDao == null) {
            this.m_jmxConfigDao = (JmxConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jmxConfigDao", JmxConfigDao.class);
        }
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (map.containsKey(PARAM_PORT) && (mBeanServer = this.m_jmxConfigDao.getConfig().lookupMBeanServer(InetAddrUtils.str((InetAddress)ipv4Addr), ParameterMap.getKeyedInteger(map, (String)PARAM_PORT, (int)-1))) != null) {
            map.putAll(mBeanServer.getParameterMap());
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        try {
            final Timer timer = new Timer();
            DefaultConnectionManager connectionManager = new DefaultConnectionManager(ParameterMap.getKeyedInteger(map, (String)"retry", (int)3));
            JmxConnectionManager.RetryCallback retryCallback = new JmxConnectionManager.RetryCallback(){

                public void onRetry() {
                    timer.reset();
                }
            };
            try (JmxServerConnectionWrapper connection = connectionManager.connect(this.getConnectionName(), InetAddrUtils.str((InetAddress)ipv4Addr), JmxUtils.convertToStringMap(map), retryCallback);){
                connection.getMBeanServerConnection().getMBeanCount();
                long nanoResponseTime = System.nanoTime() - timer.getStartTime();
                HashMap variables = Maps.newHashMap();
                for (String string : map.keySet()) {
                    if (!string.startsWith(PARAM_BEAN_PREFIX)) continue;
                    String variable = string.substring(PARAM_BEAN_PREFIX.length());
                    String definition = ParameterMap.getKeyedString(map, (String)string, null);
                    variables.put(variable, ObjectNameWrapper.create(connection.getMBeanServerConnection(), definition));
                }
                HashMap tests = Maps.newHashMap();
                for (String key : map.keySet()) {
                    if (!key.startsWith(PARAM_TEST_PREFIX)) continue;
                    String variable = key.substring(PARAM_TEST_PREFIX.length());
                    String definition = ParameterMap.getKeyedString(map, (String)key, null);
                    Expression expression = JEXL_ENGINE.createExpression(definition);
                    tests.put(variable, expression);
                }
                if (map.containsKey(PARAM_TEST)) {
                    String string = ParameterMap.getKeyedString(map, (String)PARAM_TEST, null);
                    Expression expression = JEXL_ENGINE.createExpression(string);
                    tests.put(null, expression);
                }
                ReadonlyContext readonlyContext = new ReadonlyContext((JexlContext)new MapContext((Map)variables));
                serviceStatus = PollStatus.up((Double)((double)nanoResponseTime / 1000000.0));
                for (Map.Entry e : tests.entrySet()) {
                    if (((Boolean)((Expression)e.getValue()).evaluate((JexlContext)readonlyContext)).booleanValue()) continue;
                    serviceStatus = PollStatus.down((String)("Test failed: " + (String)e.getKey()));
                    break;
                }
            }
            catch (JmxServerConnectionException mbse) {
                String reason = "IOException while polling address: " + ipv4Addr;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
        }
        catch (Throwable e) {
            String reason = "Monitor - failed! " + InetAddressUtils.str((InetAddress)ipv4Addr);
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable((String)reason);
        }
        return serviceStatus;
    }

    static {
        JEXL_ENGINE.setLenient(false);
        JEXL_ENGINE.setStrict(true);
    }

    private class Timer {
        private long startTime;

        private Timer() {
            this.reset();
        }

        public void reset() {
            this.startTime = System.nanoTime();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

