/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.GtRestriction;
import org.opennms.core.criteria.restrictions.LeRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.rtc.AvailabilityService;
import org.opennms.netmgt.rtc.RTCUtils;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.xml.rtc.Category;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.opennms.netmgt.xml.rtc.Header;
import org.opennms.netmgt.xml.rtc.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class AvailabilityServiceHibernateImpl
implements AvailabilityService {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityServiceHibernateImpl.class);
    @Autowired
    private FilterDao m_filterDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private OutageDao m_outageDao;

    @Override
    public Map<String, RTCCategory> getCategories() {
        return RTCUtils.createCategoriesMap();
    }

    @Override
    @Transactional(readOnly=true)
    public synchronized EuiLevel getEuiLevel(RTCCategory category) {
        Header header = new Header();
        header.setVer("1.9a");
        header.setMstation("");
        Date curDate = new Date();
        long curTime = curDate.getTime();
        long rWindow = 86400000L;
        LOG.debug("Retrieving availability statistics for {} with current date: {} and rolling window: {}", new Object[]{category.getLabel(), curDate, 86400000L});
        EuiLevel level = new EuiLevel();
        header.setCreated(EventConstants.formatToString((Date)curDate));
        level.setHeader(header);
        Category levelCat = new Category();
        levelCat.setCatlabel(category.getLabel());
        double outageTimeInCategory = 0.0;
        int numServicesInCategory = 0;
        Date windowStart = new Date(curTime - 86400000L);
        Date windowEnd = new Date(curTime);
        List<Integer> nodeIds = this.getNodes(category);
        List serviceNames = category.getServiceCollection();
        Map<Integer, List<OnmsOutage>> outagesByNode = this.getOutages(nodeIds, serviceNames, windowStart, windowEnd);
        for (int nodeId : nodeIds) {
            ArrayList outages = outagesByNode.get(nodeId);
            if (outages == null) {
                outages = Lists.newArrayList();
            }
            double outageTime = AvailabilityServiceHibernateImpl.getOutageTimeInWindow(outages, windowStart, windowEnd);
            int numServices = this.getNumServices(nodeId, serviceNames);
            long numServicesDown = outages.stream().filter(outage -> outage.getIfRegainedService() == null).count();
            Node levelNode = new Node();
            levelNode.setNodeid((long)nodeId);
            levelNode.setNodevalue(RTCUtils.getOutagePercentage(outageTime, 86400000L, numServices));
            levelNode.setNodesvccount((long)numServices);
            levelNode.setNodesvcdowncount(numServicesDown);
            levelCat.getNode().add(levelNode);
            numServicesInCategory += numServices;
            outageTimeInCategory += outageTime;
        }
        levelCat.setCatvalue(RTCUtils.getOutagePercentage(outageTimeInCategory, 86400000L, numServicesInCategory));
        level.getCategory().add(levelCat);
        LOG.debug("Done retrieving availability statistics for {} with {} services.", (Object)category.getLabel(), (Object)numServicesInCategory);
        return level;
    }

    private static double getOutageTimeInWindow(List<OnmsOutage> outages, Date start, Date end) {
        if (outages == null || outages.size() == 0) {
            return 0.0;
        }
        long windowStart = start.getTime();
        long windowEnd = end.getTime();
        long windowLength = windowEnd - windowStart;
        Preconditions.checkArgument((0L <= windowStart && windowStart < windowEnd ? 1 : 0) != 0);
        long downtimeInWindow = 0L;
        for (OnmsOutage outage : outages) {
            long lostAt = Math.max(windowStart, outage.getIfLostService().getTime());
            long regainedAt = outage.getIfRegainedService() == null ? windowEnd : Math.min(windowEnd, outage.getIfRegainedService().getTime());
            downtimeInWindow += regainedAt - lostAt;
        }
        return Math.min(downtimeInWindow, windowLength);
    }

    private int getNumServices(int nodeId, List<String> serviceNames) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsMonitoredService.class).alias("ipInterface", "ipInterface").alias("ipInterface.node", "node").eq("ipInterface.isManaged", (Object)"M").eq("node.id", (Object)nodeId);
        if (serviceNames != null && serviceNames.size() > 0) {
            builder.alias("serviceType", "serviceType").in("serviceType.name", serviceNames);
        }
        return this.m_monitoredServiceDao.countMatching(builder.toCriteria());
    }

    private Map<Integer, List<OnmsOutage>> getOutages(List<Integer> nodeIds, List<String> serviceNames, Date start, Date end) {
        if (nodeIds == null || nodeIds.size() == 0) {
            return Maps.newHashMap();
        }
        CriteriaBuilder builder = new CriteriaBuilder(OnmsOutage.class).le("ifLostService", (Object)end).or(new Restriction[]{new NullRestriction("ifRegainedService"), new AllRestriction(new Restriction[]{new GtRestriction("ifRegainedService", (Object)start), new LeRestriction("ifRegainedService", (Object)end)})}).alias("monitoredService", "monitoredService").alias("monitoredService.ipInterface", "ipInterface").alias("ipInterface.node", "node").eq("ipInterface.isManaged", (Object)"M").in("node.id", nodeIds);
        if (serviceNames != null && serviceNames.size() > 0) {
            builder.alias("monitoredService.serviceType", "serviceType").in("serviceType.name", serviceNames);
        }
        return this.m_outageDao.findMatching(builder.toCriteria()).stream().collect(Collectors.groupingBy(outage -> outage.getNodeId()));
    }

    private List<Integer> getNodes(RTCCategory category) {
        category.clearNodes();
        category.addAllNodes(RTCUtils.getNodeIdsForCategory(this.m_filterDao, category));
        return category.getNodes();
    }
}

