/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;

public class OspfIpAddrTableGetter
extends TableTracker {
    public static final SnmpObjId IPADENT_IFINDEX = SnmpObjId.get((String)".1.3.6.1.2.1.4.20.1.2");
    public static final SnmpObjId IPADENT_NETMASK = SnmpObjId.get((String)".1.3.6.1.2.1.4.20.1.3");
    private SnmpAgentConfig m_agentConfig;

    public OspfIpAddrTableGetter(SnmpAgentConfig peer) {
        super(new SnmpObjId[0]);
        this.m_agentConfig = peer;
    }

    public OspfElement get(OspfElement element) {
        element.setOspfRouterIdNetmask(InetAddressUtils.addr((String)"255.255.255.255"));
        SnmpValue[] val = this.get(element.getOspfRouterId());
        if (val != null && val.length == 2) {
            if (!val[0].isNull() && val[0].isNumeric()) {
                element.setOspfRouterIdIfindex(Integer.valueOf(val[0].toInt()));
            }
            if (!val[1].isNull() && !val[1].isError()) {
                try {
                    element.setOspfRouterIdNetmask(val[1].toInetAddress());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return element;
    }

    public OspfLink get(OspfLink link) {
        link.setOspfIpMask(InetAddressUtils.addr((String)"255.255.255.252"));
        SnmpValue[] val = this.get(link.getOspfIpAddr());
        if (val != null && val.length == 2) {
            if (!val[0].isNull() && val[0].isNumeric()) {
                link.setOspfIfIndex(Integer.valueOf(val[0].toInt()));
            }
            if (!val[1].isNull() && !val[1].isError()) {
                try {
                    link.setOspfIpMask(val[1].toInetAddress());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return link;
    }

    private SnmpValue[] get(InetAddress addr) {
        SnmpObjId instance = SnmpObjId.get((String)addr.getHostAddress());
        SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((SnmpObjId)IPADENT_IFINDEX, (SnmpObjId)instance), SnmpObjId.get((SnmpObjId)IPADENT_NETMASK, (SnmpObjId)instance)};
        return SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId[])oids);
    }
}

