/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.OspfGeneralGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIfTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIpAddrTableGetter;
import org.opennms.netmgt.enlinkd.snmp.OspfNbrTableTracker;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryOspf
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryOspf.class);

    public NodeDiscoveryOspf(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        String trackerName = "ospfGeneralGroup";
        OspfGeneralGroupTracker ospfGeneralGroup = new OspfGeneralGroupTracker();
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)ospfGeneralGroup);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Ospf Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Ospf Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Ospf Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId() == null) {
            LOG.info("run: node[{}]: address {}. ospf mib not supported", (Object)this.getNodeId(), (Object)this.getPrimaryIpAddressString());
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId().equals(InetAddressUtils.addr((String)"0.0.0.0"))) {
            LOG.info("run: node[{}]: address {}. ospf identifier 0.0.0.0 is not valid", (Object)this.getNodeId(), (Object)this.getPrimaryIpAddressString());
            return;
        }
        if (OspfElement.Status.get((Integer)ospfGeneralGroup.getOspfAdminStat()) == OspfElement.Status.disabled) {
            LOG.info("run: node[{}]: address {}. ospf status: disabled", (Object)this.getNodeId(), (Object)this.getPrimaryIpAddressString());
            return;
        }
        final OspfIpAddrTableGetter ipAddrTableGetter = new OspfIpAddrTableGetter(this.getPeer());
        this.m_linkd.getQueryManager().store(this.getNodeId(), ipAddrTableGetter.get(ospfGeneralGroup.getOspfElement()));
        trackerName = "ospfNbrTable";
        final ArrayList links = new ArrayList();
        OspfNbrTableTracker ospfNbrTableTracker = new OspfNbrTableTracker(){

            @Override
            public void processOspfNbrRow(OspfNbrTableTracker.OspfNbrRow row) {
                links.add(row.getOspfLink());
            }
        };
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)ospfNbrTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Ospf Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Ospf Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        trackerName = "ospfIfTable";
        OspfIfTableTracker ospfIfTableTracker = new OspfIfTableTracker(){

            @Override
            public void processOspfIfRow(OspfIfTableTracker.OspfIfRow row) {
                OspfLink link = row.getOspfLink(ipAddrTableGetter);
                for (OspfLink nbrlink : links) {
                    if (!InetAddressUtils.inSameNetwork((InetAddress)link.getOspfIpAddr(), (InetAddress)nbrlink.getOspfRemIpAddr(), (InetAddress)link.getOspfIpMask())) continue;
                    nbrlink.setOspfIpAddr(link.getOspfIpAddr());
                    nbrlink.setOspfAddressLessIndex(link.getOspfAddressLessIndex());
                    nbrlink.setOspfIpMask(link.getOspfIpMask());
                    nbrlink.setOspfIfIndex(link.getOspfIfIndex());
                }
            }
        };
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)ospfIfTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Ospf Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Ospf Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        for (OspfLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), link);
        }
        this.m_linkd.getQueryManager().reconcileOspf(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "OspfLinkDiscovery";
    }
}

