/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.Date;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryLldp
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryLldp.class);
    private static final String DW_SYSOID = ".1.3.6.1.4.1.7262.2.4";
    private static final String DW_NULL_CHASSIS_ID = "cf";
    private static final String DW_NULL_SYSOID_ID = "NuDesign";

    public NodeDiscoveryLldp(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        String trackerName = "lldpLocalGroup";
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)lldpLocalGroup);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Lldp Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Lldp Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Lldp Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (lldpLocalGroup.getLldpLocChassisid() == null) {
            LOG.info("run: node[{}]: address {}. LLDP_MIB not supported", (Object)this.getNodeId(), (Object)this.getPrimaryIpAddressString());
            return;
        }
        LOG.info("run: node[{}]: address {}. lldp identifier : {}", new Object[]{this.getNodeId(), this.getPrimaryIpAddressString(), lldpLocalGroup.getLldpElement()});
        this.m_linkd.getQueryManager().store(this.getNodeId(), lldpLocalGroup.getLldpElement());
        if (this.getSysoid() == null || this.getSysoid().equals(DW_SYSOID)) {
            if (lldpLocalGroup.getLldpLocChassisid().toHexString().equals(DW_NULL_CHASSIS_ID) && lldpLocalGroup.getLldpLocChassisidSubType() == LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT.getValue()) {
                LOG.info("run: node[{}]: address {}. lldp identifier : {}. lldp not active for Dragon Wave Device.", new Object[]{this.getNodeId(), this.getPrimaryIpAddressString(), lldpLocalGroup.getLldpElement()});
                return;
            }
            if (lldpLocalGroup.getLldpLocSysname().equals(DW_NULL_SYSOID_ID)) {
                LOG.info("run: node[{}]: address {}. lldp identifier : {}. lldp not active for Dragon Wave Device.", new Object[]{this.getNodeId(), this.getPrimaryIpAddressString(), lldpLocalGroup.getLldpElement()});
                return;
            }
        }
        final LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(this.getPeer());
        trackerName = "lldpRemTable";
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            @Override
            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                NodeDiscoveryLldp.this.m_linkd.getQueryManager().store(NodeDiscoveryLldp.this.getNodeId(), row.getLldpLink(lldpLocPort));
            }
        };
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)lldpRemTable);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        this.m_linkd.getQueryManager().reconcileLldp(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "LldpLinkDiscovery";
    }
}

