/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.IsisCircTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisISAdjTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisSysObjectGroupTracker;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIsis
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIsis.class);

    public NodeDiscoveryIsis(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        String trackerName = "isisSysObjectCollection";
        IsisSysObjectGroupTracker isisSysObject = new IsisSysObjectGroupTracker();
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)isisSysObject);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Is-Is Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Is-Is Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Is-Is Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (isisSysObject.getIsisSysId() == null) {
            LOG.info("run: node[{}]: address {}. Is-Is mib not supported ", (Object)this.getNodeId(), (Object)this.getPrimaryIpAddressString());
            return;
        }
        this.m_linkd.getQueryManager().store(this.getNodeId(), isisSysObject.getIsisElement());
        final ArrayList links = new ArrayList();
        trackerName = "isisISAdjTable";
        IsisISAdjTableTracker isisISAdjTableTracker = new IsisISAdjTableTracker(){

            @Override
            public void processIsisAdjRow(IsisISAdjTableTracker.IsIsAdjRow row) {
                links.add(row.getIsisLink());
            }
        };
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)isisISAdjTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Is-Is Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Is-Is Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Is-Is Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        trackerName = "isisCircTable";
        IsisCircTableTracker isisCircTableTracker = new IsisCircTableTracker(){

            @Override
            public void processIsisCircRow(IsisCircTableTracker.IsIsCircRow row) {
                IsIsLink link = row.getIsisLink();
                for (IsIsLink adjlink : links) {
                    if (link.getIsisCircIndex().intValue() != adjlink.getIsisCircIndex().intValue()) continue;
                    adjlink.setIsisCircIfIndex(link.getIsisCircIfIndex());
                    adjlink.setIsisCircAdminState(link.getIsisCircAdminState());
                }
            }
        };
        LOG.info("run: node[{}]: collecting {} on: {}", new Object[]{this.getNodeId(), trackerName, this.getPrimaryIpAddressString()});
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)isisCircTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Is-Is Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Is-Is Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Is-Is Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        for (IsIsLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), link);
        }
        this.m_linkd.getQueryManager().reconcileIsis(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "IsisLinkDiscovery";
    }
}

