/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpVlanTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBasePortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryBridge
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridge.class);

    public NodeDiscoveryBridge(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        LOG.info("run: start discovery operations for node: [{}]", (Object)this.getNodeId());
        Date now = new Date();
        Map<Integer, String> vlanmap = this.getVtpVlanMap(this.getPeer());
        if (vlanmap.isEmpty()) {
            vlanmap.put(null, null);
        }
        List<BridgeMacLink> bft = new ArrayList<BridgeMacLink>();
        HashMap<Integer, Integer> bridgeifindex = new HashMap<Integer, Integer>();
        String community = this.getPeer().getReadCommunity();
        for (Map.Entry<Integer, String> entry : vlanmap.entrySet()) {
            LOG.debug("run: node [{}] cisco vtp: setting peer community for VLAN {}", (Object)this.getNodeId(), (Object)entry.getValue());
            SnmpAgentConfig peer = this.getPeer();
            if (entry.getKey() != null) {
                peer.setReadCommunity(community + "@" + entry.getKey());
            }
            LOG.debug("run: walking dot1d basedata on node [{}}, vlan [{}], vlanname {}.", new Object[]{this.getNodeId(), entry.getKey(), entry.getValue()});
            BridgeElement bridge = this.getDot1dBridgeBase(peer);
            if (bridge == null) {
                LOG.debug("run: no dot1d data found on node [{}], vlan [{}], vlanname {}. skipping other operations", new Object[]{this.getNodeId(), entry.getKey(), entry.getValue()});
                continue;
            }
            bridge.setVlan(entry.getKey());
            bridge.setVlanname(entry.getValue());
            this.m_linkd.getQueryManager().store(this.getNodeId(), bridge);
            Map<Integer, Integer> vlanbridgetoifindex = this.walkDot1dBasePortTable(peer);
            LOG.debug("run: found on node: [{}] vlan: [{}], bridge ifindex map {}", new Object[]{this.getNodeId(), entry.getValue(), vlanbridgetoifindex});
            if (!InetAddressUtils.isValidStpBridgeId((String)bridge.getStpDesignatedRoot())) {
                LOG.info("run: node [{}]: invalid designated root: spanning tree not supported.", (Object)this.getNodeId());
            } else if (bridge.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()))) {
                LOG.info("run: node [{}]: designated root {} is itself. Skipping store.", (Object)this.getNodeId(), (Object)bridge.getStpDesignatedRoot());
            } else {
                for (BridgeStpLink stplink : this.walkSpanningTree(peer, bridge.getBaseBridgeAddress())) {
                    stplink.setVlan(entry.getKey());
                    stplink.setStpPortIfIndex(vlanbridgetoifindex.get(stplink.getStpPort()));
                    this.m_linkd.getQueryManager().store(this.getNodeId(), stplink);
                }
            }
            bridgeifindex.putAll(vlanbridgetoifindex);
            bft = this.walkDot1dTpFdp(entry.getKey(), bridgeifindex, bft, peer);
        }
        LOG.debug("run: node [{}]: bridge ifindex map {}", (Object)this.getNodeId(), bridgeifindex);
        bft = this.walkDot1qTpFdb(this.getPeer(), bridgeifindex, bft);
        LOG.debug("run: node [{}]: bft size:{}", (Object)this.getNodeId(), (Object)bft.size());
        if (bft.size() > 0) {
            LOG.debug("run: node [{}]: updating topology", (Object)this.getNodeId());
            this.m_linkd.getQueryManager().store(this.getNodeId(), bft);
            this.m_linkd.scheduleBridgeTopologyDiscovery(this.getNodeId());
        }
        LOG.debug("run: node [{}]: deleting older the time {}", (Object)this.getNodeId(), (Object)now);
        this.m_linkd.collectedBft(this.getNodeId());
        this.m_linkd.getQueryManager().reconcileBridge(this.getNodeId(), now);
        LOG.info("run: end: node discovery operations for bridge: '{}'", (Object)this.getNodeId());
    }

    private BridgeElement getDot1dBridgeBase(SnmpAgentConfig peer) {
        String trackerName = "dot1dbase";
        Dot1dBaseTracker dot1dbase = new Dot1dBaseTracker();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)dot1dbase);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return null;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return null;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return null;
        }
        BridgeElement bridge = dot1dbase.getBridgeElement();
        if (bridge.getBaseBridgeAddress() == null) {
            LOG.info("run: node [{}]: base bridge address is null. BRIDGE_MIB not supported.", (Object)this.getNodeId());
            return null;
        }
        if (!InetAddressUtils.isValidBridgeAddress((String)bridge.getBaseBridgeAddress())) {
            LOG.info("run: node [{}]: base bridge address {} is not valid on. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        if (bridge.getBaseNumPorts() == null || bridge.getBaseNumPorts() == 0) {
            LOG.info("run: node [{}]: base bridge address {}: has 0 port active. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        LOG.info("run: bridge {} has is if type {}, on: {}", new Object[]{dot1dbase.getBridgeAddress(), BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)dot1dbase.getBridgeType()), this.getNodeId()});
        if (bridge.getBaseType() == BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_SOURCEROUTE_ONLY) {
            LOG.info("run: node [{}]: base bridge address {}: is source route bridge only. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        return bridge;
    }

    private Map<Integer, String> getVtpVlanMap(SnmpAgentConfig peer) {
        final HashMap<Integer, String> vlanmap = new HashMap<Integer, String>();
        String trackerName = "vtpVersion";
        CiscoVtpTracker vtpStatus = new CiscoVtpTracker();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)vtpStatus);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return vlanmap;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return vlanmap;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return vlanmap;
        }
        if (vtpStatus.getVtpVersion() == null) {
            LOG.info("run: node [{}]: cisco vtp mib not supported.", (Object)this.getNodeId());
            return vlanmap;
        }
        LOG.info("run: node [{}]: cisco vtp mib supported.", (Object)this.getNodeId());
        LOG.debug("run: node [{}]: walking cisco vtp.", (Object)this.getNodeId());
        trackerName = "ciscoVtpVlan";
        CiscoVtpVlanTableTracker ciscoVtpVlanTableTracker = new CiscoVtpVlanTableTracker(){

            @Override
            public void processCiscoVtpVlanRow(CiscoVtpVlanTableTracker.CiscoVtpVlanRow row) {
                if (row.isTypeEthernet() && row.isStatusOperational()) {
                    vlanmap.put(row.getVlanIndex(), row.getVlanName());
                }
            }
        };
        walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)ciscoVtpVlanTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
        return vlanmap;
    }

    private Map<Integer, Integer> walkDot1dBasePortTable(SnmpAgentConfig peer) {
        final HashMap<Integer, Integer> bridgetoifindex = new HashMap<Integer, Integer>();
        String trackerName = "dot1dBasePortTable";
        Dot1dBasePortTableTracker dot1dBasePortTableTracker = new Dot1dBasePortTableTracker(){

            @Override
            public void processDot1dBasePortRow(Dot1dBasePortTableTracker.Dot1dBasePortRow row) {
                bridgetoifindex.put(row.getBaseBridgePort(), row.getBaseBridgePortIfindex());
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)dot1dBasePortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
        return bridgetoifindex;
    }

    private List<BridgeMacLink> walkDot1dTpFdp(final Integer vlan, final Map<Integer, Integer> bridgeifindex, final List<BridgeMacLink> bft, SnmpAgentConfig peer) {
        String trackerName = "dot1dTbFdbPortTable";
        Dot1dTpFdbTableTracker stpPortTableTracker = new Dot1dTpFdbTableTracker(){

            @Override
            public void processDot1dTpFdbRow(Dot1dTpFdbTableTracker.Dot1dTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.warn("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {}. row has null status. ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.warn("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} status {}. row has null bridge port.  ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.warn("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row has invalid mac.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setVlan(vlan);
                if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    LOG.warn("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row has invalid bridge port. no ifindex found. ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row processed.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)stpPortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return bft;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return bft;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return bft;
        }
        return bft;
    }

    private List<BridgeMacLink> walkDot1qTpFdb(SnmpAgentConfig peer, final Map<Integer, Integer> bridgeifindex, final List<BridgeMacLink> bft) {
        String trackerName = "dot1qTbFdbPortTable";
        Dot1qTpFdbTableTracker dot1qTpFdbTableTracker = new Dot1qTpFdbTableTracker(){

            @Override
            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.warn("processDot1qTpFdbRow: node [{}]: mac {}: on port {}. row has null status.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.warn("processDot1qTpFdbRow: node [{}]: mac {}: on port {} status {}. row has null bridge port.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.warn("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. row has invalid mac.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    LOG.warn("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. row has invalid bridgeport. No ifindex found.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row processed.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)dot1qTpFdbTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return bft;
        }
        return bft;
    }

    private List<BridgeStpLink> walkSpanningTree(SnmpAgentConfig peer, final String baseBridgeAddress) {
        String trackerName = "dot1dStpPortTable";
        final ArrayList<BridgeStpLink> stplinks = new ArrayList<BridgeStpLink>();
        Dot1dStpPortTableTracker stpPortTableTracker = new Dot1dStpPortTableTracker(){

            @Override
            public void processDot1dStpPortRow(Dot1dStpPortTableTracker.Dot1dStpPortRow row) {
                BridgeStpLink link = row.getLink();
                LOG.debug("processDot1dStpPortRow: node [{}]: stp: port:{}/{}, vlan:{}, designated root/bridge/port:{}/{}/{}.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getStpPort(), link.getStpPortState(), link.getVlan(), link.getDesignatedRoot(), link.getDesignatedBridge(), link.getDesignatedPort()});
                if (InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedRoot()) && InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedBridge()) && !baseBridgeAddress.equals(link.getDesignatedBridgeAddress())) {
                    LOG.debug("processDot1dStpPortRow: node [{}]: stp: port:{}/{}, vlan:{}, designated root/bridge/port:{}/{}/{}. row added", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getStpPort(), link.getStpPortState(), link.getVlan(), link.getDesignatedRoot(), link.getDesignatedBridge(), link.getDesignatedPort()});
                    stplinks.add(link);
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)peer, (String)trackerName, (CollectionTracker)stpPortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
        return stplinks;
    }

    @Override
    public String getName() {
        return "BridgeLinkDiscovery";
    }

    @Override
    public boolean isReady() {
        return this.m_linkd.collectBft(this.getNodeId());
    }
}

