/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.util.Date;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionFailed;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectionTimedOut;
import org.opennms.netmgt.collectd.CollectionUnknown;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.CollectorUpdates;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.AttributeGroupWrapper;
import org.opennms.netmgt.collection.support.CollectionAttributeWrapper;
import org.opennms.netmgt.collection.support.CollectionResourceWrapper;
import org.opennms.netmgt.collection.support.CollectionSetVisitorWrapper;
import org.opennms.netmgt.collection.support.ConstantTimeKeeper;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.threshd.ThresholdingVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

class CollectableService
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(CollectableService.class);
    protected static final String STRICT_INTERVAL_SYS_PROP = "org.opennms.netmgt.collectd.strictInterval";
    protected static final String USE_COLLECTION_START_TIME_SYS_PROP = "org.opennms.netmgt.collectd.useCollectionStartTime";
    private final boolean m_usingStrictInterval = Boolean.getBoolean("org.opennms.netmgt.collectd.strictInterval");
    private volatile int m_nodeId;
    private volatile int m_status;
    private volatile long m_lastScheduledCollectionTime;
    private final Scheduler m_scheduler;
    private final CollectorUpdates m_updates;
    private final ThresholdingVisitor m_thresholdVisitor;
    private static final boolean ABORT_COLLECTION = true;
    private final CollectionSpecification m_spec;
    private final Collectd.SchedulingCompletedFlag m_schedulingCompletedFlag;
    private volatile CollectionAgent m_agent;
    private final PlatformTransactionManager m_transMgr;
    private final IpInterfaceDao m_ifaceDao;
    private final ServiceParameters m_params;
    private final RrdRepository m_repository;
    private final PersisterFactory m_persisterFactory;
    private final ResourceStorageDao m_resourceStorageDao;

    protected CollectableService(OnmsIpInterface iface, IpInterfaceDao ifaceDao, CollectionSpecification spec, Scheduler scheduler, Collectd.SchedulingCompletedFlag schedulingCompletedFlag, PlatformTransactionManager transMgr, PersisterFactory persisterFactory, ResourceStorageDao resourceStorageDao) throws CollectionInitializationException {
        this.m_agent = DefaultCollectionAgent.create(iface.getId(), ifaceDao, transMgr);
        this.m_spec = spec;
        this.m_scheduler = scheduler;
        this.m_schedulingCompletedFlag = schedulingCompletedFlag;
        this.m_ifaceDao = ifaceDao;
        this.m_transMgr = transMgr;
        this.m_persisterFactory = persisterFactory;
        this.m_resourceStorageDao = resourceStorageDao;
        this.m_nodeId = iface.getNode().getId();
        this.m_status = 1;
        this.m_updates = new CollectorUpdates();
        this.m_lastScheduledCollectionTime = 0L;
        this.m_spec.initialize(this.m_agent);
        this.m_params = this.m_spec.getServiceParameters();
        this.m_repository = this.m_spec.getRrdRepository(this.m_params.getCollectionName());
        this.m_thresholdVisitor = ThresholdingVisitor.create(this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), this.m_repository, this.m_params, this.m_resourceStorageDao);
    }

    public InetAddress getAddress() {
        return (InetAddress)this.m_agent.getAddress();
    }

    public CollectionSpecification getSpecification() {
        return this.m_spec;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getServiceName() {
        return this.m_spec.getServiceName();
    }

    public String getPackageName() {
        return this.m_spec.getPackageName();
    }

    public CollectorUpdates getCollectorUpdates() {
        return this.m_updates;
    }

    public void refreshPackage(CollectdConfigFactory collectorConfigDao) {
        this.m_spec.refresh(collectorConfigDao);
        if (this.m_thresholdVisitor != null) {
            this.m_thresholdVisitor.reloadScheduledOutages();
        }
    }

    public String toString() {
        return "CollectableService for service " + this.m_nodeId + ':' + this.getAddress() + ':' + this.getServiceName();
    }

    @Override
    public boolean isReady() {
        boolean ready = false;
        if (!this.isSchedulingComplete()) {
            return false;
        }
        ready = this.m_spec.getInterval() < 1L ? true : this.m_spec.getInterval() - (System.currentTimeMillis() - this.m_lastScheduledCollectionTime) < 1L;
        return ready;
    }

    private boolean isSchedulingComplete() {
        return this.m_schedulingCompletedFlag.isSchedulingCompleted();
    }

    private void sendEvent(String uei, String reason) {
        EventBuilder builder = new EventBuilder(uei, "OpenNMS.Collectd");
        builder.setNodeid((long)this.m_nodeId);
        builder.setInterface((InetAddress)this.m_agent.getAddress());
        builder.setService(this.m_spec.getServiceName());
        builder.setHost(InetAddressUtils.getLocalHostName());
        if (reason != null) {
            builder.addParam("reason", reason);
        }
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(builder.getEvent());
            LOG.debug("sendEvent: Sent event {} for {}/{}/{}", new Object[]{uei, this.m_nodeId, this.getHostAddress(), this.getServiceName()});
        }
        catch (Throwable e) {
            LOG.error("Failed to send the event {} for interface {}", new Object[]{uei, this.getHostAddress(), e});
        }
    }

    private String getHostAddress() {
        return this.m_agent.getHostAddress();
    }

    @Override
    public void run() {
        Logging.withPrefix((String)"collectd", (Runnable)new Runnable(){

            @Override
            public void run() {
                Logging.putThreadContext((String)"service", (String)CollectableService.this.m_spec.getServiceName());
                Logging.putThreadContext((String)"ipAddress", (String)((InetAddress)CollectableService.this.m_agent.getAddress()).getHostAddress());
                Logging.putThreadContext((String)"nodeId", (String)Integer.toString(CollectableService.this.m_agent.getNodeId()));
                Logging.putThreadContext((String)"nodeLabel", (String)CollectableService.this.m_agent.getNodeLabel());
                Logging.putThreadContext((String)"foreignSource", (String)CollectableService.this.m_agent.getForeignSource());
                Logging.putThreadContext((String)"foreignId", (String)CollectableService.this.m_agent.getForeignId());
                Logging.putThreadContext((String)"sysObjectId", (String)CollectableService.this.m_agent.getSysObjectId());
                CollectableService.this.doRun();
            }
        });
    }

    private void doRun() {
        if (this.processUpdates()) {
            LOG.debug("run: Aborting because processUpdates returned ABORT_COLLECTION (probably marked for deletion) for {}", (Object)this);
            return;
        }
        this.m_lastScheduledCollectionTime = this.m_lastScheduledCollectionTime == 0L || !this.m_usingStrictInterval ? System.currentTimeMillis() : (this.m_lastScheduledCollectionTime += this.m_spec.getInterval());
        if (!this.m_spec.scheduledOutage(this.m_agent)) {
            try {
                this.doCollection();
                this.updateStatus(1, null);
            }
            catch (CollectionTimedOut e) {
                LOG.info(e.getMessage());
                this.updateStatus(2, e);
            }
            catch (CollectionWarning e) {
                LOG.warn(e.getMessage(), (Throwable)((Object)e));
                this.updateStatus(2, e);
            }
            catch (CollectionUnknown e) {
                LOG.warn(e.getMessage(), (Throwable)((Object)e));
            }
            catch (CollectionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.updateStatus(2, e);
            }
            catch (Throwable e) {
                LOG.error(e.getMessage(), e);
                this.updateStatus(2, new CollectionException("Collection failed unexpectedly: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e));
            }
        }
        long diff = 0L;
        if (this.m_usingStrictInterval) {
            diff = System.currentTimeMillis() - this.m_lastScheduledCollectionTime;
            diff = Math.min(diff, this.m_spec.getInterval());
        }
        this.m_scheduler.schedule(this.m_spec.getInterval() - diff, this.getReadyRunnable());
    }

    private void updateStatus(int status, CollectionException e) {
        if (status != this.m_status) {
            LOG.debug("run: change in collection status, generating event.");
            String reason = null;
            if (e != null) {
                reason = e.getMessage();
            }
            switch (status) {
                case 1: {
                    this.sendEvent("uei.opennms.org/nodes/dataCollectionSucceeded", null);
                    break;
                }
                case 2: {
                    this.sendEvent("uei.opennms.org/nodes/dataCollectionFailed", reason);
                    break;
                }
            }
        }
        this.m_status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCollection() throws CollectionException {
        block12: {
            LOG.info("run: starting new collection for {}/{}/{}/{}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), this.m_spec.getPackageName()});
            CollectionSet result = null;
            try {
                result = this.m_spec.collect(this.m_agent);
                if (result == null) break block12;
                Collectd.instrumentation().beginPersistingServiceData(this.m_spec.getPackageName(), this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName());
                try {
                    Persister persister = this.m_persisterFactory.createPersister(this.m_params, this.m_repository, result.ignorePersist(), false, false);
                    if (Boolean.getBoolean(USE_COLLECTION_START_TIME_SYS_PROP)) {
                        ConstantTimeKeeper timeKeeper = new ConstantTimeKeeper(new Date(this.m_lastScheduledCollectionTime));
                        persister = CollectableService.wrapResourcesWithTimekeeper((CollectionSetVisitor)persister, (TimeKeeper)timeKeeper);
                    }
                    result.visit((CollectionSetVisitor)persister);
                }
                finally {
                    Collectd.instrumentation().endPersistingServiceData(this.m_spec.getPackageName(), this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName());
                }
                if (this.m_thresholdVisitor != null) {
                    if (this.m_thresholdVisitor.isNodeInOutage()) {
                        LOG.info("run: the threshold processing will be skipped because the node {} is on a scheduled outage.", (Object)this.m_nodeId);
                    } else if (this.m_thresholdVisitor.hasThresholds()) {
                        this.m_thresholdVisitor.setCounterReset(result.ignorePersist());
                        result.visit((CollectionSetVisitor)this.m_thresholdVisitor);
                    }
                }
                if (result.getStatus() != 1) {
                    throw new CollectionFailed(result.getStatus());
                }
            }
            catch (CollectionException e) {
                LOG.warn("run: failed collection for {}/{}/{}/{}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), this.m_spec.getPackageName()});
                throw e;
            }
            catch (Throwable t) {
                LOG.warn("run: failed collection for {}/{}/{}/{}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), this.m_spec.getPackageName()});
                throw new CollectionException("An undeclared throwable was caught during data collection for interface " + this.m_nodeId + "/" + this.getHostAddress() + "/" + this.m_spec.getServiceName(), t);
            }
        }
        LOG.info("run: finished collection for {}/{}/{}/{}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), this.m_spec.getPackageName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUpdates() {
        CollectableService collectableService = this;
        synchronized (collectableService) {
            if (!this.m_updates.hasUpdates()) {
                return false;
            }
            if (this.m_updates.isDeletionFlagSet()) {
                LOG.debug("Collector for  {} is marked for deletion...skipping collection, will not reschedule.", (Object)this.getHostAddress());
                return true;
            }
            OnmsIpInterface newIface = this.m_updates.isReinitializationNeeded();
            if (newIface != null) {
                LOG.debug("ReinitializationFlag set for {}", (Object)this.getHostAddress());
                try {
                    this.reinitialize(newIface);
                    LOG.debug("Completed reinitializing {} collector for {}/{}/{}", new Object[]{this.getServiceName(), this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName()});
                }
                catch (CollectionInitializationException rE) {
                    LOG.warn("Unable to initialize {}/{} for {} collection, reason: {}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), rE.getMessage()});
                }
                catch (Throwable t) {
                    LOG.error("Uncaught exception, failed to intialize interface {}/{} for {} data collection", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), t});
                }
            }
            if (this.m_updates.isReparentingFlagSet()) {
                File oldNodeDir;
                LOG.debug("ReparentingFlag set for {}", (Object)this.getHostAddress());
                String rrdPath = DataCollectionConfigFactory.getInstance().getRrdPath();
                File newNodeDir = new File(rrdPath + File.separator + this.m_updates.getReparentNewNodeId());
                if (!newNodeDir.isDirectory()) {
                    oldNodeDir = new File(rrdPath + File.separator + this.m_updates.getReparentOldNodeId());
                    try {
                        LOG.debug("Attempting to rename {} to {}", (Object)oldNodeDir, (Object)newNodeDir);
                        if (!oldNodeDir.renameTo(newNodeDir)) {
                            LOG.warn("Could not rename file: {}", (Object)oldNodeDir.getPath());
                        }
                        LOG.debug("Rename successful!!");
                    }
                    catch (SecurityException se) {
                        LOG.error("Insufficient authority to rename RRD directory.", (Throwable)se);
                    }
                    catch (Throwable t) {
                        LOG.error("Unexpected exception while attempting to rename RRD directory.", t);
                    }
                } else {
                    oldNodeDir = new File(rrdPath + File.separator + this.m_updates.getReparentOldNodeId());
                    String[] filesToMove = oldNodeDir.list();
                    if (filesToMove != null) {
                        for (int i = 0; i < filesToMove.length; ++i) {
                            File srcFile = new File(oldNodeDir.toString() + File.separator + filesToMove[i]);
                            File destFile = new File(newNodeDir.toString() + File.separator + filesToMove[i]);
                            try {
                                LOG.debug("Attempting to move {} to {}", (Object)srcFile, (Object)destFile);
                                srcFile.renameTo(destFile);
                                continue;
                            }
                            catch (SecurityException se) {
                                LOG.error("Insufficient authority to move RRD files.", (Throwable)se);
                                break;
                            }
                            catch (Throwable t) {
                                LOG.warn("Unexpected exception while attempting to move {} to {}", new Object[]{srcFile, destFile, t});
                            }
                        }
                    }
                }
                int newNodeId = -1;
                try {
                    newNodeId = Integer.parseInt(this.m_updates.getReparentNewNodeId());
                }
                catch (NumberFormatException nfE) {
                    LOG.warn("Unable to convert new nodeId value to an int while processing reparenting update: {}", (Object)this.m_updates.getReparentNewNodeId());
                }
                this.m_nodeId = newNodeId;
                try {
                    LOG.debug("Reinitializing collector for {}/{}/{}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName()});
                    this.reinitialize(this.m_updates.getUpdatedInterface());
                    LOG.debug("Completed reinitializing collector for {}/{}/{}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName()});
                }
                catch (CollectionInitializationException rE) {
                    LOG.warn("Unable to initialize {}/{} for {} collection, reason: {}", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), rE.getMessage()});
                }
                catch (Throwable t) {
                    LOG.error("Uncaught exception, failed to initialize interface {}/{} for {} data collection", new Object[]{this.m_nodeId, this.getHostAddress(), this.m_spec.getServiceName(), t});
                }
            }
            this.m_updates.reset();
        }
        return false;
    }

    private void reinitialize(OnmsIpInterface newIface) throws CollectionInitializationException {
        this.m_spec.release(this.m_agent);
        this.m_agent = DefaultCollectionAgent.create(newIface.getId(), this.m_ifaceDao, this.m_transMgr);
        this.m_spec.initialize(this.m_agent);
    }

    public void reinitializeThresholding() {
        if (this.m_thresholdVisitor != null) {
            LOG.debug("reinitializeThresholding on {}", (Object)this);
            this.m_thresholdVisitor.reload();
        }
    }

    public ReadyRunnable getReadyRunnable() {
        return this;
    }

    public static CollectionSetVisitor wrapResourcesWithTimekeeper(final CollectionSetVisitor visitor, final TimeKeeper timeKeeper) {
        CollectionSetVisitorWrapper wrappedVisitor = new CollectionSetVisitorWrapper(visitor){
            private CollectionResource wrappedResource;
            private CollectionAttribute wrappedAttribute;
            private AttributeGroup wrappedGroup;

            public void visitResource(CollectionResource resource) {
                this.wrappedResource = new CollectionResourceWrapper(resource){

                    public TimeKeeper getTimeKeeper() {
                        return timeKeeper;
                    }
                };
                visitor.visitResource(this.wrappedResource);
            }

            public void completeResource(CollectionResource resource) {
                visitor.completeResource(this.wrappedResource);
            }

            public void visitAttribute(CollectionAttribute attribute) {
                this.wrappedAttribute = new CollectionAttributeWrapper(attribute){

                    public CollectionResource getResource() {
                        return wrappedResource;
                    }
                };
                visitor.visitAttribute(this.wrappedAttribute);
            }

            public void completeAttribute(CollectionAttribute attribute) {
                visitor.completeAttribute(this.wrappedAttribute);
            }

            public void visitGroup(AttributeGroup group) {
                this.wrappedGroup = new AttributeGroupWrapper(group){

                    public CollectionResource getResource() {
                        return wrappedResource;
                    }
                };
                visitor.visitGroup(this.wrappedGroup);
            }

            public void completeGroup(AttributeGroup group) {
                visitor.completeGroup(this.wrappedGroup);
            }
        };
        return wrappedVisitor;
    }
}

