/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.enlinkd.EnhancedLinkdService;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.NodeDiscoveryBridge;
import org.opennms.netmgt.enlinkd.NodeDiscoveryCdp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIpNetToMedia;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIsis;
import org.opennms.netmgt.enlinkd.NodeDiscoveryLldp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryOspf;
import org.opennms.netmgt.enlinkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.enlinkd.scheduler.Scheduler;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class EnhancedLinkd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedLinkd.class);
    private static final String LOG_PREFIX = "enlinkd";
    private Scheduler m_scheduler;
    private EnhancedLinkdService m_queryMgr;
    private EnhancedLinkdConfig m_linkdConfig;
    private List<LinkableSnmpNode> m_nodes;
    private volatile EventForwarder m_eventForwarder;

    public EnhancedLinkd() {
        super(LOG_PREFIX);
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        this.m_nodes = this.m_queryMgr.getSnmpNodeList();
        Assert.notNull(this.m_nodes);
        this.scheduleCollection();
        LOG.info("init: ENHANCED LINKD CONFIGURATION INITIALIZED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollection() {
        List<LinkableSnmpNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableSnmpNode node : this.m_nodes) {
                this.scheduleCollectionForNode(node);
            }
        }
    }

    private void scheduleCollectionForNode(LinkableSnmpNode node) {
        for (NodeDiscovery snmpcoll : this.getSnmpCollections(node)) {
            LOG.info("ScheduleCollectionForNode: Scheduling {}", (Object)snmpcoll.getInfo());
            snmpcoll.setScheduler(this.m_scheduler);
            snmpcoll.schedule();
        }
    }

    public List<NodeDiscovery> getSnmpCollections(LinkableSnmpNode node) {
        ArrayList<NodeDiscovery> snmpcolls = new ArrayList<NodeDiscovery>();
        if (this.m_linkdConfig.useLldpDiscovery()) {
            LOG.info("getSnmpCollections: adding Lldp Discovery: {}", (Object)node);
            NodeDiscoveryLldp lldpcoll = new NodeDiscoveryLldp(this, node);
            snmpcolls.add(lldpcoll);
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            LOG.info("getSnmpCollections: adding Cdp Discovery: {}", (Object)node);
            NodeDiscoveryCdp cdpcoll = new NodeDiscoveryCdp(this, node);
            snmpcolls.add(cdpcoll);
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            LOG.info("getSnmpCollections: adding IpNetToMedia Discovery: {}", (Object)node);
            NodeDiscoveryIpNetToMedia ipnettomediacoll = new NodeDiscoveryIpNetToMedia(this, node);
            snmpcolls.add(ipnettomediacoll);
            LOG.info("getSnmpCollections: adding Bridge Discovery: {}", (Object)node);
            NodeDiscoveryBridge bridgecoll = new NodeDiscoveryBridge(this, node);
            snmpcolls.add(bridgecoll);
        }
        if (this.m_linkdConfig.useOspfDiscovery()) {
            LOG.info("getSnmpCollections: adding Ospf Discovery: {}", (Object)node);
            NodeDiscoveryOspf ospfcoll = new NodeDiscoveryOspf(this, node);
            snmpcolls.add(ospfcoll);
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            LOG.info("getSnmpCollections: adding Is-Is Discovery: {}", (Object)node);
            NodeDiscoveryIsis isiscoll = new NodeDiscoveryIsis(this, node);
            snmpcolls.add(isiscoll);
        }
        return snmpcolls;
    }

    protected synchronized void onStart() {
        LOG.info("start: Starting enhanced linkd scheduler");
        this.m_scheduler.start();
        LOG.info("start: Started enhanced linkd scheduler");
    }

    protected synchronized void onStop() {
        LOG.info("stop: Stopping enhanced linkd scheduler");
        this.m_scheduler.stop();
        this.m_scheduler = null;
        LOG.info("stop: Stopped enhanced linkd scheduler");
    }

    protected synchronized void onPause() {
        LOG.info("pause: Pausing enhanced linkd scheduler");
        this.m_scheduler.pause();
        LOG.info("pause: Paused enhanced linkd scheduler");
    }

    protected synchronized void onResume() {
        LOG.info("resume: Resuming enhanced linkd scheduler");
        this.m_scheduler.resume();
        LOG.info("resume: Resumed enhanced linkd scheduler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LinkableSnmpNode> getLinkableNodes() {
        List<LinkableSnmpNode> list = this.m_nodes;
        synchronized (list) {
            return this.m_nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleNodeCollection(int nodeid) {
        LinkableSnmpNode node = this.getNode(nodeid);
        if (node != null) {
            LOG.info("scheduleNodeCollection: Found Scheduled Linkable node {}. Skipping ", (Object)nodeid);
            return false;
        }
        LOG.info("scheduleNodeCollection: Loading node {} from database", (Object)nodeid);
        node = this.m_queryMgr.getSnmpNode(nodeid);
        if (node == null) {
            LOG.warn("scheduleNodeCollection: Failed to get linkable node from database with ID {}. Exiting", (Object)nodeid);
            return false;
        }
        List<LinkableSnmpNode> list = this.m_nodes;
        synchronized (list) {
            LOG.info("scheduleNodeCollection: adding node {} to the collection", (Object)node);
            this.m_nodes.add(node);
        }
        this.scheduleCollectionForNode(node);
        return true;
    }

    public boolean runSingleSnmpCollection(int nodeId) {
        LinkableSnmpNode node = this.m_queryMgr.getSnmpNode(nodeId);
        for (NodeDiscovery snmpColl : this.getSnmpCollections(node)) {
            snmpColl.setScheduler(this.m_scheduler);
            snmpColl.run();
        }
        return true;
    }

    void wakeUpNodeCollection(int nodeid) {
        LinkableSnmpNode node = this.getNode(nodeid);
        if (node == null) {
            LOG.warn("wakeUpNodeCollection: node not found during scheduling with ID {}", (Object)nodeid);
            this.scheduleNodeCollection(nodeid);
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("wakeUpNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to wake them up", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("wakeUpNodeCollection: found null ReadyRunnable for nodeid {}", (Object)nodeid);
                    continue;
                }
                rr.wakeUp();
            }
        }
    }

    void deleteNode(int nodeid) {
        LOG.info("deleteNode: deleting LinkableNode for node {}", (Object)nodeid);
        this.m_queryMgr.delete(nodeid);
        LinkableSnmpNode node = this.removeNode(nodeid);
        if (node == null) {
            LOG.warn("deleteNode: node not found: {}", (Object)nodeid);
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("deleteNode: fetched SnmpCollections from scratch, iterating over {} objects to wake them up", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("deleteNode: found null ReadyRunnable");
                    continue;
                }
                rr.unschedule();
            }
        }
    }

    void rescheduleNodeCollection(int nodeid) {
        LOG.info("rescheduleNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        LinkableSnmpNode node = this.getNode(nodeid);
        if (node == null) {
            LOG.warn("rescheduleNodeCollection: node not found: {}", (Object)nodeid);
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("rescheduleNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to rescheduling", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("rescheduleNodeCollection: found null ReadyRunnable");
                    continue;
                }
                rr.unschedule();
                rr.schedule();
            }
        }
    }

    void suspendNodeCollection(int nodeid) {
        LOG.info("suspendNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        LinkableSnmpNode node = this.getNode(nodeid);
        if (node == null) {
            LOG.warn("suspendNodeCollection: found null ReadyRunnable");
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("suspendNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to suspend them down", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("suspendNodeCollection: suspend: node not found: {}", (Object)nodeid);
                    continue;
                }
                rr.suspend();
            }
        }
    }

    private ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        LOG.info("getReadyRunnable: getting {} from scheduler", (Object)runnable.getInfo());
        return this.m_scheduler.getReadyRunnable(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkableSnmpNode getNode(int nodeid) {
        List<LinkableSnmpNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableSnmpNode node : this.m_nodes) {
                if (node.getNodeId() != nodeid) continue;
                return node;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkableSnmpNode removeNode(int nodeid) {
        List<LinkableSnmpNode> list = this.m_nodes;
        synchronized (list) {
            Iterator<LinkableSnmpNode> ite = this.m_nodes.iterator();
            while (ite.hasNext()) {
                LinkableSnmpNode curNode = ite.next();
                if (curNode.getNodeId() != nodeid) continue;
                ite.remove();
                return curNode;
            }
            return null;
        }
    }

    public EnhancedLinkdService getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(EnhancedLinkdService queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public EnhancedLinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(EnhancedLinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public String getSource() {
        return LOG_PREFIX;
    }

    public SnmpAgentConfig getSnmpAgentConfig(InetAddress ipaddr) {
        return SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
    }

    public long getInitialSleepTime() {
        return this.m_linkdConfig.getInitialSleepTime();
    }

    public long getRescanInterval() {
        return this.m_linkdConfig.getRescanInterval();
    }
}

