/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdingEventProxyFactory;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingSet {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingSet.class);
    protected final int m_nodeId;
    protected final String m_hostAddress;
    protected final String m_serviceName;
    protected final RrdRepository m_repository;
    protected ThresholdsDao m_thresholdsDao;
    private boolean m_initialized = false;
    private boolean m_hasThresholds = false;
    protected final List<ThresholdGroup> m_thresholdGroups = new LinkedList<ThresholdGroup>();
    protected final List<String> m_scheduledOutages = new ArrayList<String>();

    public ThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository) {
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress == null ? null : hostAddress.intern();
        this.m_serviceName = serviceName == null ? null : serviceName.intern();
        this.m_repository = repository;
        this.initThresholdsDao();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        String logHeader = "initialize(nodeId=" + this.m_nodeId + ",ipAddr=" + this.m_hostAddress + ",svc=" + this.m_serviceName + ")";
        List<String> groupNameList = ThresholdingSet.getThresholdGroupNames(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            this.m_thresholdGroups.clear();
            for (String groupName : groupNameList) {
                try {
                    ThresholdGroup thresholdGroup = this.m_thresholdsDao.get(groupName);
                    if (thresholdGroup == null) {
                        LOG.error("{}: Could not get threshold group with name {}", (Object)logHeader, (Object)groupName);
                        continue;
                    }
                    this.m_thresholdGroups.add(thresholdGroup);
                    LOG.debug("{}: Adding threshold group: {}", (Object)logHeader, (Object)thresholdGroup);
                }
                catch (Throwable e) {
                    LOG.error("{}: Can't process threshold group {}", new Object[]{logHeader, groupName, e});
                }
            }
            this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        }
        this.updateScheduledOutages();
    }

    public void reinitialize() {
        this.m_initialized = false;
        ThresholdingEventProxyFactory.getFactory().getProxy().removeAllEvents();
        this.initThresholdsDao();
        this.mergeThresholdGroups(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        this.updateScheduledOutages();
        ThresholdingEventProxyFactory.getFactory().getProxy().sendAllEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeThresholdGroups(int nodeId, String hostAddress, String serviceName) {
        String logHeader = "mergeThresholdGroups(nodeId=" + nodeId + ",ipAddr=" + hostAddress + ",svc=" + serviceName + ")";
        LOG.debug("{}: Begin merging operation", (Object)logHeader);
        List<String> groupNameList = ThresholdingSet.getThresholdGroupNames(nodeId, hostAddress, serviceName);
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            if (groupNameList.size() != this.m_thresholdGroups.size()) {
                LOG.debug("{}: New group name list differs from current threshold group list", (Object)logHeader);
                Iterator<ThresholdGroup> i = this.m_thresholdGroups.iterator();
                while (i.hasNext()) {
                    ThresholdGroup group = i.next();
                    if (groupNameList.contains(group.getName())) continue;
                    LOG.info("{}: deleting group {}", (Object)logHeader, (Object)group);
                    group.delete();
                    i.remove();
                }
            }
            LinkedList<ThresholdGroup> newThresholdGroupList = new LinkedList<ThresholdGroup>();
            for (String groupName : groupNameList) {
                ThresholdGroup thresholdGroup;
                ThresholdGroup foundGroup = null;
                for (ThresholdGroup group : this.m_thresholdGroups) {
                    if (!group.getName().equals(groupName)) continue;
                    foundGroup = group;
                }
                if (foundGroup == null) {
                    thresholdGroup = this.m_thresholdsDao.get(groupName);
                    if (thresholdGroup == null) {
                        LOG.error("{}: Could not get threshold group with name {}", (Object)logHeader, (Object)groupName);
                        continue;
                    }
                    newThresholdGroupList.add(thresholdGroup);
                    LOG.debug("{}: Adding threshold group: {}", (Object)logHeader, (Object)thresholdGroup);
                    continue;
                }
                thresholdGroup = this.m_thresholdsDao.merge(foundGroup);
                newThresholdGroupList.add(thresholdGroup);
                LOG.debug("{}: Merging threshold group: {}", (Object)logHeader, (Object)thresholdGroup);
            }
            this.m_thresholdGroups.clear();
            this.m_thresholdGroups.addAll(newThresholdGroupList);
            this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        }
    }

    public boolean hasThresholds() {
        return this.m_hasThresholds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasThresholds(String resourceTypeName, String attributeName) {
        boolean ok = false;
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            for (ThresholdGroup group : this.m_thresholdGroups) {
                Map<String, Set<ThresholdEntity>> entityMap = ThresholdingSet.getEntityMap(group, resourceTypeName);
                if (entityMap == null) continue;
                for (Map.Entry<String, Set<ThresholdEntity>> entry : entityMap.entrySet()) {
                    Set<ThresholdEntity> value = entry.getValue();
                    for (ThresholdEntity thresholdEntity : value) {
                        Collection<String> requiredDatasources = thresholdEntity.getRequiredDatasources();
                        if (requiredDatasources.contains(attributeName)) {
                            ok = true;
                            LOG.debug("hasThresholds: {}@{}? {}", new Object[]{resourceTypeName, attributeName, ok});
                            continue;
                        }
                        LOG.trace("hasThresholds: {}@{}? {}", new Object[]{resourceTypeName, attributeName, ok});
                    }
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isNodeInOutage() {
        PollOutagesConfigFactory outageFactory = PollOutagesConfigFactory.getInstance();
        boolean outageFound = false;
        List<String> list = this.m_scheduledOutages;
        synchronized (list) {
            for (String outageName : this.m_scheduledOutages) {
                if (!outageFactory.isCurTimeInOutage(outageName)) continue;
                LOG.debug("isNodeInOutage[node={}]: current time is on outage using '{}'; checking the node with IP {}", new Object[]{this.m_nodeId, outageName, this.m_hostAddress});
                if (!outageFactory.isNodeIdInOutage((long)this.m_nodeId, outageName) && !outageFactory.isInterfaceInOutage(this.m_hostAddress, outageName)) continue;
                LOG.debug("isNodeInOutage[node={}]: configured outage '{}' applies, interface {} will be ignored for threshold processing", new Object[]{this.m_nodeId, outageName, this.m_hostAddress});
                outageFound = true;
                break;
            }
        }
        return outageFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<Event> applyThresholds(CollectionResourceWrapper resourceWrapper, Map<String, CollectionAttribute> attributesMap) {
        LinkedList<Event> eventsList = new LinkedList<Event>();
        if (attributesMap == null || attributesMap.size() == 0) {
            LOG.debug("applyThresholds: Ignoring resource {} because required attributes map is empty.", (Object)resourceWrapper);
            return eventsList;
        }
        LOG.debug("applyThresholds: Applying thresholds on {} using {} attributes.", (Object)resourceWrapper, (Object)attributesMap.size());
        Date date = new Date();
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            for (ThresholdGroup group : this.m_thresholdGroups) {
                Map<String, Set<ThresholdEntity>> entityMap = ThresholdingSet.getEntityMap(group, resourceWrapper.getResourceTypeName());
                if (entityMap == null) continue;
                for (Map.Entry<String, Set<ThresholdEntity>> entry : entityMap.entrySet()) {
                    String key = entry.getKey();
                    Set<ThresholdEntity> value = entry.getValue();
                    for (ThresholdEntity thresholdEntity : value) {
                        if (this.passedThresholdFilters(resourceWrapper, thresholdEntity)) {
                            LOG.info("applyThresholds: Processing threshold {} : {} on resource {}", new Object[]{key, thresholdEntity, resourceWrapper});
                            Collection<String> requiredDatasources = thresholdEntity.getThresholdConfig().getRequiredDatasources();
                            HashMap<String, Double> values = new HashMap<String, Double>();
                            boolean valueMissing = false;
                            boolean relaxed = thresholdEntity.getThresholdConfig().getBasethresholddef().isRelaxed();
                            for (String ds : requiredDatasources) {
                                Double dsValue = resourceWrapper.getAttributeValue(ds);
                                if (dsValue == null) {
                                    LOG.info("applyThresholds: Could not get data source value for '{}', {}", (Object)ds, (Object)(relaxed ? "but the expression will be evaluated (relaxed mode enabled)" : "not evaluating threshold"));
                                    valueMissing = true;
                                }
                                values.put(ds, dsValue);
                            }
                            if (valueMissing && !relaxed) continue;
                            LOG.info("applyThresholds: All attributes found for {}, evaluating", (Object)resourceWrapper);
                            resourceWrapper.setDsLabel(thresholdEntity.getDatasourceLabel());
                            try {
                                List<Event> thresholdEvents = thresholdEntity.evaluateAndCreateEvents(resourceWrapper, values, date);
                                eventsList.addAll(thresholdEvents);
                            }
                            catch (Exception e) {
                                LOG.warn("applyThresholds: Can't evaluate {} on {} because {}", new Object[]{key, resourceWrapper, e.getMessage()});
                            }
                            continue;
                        }
                        LOG.info("applyThresholds: Not processing threshold {} : {} because no filters matched", (Object)key, (Object)thresholdEntity);
                    }
                }
            }
        }
        return eventsList;
    }

    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        ResourceFilter[] filters = thresholdEntity.getThresholdConfig().getBasethresholddef().getResourceFilter();
        if (filters.length == 0) {
            return true;
        }
        LOG.debug("passedThresholdFilters: applying {} filters to resource {}", (Object)filters.length, (Object)resource);
        int count = 1;
        String operator = thresholdEntity.getThresholdConfig().getBasethresholddef().getFilterOperator().toLowerCase();
        boolean andResult = true;
        for (ResourceFilter f : filters) {
            LOG.debug("passedThresholdFilters: filter #{}: field={}, regex='{}'", new Object[]{count, f.getField(), f.getContent()});
            ++count;
            String attr = resource.getFieldValue(f.getField());
            if (attr != null) {
                try {
                    Pattern p = Pattern.compile(f.getContent());
                    Matcher m = p.matcher(attr);
                    boolean pass = m.matches();
                    LOG.debug("passedThresholdFilters: the value of {} is {}. Pass filter? {}", new Object[]{f.getField(), attr, pass});
                    if (operator.equals("or") && pass) {
                        return true;
                    }
                    if (!operator.equals("and")) continue;
                    boolean bl = andResult = andResult && pass;
                    if (andResult) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("passedThresholdFilters: the regular expression {} is invalid: {}", new Object[]{f.getContent(), e.getMessage(), e});
                    return false;
                }
            }
            LOG.warn("passedThresholdFilters: can't find value of {} for resource {}", (Object)f.getField(), (Object)resource);
            if (!operator.equals("and")) continue;
            return false;
        }
        return operator.equals("and") && andResult;
    }

    protected final void initThresholdsDao() {
        if (!this.m_initialized) {
            LOG.debug("initThresholdsDao: Initializing Factories and DAOs");
            this.m_initialized = true;
            DefaultThresholdsDao defaultThresholdsDao = new DefaultThresholdsDao();
            try {
                ThresholdingConfigFactory.init();
                defaultThresholdsDao.setThresholdingConfigFactory(ThresholdingConfigFactory.getInstance());
                defaultThresholdsDao.afterPropertiesSet();
            }
            catch (Throwable t) {
                LOG.error("initThresholdsDao: Could not initialize DefaultThresholdsDao", t);
                throw new RuntimeException("Could not initialize DefaultThresholdsDao: " + t, t);
            }
            try {
                ThreshdConfigFactory.init();
            }
            catch (Throwable t) {
                LOG.error("initThresholdsDao: Could not initialize ThreshdConfigFactory", t);
                throw new RuntimeException("Could not initialize ThreshdConfigFactory: " + t, t);
            }
            this.m_thresholdsDao = defaultThresholdsDao;
        }
    }

    private static final List<String> getThresholdGroupNames(int nodeId, String hostAddress, String serviceName) {
        ThreshdConfigFactory configManager = ThreshdConfigFactory.getInstance();
        LinkedList<String> groupNameList = new LinkedList<String>();
        for (Package pkg : configManager.getConfiguration().getPackage()) {
            if (!configManager.serviceInPackageAndEnabled(serviceName, pkg)) {
                LOG.debug("getThresholdGroupNames: address/service: {}/{} not scheduled, service is not enabled or does not exist in package: {}", new Object[]{hostAddress, serviceName, pkg.getName()});
                continue;
            }
            LOG.debug("getThresholdGroupNames: checking ipaddress {} for inclusion in pkg {}", (Object)hostAddress, (Object)pkg.getName());
            if (!configManager.interfaceInPackage(hostAddress, pkg)) {
                LOG.debug("getThresholdGroupNames: address/service: {}/{} not scheduled, interface does not belong to package: {}", new Object[]{hostAddress, serviceName, pkg.getName()});
                continue;
            }
            for (Service svc : pkg.getService()) {
                if (!svc.getName().equals(serviceName)) continue;
                for (Parameter parameter : svc.getParameter()) {
                    if (!parameter.getKey().equals("thresholding-group")) continue;
                    String groupName = parameter.getValue();
                    groupNameList.add(groupName);
                    LOG.debug("getThresholdGroupNames:  address/service: {}/{}. Adding Group {}", new Object[]{hostAddress, serviceName, groupName});
                }
            }
        }
        return groupNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateScheduledOutages() {
        List<String> list = this.m_scheduledOutages;
        synchronized (list) {
            this.m_scheduledOutages.clear();
            ThreshdConfigFactory configManager = ThreshdConfigFactory.getInstance();
            for (Package pkg : configManager.getConfiguration().getPackage()) {
                for (String outageCal : pkg.getOutageCalendarCollection()) {
                    LOG.info("updateScheduledOutages[node={}]: checking scheduled outage '{}'", (Object)this.m_nodeId, (Object)outageCal);
                    try {
                        Outage outage = PollOutagesConfigFactory.getInstance().getOutage(outageCal);
                        if (outage == null) {
                            LOG.info("updateScheduledOutages[node={}]: scheduled outage '{}' is not defined.", (Object)this.m_nodeId, (Object)outageCal);
                            continue;
                        }
                        LOG.debug("updateScheduledOutages[node={}]: outage calendar '{}' found on package '{}'", new Object[]{this.m_nodeId, outage.getName(), pkg.getName()});
                        this.m_scheduledOutages.add(outageCal);
                    }
                    catch (Exception e) {
                        LOG.info("updateScheduledOutages[node={}]: scheduled outage '{}' does not exist.", (Object)this.m_nodeId, (Object)outageCal);
                    }
                }
            }
        }
    }

    private static Map<String, Set<ThresholdEntity>> getEntityMap(ThresholdGroup thresholdGroup, String resourceType) {
        LOG.trace("getEntityMap: checking if the resourceType '{}' exists on threshold group {}", (Object)resourceType, (Object)thresholdGroup);
        Map<String, Set<ThresholdEntity>> entityMap = null;
        if ("node".equals(resourceType)) {
            entityMap = thresholdGroup.getNodeResourceType().getThresholdMap();
        } else if ("if".equals(resourceType)) {
            entityMap = thresholdGroup.getIfResourceType().getThresholdMap();
        } else {
            Map<String, ThresholdResourceType> typeMap = thresholdGroup.getGenericResourceTypeMap();
            if (typeMap == null) {
                LOG.error("getEntityMap: Generic Resource Type map was null (this shouldn't happen) for threshold group {}", (Object)thresholdGroup.getName());
                return null;
            }
            ThresholdResourceType thisResourceType = typeMap.get(resourceType);
            if (thisResourceType == null) {
                LOG.debug("getEntityMap: No thresholds configured for resource type '{}' in threshold group {}. Skipping this group.", (Object)resourceType, (Object)thresholdGroup.getName());
                return null;
            }
            entityMap = thisResourceType.getThresholdMap();
        }
        return Collections.unmodifiableMap(entityMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            return this.m_thresholdGroups.toString();
        }
    }
}

