/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.protocols.jmx.connectors.Jsr160ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr160ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Jsr160ConnectionFactory.class);

    public static Jsr160ConnectionWrapper getMBeanServerConnection(Map<String, ?> propertiesMap, InetAddress address) {
        Jsr160ConnectionWrapper connectionWrapper = null;
        JMXServiceURL url = null;
        String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger(propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        LOG.debug("JMX: {} - service:{}//{}:{}{}", new Object[]{factory, protocol, InetAddressUtils.toUrlIpAddress((InetAddress)address), port, urlPath});
        if (factory == null || factory.equals("STANDARD")) {
            try {
                url = Jsr160ConnectionFactory.getUrl(address, port, protocol, urlPath);
                JMXConnector connector = JMXConnectorFactory.connect(url);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (MalformedURLException e) {
                LOG.warn("URL was malformed: {}", (Object)url, (Object)e);
            }
            catch (IOException e) {
                LOG.warn("An I/O exception occurred: {}", (Object)url, (Object)e);
            }
            catch (Throwable e) {
                LOG.warn("Unable to get MBeanServerConnection: {}", (Object)url, (Object)e);
            }
        } else if (factory.equals("PASSWORD-CLEAR")) {
            try {
                String username = ParameterMap.getKeyedString(propertiesMap, (String)"username", null);
                String password = ParameterMap.getKeyedString(propertiesMap, (String)"password", null);
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                env.put("jmx.remote.credentials", credentials);
                url = Jsr160ConnectionFactory.getUrl(address, port, protocol, urlPath);
                JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
                try {
                    connector.connect(env);
                }
                catch (SecurityException x) {
                    LOG.error("Security exception: bad credentials");
                    throw x;
                }
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (Throwable e) {
                LOG.error("Unable to get MBeanServerConnection: {}", (Object)url, (Object)e);
            }
        }
        return connectionWrapper;
    }

    private static JMXServiceURL getUrl(InetAddress address, int port, String protocol, String urlPath) throws MalformedURLException {
        JMXServiceURL url = protocol.equalsIgnoreCase("jmxmp") || protocol.equalsIgnoreCase("remoting-jmx") ? new JMXServiceURL(protocol, InetAddressUtils.toUrlIpAddress((InetAddress)address), port, urlPath) : new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.toUrlIpAddress((InetAddress)address) + ":" + port + urlPath);
        return url;
    }
}

