/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.protocols.jmx.connectors.Jsr160ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXSecureConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JMXSecureConnectionFactory.class);

    public static Jsr160ConnectionWrapper getMBeanServerConnection(Map<?, ?> propertiesMap, InetAddress address) {
        Jsr160ConnectionWrapper connectionWrapper = null;
        JMXServiceURL url = null;
        String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"SASL");
        int port = ParameterMap.getKeyedInteger(propertiesMap, (String)"port", (int)11162);
        String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"jmxmp");
        String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"");
        String sunCacao = ParameterMap.getKeyedString(propertiesMap, (String)"sunCacao", (String)"false");
        try {
            url = protocol.equalsIgnoreCase("jmxmp") || protocol.equalsIgnoreCase("remoting-jmx") ? new JMXServiceURL(protocol, InetAddressUtils.toUrlIpAddress((InetAddress)address), port, urlPath) : new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.toUrlIpAddress((InetAddress)address) + ":" + port + urlPath);
        }
        catch (MalformedURLException e) {
            LOG.error("JMXServiceURL exception: {}. Error message: {}", url, (Object)e.getMessage());
        }
        LOG.debug("Set JMXServiceURL: {}", url);
        if (factory.equals("SASL")) {
            try {
                String username = ParameterMap.getKeyedString(propertiesMap, (String)"username", null);
                String password = ParameterMap.getKeyedString(propertiesMap, (String)"password", null);
                HashMap<String, Object> env = new HashMap<String, Object>();
                try {
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    AnyServerX509TrustManager tm = new AnyServerX509TrustManager();
                    SSLContext ctx = SSLContext.getInstance("TLSv1");
                    ctx.init(null, new TrustManager[]{tm}, null);
                    SSLSocketFactory ssf = ctx.getSocketFactory();
                    env.put("jmx.remote.tls.socket.factory", ssf);
                }
                catch (Throwable e) {
                    LOG.error("Something bad occured: {}", (Object)e.getMessage());
                    throw e;
                }
                String[] creds = sunCacao.equals("true") ? new String[]{"com.sun.cacao.user\u0001" + username, password} : new String[]{username, password};
                env.put("jmx.remote.profiles", "TLS SASL/PLAIN");
                env.put("jmx.remote.credentials", creds);
                JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
                try {
                    connector.connect(env);
                }
                catch (SSLException e) {
                    LOG.warn("SSLException occured. Error message: {}", (Object)e.getMessage());
                }
                catch (SecurityException x) {
                    LOG.error("Security exception: bad credentials. Error message: {}", (Object)x.getMessage());
                }
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (Throwable e) {
                LOG.error("Unable to get MBeanServerConnection: {}. Error message: {}", (Object)url, (Object)e.getMessage());
            }
        }
        return connectionWrapper;
    }

    private static class AnyServerX509TrustManager
    implements X509TrustManager {
        private AnyServerX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            throw new CertificateException("not supported");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

