/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.utils.NodeLabel;
import org.opennms.netmgt.utils.NodeLabelJDBCImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeLabelDaoImpl
implements NodeLabel {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    private static final Logger LOG = LoggerFactory.getLogger(NodeLabelDaoImpl.class);
    public static final int MAX_NODE_LABEL_LENGTH = 256;
    private static final String SELECT_METHOD_MIN = "min";
    private static final String SELECT_METHOD_MAX = "max";
    private static final String DEFAULT_SELECT_METHOD = "min";
    private final String m_nodeLabel;
    private final OnmsNode.NodeLabelSource m_nodeLabelSource;
    public static final String PROP_PRIMARY_INTERFACE_SELECT_METHOD = "org.opennms.bluebird.dp.primaryInterfaceSelectMethod";

    public static NodeLabel getInstance() {
        return new NodeLabelDaoImpl();
    }

    public NodeLabelDaoImpl() {
        this.m_nodeLabel = null;
        this.m_nodeLabelSource = OnmsNode.NodeLabelSource.UNKNOWN;
    }

    public NodeLabelDaoImpl(String nodeLabel, OnmsNode.NodeLabelSource nodeLabelSource) {
        switch (nodeLabelSource) {
            case ADDRESS: 
            case HOSTNAME: 
            case NETBIOS: 
            case SYSNAME: 
            case UNKNOWN: 
            case USER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for node label source: " + nodeLabelSource);
            }
        }
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLabelSource = nodeLabelSource;
    }

    @Override
    public String getLabel() {
        return this.m_nodeLabel;
    }

    @Override
    public OnmsNode.NodeLabelSource getSource() {
        return this.m_nodeLabelSource;
    }

    @Override
    public NodeLabelJDBCImpl retrieveLabel(int nodeID) throws SQLException {
        return this.retrieveLabel(nodeID, null);
    }

    @Override
    public NodeLabelJDBCImpl retrieveLabel(int nodeID, Connection dbConnection) throws SQLException {
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        String nodeLabel = node.getLabel();
        OnmsNode.NodeLabelSource nodeLabelSource = node.getLabelSource();
        return new NodeLabelJDBCImpl(nodeLabel, nodeLabelSource);
    }

    @Override
    public void assignLabel(int nodeID, NodeLabelJDBCImpl nodeLabel) throws SQLException {
        this.assignLabel(nodeID, nodeLabel, null);
    }

    @Override
    public void assignLabel(int nodeID, NodeLabelJDBCImpl nodeLabel, Connection dbConnection) throws SQLException {
        if (nodeLabel == null) {
            nodeLabel = this.computeLabel(nodeID, dbConnection);
        }
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        LOG.debug("NodeLabel.assignLabel: Node label: {} source: {}", (Object)nodeLabel.getLabel(), (Object)nodeLabel.getSource());
        if (nodeLabel.getLabel() != null) {
            String label = nodeLabel.getLabel();
            if (label.length() > 256) {
                label = label.substring(0, 256);
            }
            node.setLabel(label);
        } else {
            node.setLabel(null);
        }
        node.setLabelSource(nodeLabel.getSource());
        this.nodeDao.update((Object)node);
    }

    @Override
    public NodeLabelJDBCImpl computeLabel(int nodeID) throws SQLException {
        return this.computeLabel(nodeID, null);
    }

    @Override
    public NodeLabelJDBCImpl computeLabel(int nodeID, Connection dbConnection) throws SQLException {
        String netbiosName = null;
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        netbiosName = node.getNetBiosName();
        if (netbiosName != null) {
            if (netbiosName.length() > 256) {
                netbiosName = netbiosName.substring(0, 256);
            }
            return new NodeLabelJDBCImpl(netbiosName, OnmsNode.NodeLabelSource.NETBIOS);
        }
        LOG.debug("NodeLabel.computeLabel: returning NetBIOS name as nodeLabel: {}", (Object)netbiosName);
        String method = System.getProperty(PROP_PRIMARY_INTERFACE_SELECT_METHOD);
        if (method == null) {
            method = "min";
        }
        if (!method.equals("min") && !method.equals(SELECT_METHOD_MAX)) {
            LOG.warn("Interface selection method is '{}'.  Valid values are 'min' & 'max'.  Will use default value: {}", (Object)method, (Object)"min");
            method = "min";
        }
        ArrayList<InetAddress> ipv4AddrList = new ArrayList<InetAddress>();
        ArrayList<String> ipHostNameList = new ArrayList<String>();
        Criteria criteria = new Criteria(OnmsIpInterface.class).setAliases(Arrays.asList(new Alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("ipInterfaces.nodeId", (Object)nodeID)).addRestriction((Restriction)new EqRestriction("ipInterfaces.isManaged", (Object)"M"));
        List ints = this.ipInterfaceDao.findMatching(criteria);
        for (OnmsIpInterface one : ints) {
            InetAddress inetAddr = one.getIpAddress();
            ipv4AddrList.add(inetAddr);
            String hostName = one.getIpHostName();
            if (hostName == null || hostName.equals(inetAddr.toString())) {
                ipHostNameList.add("");
                continue;
            }
            ipHostNameList.add(hostName);
        }
        InetAddress primaryAddr = NodeLabelDaoImpl.selectPrimaryAddress(ipv4AddrList, method);
        if (primaryAddr == null) {
            LOG.debug("NodeLabel.computeLabel: unable to find a primary address for node {}, returning null", (Object)nodeID);
            ipv4AddrList.clear();
            ipHostNameList.clear();
            Criteria crit = new Criteria(OnmsIpInterface.class).setAliases(Arrays.asList(new Alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("ipInterfaces.nodeId", (Object)nodeID)).addRestriction((Restriction)new NeRestriction("ipInterfaces.isManaged", (Object)"M"));
            List sec = this.ipInterfaceDao.findMatching(crit);
            for (OnmsIpInterface two : sec) {
                InetAddress inetAddr = two.getIpAddress();
                ipv4AddrList.add(inetAddr);
                String hostName = two.getIpHostName();
                if (hostName == null || hostName.equals(inetAddr.toString())) {
                    ipHostNameList.add("");
                    continue;
                }
                ipHostNameList.add(hostName);
            }
            primaryAddr = NodeLabelDaoImpl.selectPrimaryAddress(ipv4AddrList, method);
        }
        if (primaryAddr == null) {
            LOG.warn("Could not find primary interface for node {}, cannot compute nodelabel", (Object)nodeID);
            return new NodeLabelJDBCImpl("Unknown", OnmsNode.NodeLabelSource.UNKNOWN);
        }
        int index = ipv4AddrList.indexOf(primaryAddr);
        String primaryHostName = (String)ipHostNameList.get(index);
        if (primaryHostName.length() != 0) {
            if (primaryHostName.length() > 256) {
                primaryHostName = primaryHostName.substring(0, 256);
            }
            return new NodeLabelJDBCImpl(primaryHostName, OnmsNode.NodeLabelSource.HOSTNAME);
        }
        String primarySysName = null;
        OnmsNode sysNode = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        primarySysName = sysNode.getSysName();
        if (primarySysName != null && primarySysName.length() > 0) {
            if (primarySysName.length() > 256) {
                primarySysName = primarySysName.substring(0, 256);
            }
            return new NodeLabelJDBCImpl(primarySysName, OnmsNode.NodeLabelSource.SYSNAME);
        }
        return new NodeLabelJDBCImpl(InetAddressUtils.str((InetAddress)primaryAddr), OnmsNode.NodeLabelSource.ADDRESS);
    }

    private static InetAddress selectPrimaryAddress(List<InetAddress> ipv4AddrList, String method) {
        InetAddress primaryAddr = null;
        Iterator<InetAddress> iter = ipv4AddrList.iterator();
        while (iter.hasNext()) {
            if (primaryAddr == null) {
                primaryAddr = iter.next();
                continue;
            }
            InetAddress currentAddr = iter.next();
            byte[] current = currentAddr.getAddress();
            byte[] primary = primaryAddr.getAddress();
            if (method.equals("min")) {
                if (new ByteArrayComparator().compare(current, primary) >= 0) continue;
                primaryAddr = currentAddr;
                continue;
            }
            if (new ByteArrayComparator().compare(current, primary) <= 0) continue;
            primaryAddr = currentAddr;
        }
        return primaryAddr;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_nodeLabel);
        buffer.append(":");
        buffer.append(this.m_nodeLabelSource);
        return buffer.toString();
    }
}

