/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramSocket;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.syslogd.SyslogReceiverJavaNetImpl;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyslogHandler
implements Fiber {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogHandler.class);
    private final boolean USE_NIO = false;
    private SyslogReceiver m_receiver = null;
    private volatile int m_status = 0;
    private DatagramSocket m_dgSock = null;
    private final String m_ForwardingRegexp;
    private final int m_MatchingGroupHost;
    private final int m_MatchingGroupMessage;
    private final UeiList m_UeiList;
    private final HideMessage m_HideMessages;
    private int m_dgPort = m_syslogdConfig.getSyslogPort();
    private String m_dgIp = m_syslogdConfig.getListenAddress();
    private String m_logPrefix = null;
    private final String m_DiscardUei;
    private static SyslogdConfig m_syslogdConfig;

    public SyslogHandler() {
        this.m_ForwardingRegexp = m_syslogdConfig.getForwardingRegexp();
        this.m_MatchingGroupHost = m_syslogdConfig.getMatchingGroupHost();
        this.m_MatchingGroupMessage = m_syslogdConfig.getMatchingGroupMessage();
        this.m_DiscardUei = m_syslogdConfig.getDiscardUei();
        this.m_UeiList = m_syslogdConfig.getUeiList();
        this.m_HideMessages = m_syslogdConfig.getHideMessages();
    }

    public static void setSyslogConfig(SyslogdConfig syslogdConfig) {
        m_syslogdConfig = syslogdConfig;
    }

    public synchronized void start() {
        if (this.m_status != 0) {
            throw new RuntimeException("The Fiber is in an incorrect state");
        }
        this.m_status = 1;
        try {
            this.m_dgSock = this.m_dgIp != null && this.m_dgIp.length() != 0 ? new DatagramSocket(this.m_dgPort, InetAddressUtils.addr((String)this.m_dgIp)) : new DatagramSocket(this.m_dgPort);
            this.m_receiver = new SyslogReceiverJavaNetImpl(this.m_dgSock, this.m_ForwardingRegexp, this.m_MatchingGroupHost, this.m_MatchingGroupMessage, this.m_UeiList, this.m_HideMessages, this.m_DiscardUei);
            if (this.m_logPrefix != null) {
                this.m_receiver.setLogPrefix(this.m_logPrefix);
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        Thread rThread = new Thread((Runnable)this.m_receiver, "Syslog Event Receiver[" + this.getIpAddress() + ":" + this.m_dgPort + "]");
        try {
            rThread.start();
        }
        catch (RuntimeException e) {
            rThread.interrupt();
            this.m_status = 4;
            throw e;
        }
        this.m_status = 2;
    }

    public synchronized void stop() {
        if (this.m_status == 4) {
            return;
        }
        if (this.m_status == 0) {
            this.m_status = 4;
            return;
        }
        this.m_status = 3;
        try {
            this.m_receiver.stop();
        }
        catch (InterruptedException e) {
            LOG.warn("The thread was interrupted while attempting to join sub-threads", (Throwable)e);
        }
        if (this.m_dgSock != null) {
            this.m_dgSock.close();
        }
        this.m_status = 4;
    }

    public String getName() {
        return "SyslogdHandler[" + this.getIpAddress() + ":" + this.m_dgPort + "]";
    }

    public int getStatus() {
        return this.m_status;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void setPort(Integer port) {
        if (this.m_status == 1 || this.m_status == 2 || this.m_status == 3) {
            throw new IllegalStateException("The process is already running");
        }
        this.m_dgPort = port;
    }

    public Integer getPort() {
        return this.m_dgPort;
    }

    public void setIpAddress(String ipAddress) {
        this.m_dgIp = ipAddress;
    }

    public String getIpAddress() {
        if (this.m_dgIp == null || this.m_dgIp.length() == 0) {
            return "0.0.0.0";
        }
        return this.m_dgIp;
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    public static interface EventHandler {
        public boolean processEvent(Event var1);

        public void receiptSent(EventReceipt var1);
    }
}

