/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.rtc.RTCException;
import org.opennms.netmgt.rtc.RTCManager;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.rtc.datablock.RTCHashMap;
import org.opennms.netmgt.rtc.datablock.RTCNode;
import org.opennms.netmgt.rtc.datablock.RTCNodeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.xml.sax.SAXException;

public class DataManager {
    private static final Logger LOG = LoggerFactory.getLogger(DataManager.class);
    private Map<String, RTCCategory> m_categories;
    private RTCHashMap m_map;

    private char getServiceStatus(long nodeid, InetAddress ip, String svc) {
        JdbcTemplate template = new JdbcTemplate(this.getConnectionFactory());
        String status = (String)template.queryForObject("SELECT status from ifservices, service where ((ifservices.nodeid = ?) AND (ifservices.ipaddr = ?) AND (ifservices.serviceid = service.serviceid) AND (service.servicename = ?))", new Object[]{nodeid, InetAddressUtils.str((InetAddress)ip), svc}, String.class);
        if (status == null) {
            return '\u0000';
        }
        return status.charAt(0);
    }

    private void addOutageToRTCNode(RTCNode rtcN, Timestamp lostTimeTS, Timestamp regainedTimeTS) {
        if (lostTimeTS == null) {
            return;
        }
        long lostTime = lostTimeTS.getTime();
        long regainedTime = -1L;
        if (regainedTimeTS != null) {
            regainedTime = regainedTimeTS.getTime();
        }
        LOG.debug("lost time for nodeid/ip/svc: {}/{}/{}: {}/{}", new Object[]{rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), lostTimeTS, lostTime});
        LOG.debug("regained time for nodeid/ip/svc: {}/{}/{}: {}/{}", new Object[]{rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), regainedTimeTS, regainedTime});
        rtcN.addSvcTime(lostTime, regainedTime);
    }

    private void addRTCNode(RTCNode rtcN) {
        this.m_map.add(rtcN);
    }

    private void addNodeToCategory(RTCCategory cat, RTCNode rtcN) {
        rtcN.addCategory(cat.getLabel());
        cat.addNode(rtcN);
        LOG.debug("rtcN : {}/{}/{} added to cat: {}", new Object[]{rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), cat.getLabel()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCategoriesMap() {
        CatFactory cFactory = null;
        try {
            CategoryFactory.init();
            cFactory = CategoryFactory.getInstance();
        }
        catch (IOException ex) {
            LOG.error("Failed to load categories information", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (MarshalException ex) {
            LOG.error("Failed to load categories information", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            LOG.error("Failed to load categories information", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.m_categories = new HashMap<String, RTCCategory>();
        cFactory.getReadLock().lock();
        try {
            for (Categorygroup cg : cFactory.getConfig().getCategorygroupCollection()) {
                String commonRule = cg.getCommon().getRule();
                for (Category cat : cg.getCategories().getCategoryCollection()) {
                    this.m_categories.put(new RTCCategory(cat, commonRule).getLabel(), new RTCCategory(cat, commonRule));
                }
            }
        }
        finally {
            cFactory.getReadLock().unlock();
        }
    }

    private void populateNodesFromDB(String query, Object[] args) throws SQLException, FilterParseException, RTCException {
        String getOutagesInWindow = "select        ifsvc.nodeid as nodeid,        ifsvc.ipAddr as ipaddr,        s.servicename as servicename,        o.ifLostService as ifLostService,        o.ifRegainedService as ifRegainedService   from        ifservices ifsvc   join        service s on (ifsvc.serviceid = s.serviceid) left outer  join        outages o on           (            o.nodeid = ifsvc.nodeid             and o.ipaddr = ifsvc.ipaddr             and o.serviceid = ifsvc.serviceid             and             (               o.ifLostService > ?                OR  o.ifRegainedService > ?                OR  o.ifRegainedService is null             )          )  where ifsvc.status='A' " + (query == null ? "" : "and " + query) + " order by " + "       ifsvc.nodeid, ifsvc.ipAddr, ifsvc.serviceid, o.ifLostService ";
        long window = new Date().getTime() - RTCManager.getRollingWindow();
        Timestamp windowTS = new Timestamp(window);
        RTCNodeProcessor rowHandler = new RTCNodeProcessor();
        Object[] sqlArgs = this.createArgs(windowTS, windowTS, args);
        JdbcTemplate template = new JdbcTemplate(this.getConnectionFactory());
        template.query(getOutagesInWindow, sqlArgs, (RowCallbackHandler)rowHandler);
    }

    private Object[] createArgs(Object arg1, Object arg2, Object[] remaining) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        if (remaining != null) {
            args.addAll(Arrays.asList(remaining));
        }
        return args.toArray();
    }

    public DataManager() throws SAXException, IOException, SQLException, FilterParseException, RTCException {
        this.createCategoriesMap();
        if (this.m_categories == null || this.m_categories.isEmpty()) {
            throw new RTCException("No categories found in categories.xml");
        }
        LOG.debug("Number of categories read: {}", (Object)this.m_categories.size());
        this.m_map = new RTCHashMap(30000);
        this.populateNodesFromDB(null, null);
    }

    private DataSource getConnectionFactory() {
        return DataSourceFactory.getInstance();
    }

    public synchronized void nodeGainedService(long nodeid, InetAddress ip, String svcName) {
        char svcStatus = this.getServiceStatus(nodeid, ip, svcName);
        if (svcStatus != 'A') {
            LOG.info("nodeGainedSvc: {}/{}/{} IGNORED because status is not active: {}", new Object[]{nodeid, ip, svcName, Character.valueOf(svcStatus)});
        } else {
            LOG.debug("nodeGainedSvc: {}/{}/{}/{}", new Object[]{nodeid, ip, svcName, Character.valueOf(svcStatus)});
            LOG.debug("rtcN : Rescanning services on : {}", (Object)ip);
            try {
                this.rtcNodeRescan(nodeid);
            }
            catch (FilterParseException ex) {
                LOG.warn("Failed to unmarshall database config", (Throwable)ex);
                throw new UndeclaredThrowableException(ex);
            }
            catch (SQLException ex) {
                LOG.warn("Failed to get database connection", (Throwable)ex);
                throw new UndeclaredThrowableException(ex);
            }
            catch (RTCException ex) {
                LOG.warn("Failed to get database connection", (Throwable)ex);
                throw new UndeclaredThrowableException(ex);
            }
        }
    }

    public synchronized void nodeLostService(long nodeid, InetAddress ip, String svcName, long t) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        RTCNode rtcN = this.m_map.getRTCNode(key);
        if (rtcN == null) {
            LOG.info("Received a nodeLostService event for an unknown/irrelevant node: {}", (Object)key.toString());
            return;
        }
        rtcN.nodeLostService(t);
    }

    public synchronized void interfaceDown(long nodeid, InetAddress ip, long t) {
        for (RTCNode rtcN : this.m_map.getRTCNodes(nodeid, ip)) {
            rtcN.nodeLostService(t);
        }
    }

    public synchronized void nodeDown(long nodeid, long t) {
        for (RTCNode rtcN : this.m_map.getRTCNodes(nodeid)) {
            rtcN.nodeLostService(t);
        }
    }

    public synchronized void nodeUp(long nodeid, long t) {
        for (RTCNode rtcN : this.m_map.getRTCNodes(nodeid)) {
            rtcN.nodeRegainedService(t);
        }
    }

    public synchronized void interfaceUp(long nodeid, InetAddress ip, long t) {
        for (RTCNode rtcN : this.m_map.getRTCNodes(nodeid, ip)) {
            rtcN.nodeRegainedService(t);
        }
    }

    public synchronized void nodeRegainedService(long nodeid, InetAddress ip, String svcName, long t) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        RTCNode rtcN = this.m_map.getRTCNode(key);
        if (rtcN == null) {
            LOG.info("Received a nodeRegainedService event for an unknown/irrelevant node: {}", (Object)key.toString());
            return;
        }
        rtcN.nodeRegainedService(t);
    }

    public synchronized void serviceDeleted(long nodeid, InetAddress ip, String svcName) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        RTCNode rtcN = this.m_map.getRTCNode(key);
        if (rtcN == null) {
            LOG.warn("Received a {} event for an unknown node: {}", (Object)"uei.opennms.org/nodes/serviceDeleted", (Object)key.toString());
            return;
        }
        List<String> categories = rtcN.getCategories();
        ListIterator<String> catIter = categories.listIterator();
        while (catIter.hasNext()) {
            Long tmpNodeid;
            String catlabel = catIter.next();
            RTCCategory cat = this.m_categories.get(catlabel);
            List<Long> catNodes = cat.getNodes();
            int nIndex = catNodes.indexOf(tmpNodeid = Long.valueOf(rtcN.getNodeID()));
            if (nIndex == -1) continue;
            if (this.m_map.getServiceCount(nodeid, catlabel) == 1) {
                catNodes.remove(nIndex);
                LOG.info("Removing node from category: {}", (Object)catlabel);
            }
            catIter.remove();
        }
        this.m_map.delete(rtcN);
    }

    public synchronized void assetInfoChanged(long nodeid) {
        try {
            this.rtcNodeRescan(nodeid);
        }
        catch (FilterParseException ex) {
            LOG.warn("Failed to unmarshall database config", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (SQLException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (RTCException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public synchronized void nodeCategoryMembershipChanged(long nodeid) {
        try {
            this.rtcNodeRescan(nodeid);
        }
        catch (FilterParseException ex) {
            LOG.warn("Failed to unmarshall database config", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (SQLException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (RTCException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public synchronized void rtcNodeRescan(long nodeid) throws SQLException, FilterParseException, RTCException {
        for (RTCCategory cat : this.m_categories.values()) {
            cat.deleteNode(nodeid);
        }
        this.m_map.deleteNode(nodeid);
        this.populateNodesFromDB("ifsvc.nodeid = ?", new Object[]{nodeid});
    }

    public synchronized void interfaceReparented(InetAddress ip, long oldNodeId, long newNodeId) {
        List<RTCNode> nodesList = this.m_map.getRTCNodes(oldNodeId, ip);
        ListIterator listIter = new LinkedList<RTCNode>(nodesList).listIterator();
        while (listIter.hasNext()) {
            RTCNode rtcN = (RTCNode)listIter.next();
            this.m_map.delete(rtcN);
            rtcN.setNodeID(newNodeId);
            this.m_map.add(rtcN);
            ListIterator<String> catIter = rtcN.getCategories().listIterator();
            while (catIter.hasNext()) {
                String catlabel = (String)catIter.next();
                RTCCategory rtcCat = this.m_categories.get(catlabel);
                rtcCat.deleteNode(oldNodeId);
                rtcCat.addNode(newNodeId);
            }
        }
    }

    public synchronized double getValue(String catLabel, long curTime, long rollingWindow) {
        return this.m_map.getValue(catLabel, curTime, rollingWindow);
    }

    public synchronized double getValue(long nodeid, String catLabel, long curTime, long rollingWindow) {
        return this.m_map.getValue(nodeid, catLabel, curTime, rollingWindow);
    }

    public synchronized int getServiceCount(long nodeid, String catLabel) {
        return this.m_map.getServiceCount(nodeid, catLabel);
    }

    public synchronized int getServiceDownCount(long nodeid, String catLabel) {
        return this.m_map.getServiceDownCount(nodeid, catLabel);
    }

    public synchronized Map<String, RTCCategory> getCategories() {
        return this.m_categories;
    }

    private class RTCNodeProcessor
    implements RowCallbackHandler {
        RTCNodeKey m_currentKey = null;
        Map<String, Set<Integer>> m_categoryNodeIdLists = new HashMap<String, Set<Integer>>();

        private RTCNodeProcessor() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            RTCNodeKey key = new RTCNodeKey(rs.getLong("nodeid"), InetAddressUtils.addr((String)rs.getString("ipaddr")), rs.getString("servicename"));
            this.processKey(key);
            this.processOutage(key, rs.getTimestamp("ifLostService"), rs.getTimestamp("ifRegainedService"));
        }

        private void processKey(RTCNodeKey key) {
            if (!this.matchesCurrent(key)) {
                this.m_currentKey = key;
                this.processIfService(key);
            }
        }

        private boolean matchesCurrent(RTCNodeKey key) {
            return this.m_currentKey != null && this.m_currentKey.equals(key);
        }

        public synchronized void processIfService(RTCNodeKey key) {
            for (RTCCategory cat : DataManager.this.m_categories.values()) {
                if (!this.catContainsIfService(cat, key)) continue;
                RTCNode rtcN = this.getRTCNode(key);
                DataManager.this.addNodeToCategory(cat, rtcN);
            }
        }

        private RTCNode getRTCNode(RTCNodeKey key) {
            RTCNode rtcN = DataManager.this.m_map.getRTCNode(key);
            if (rtcN == null) {
                rtcN = new RTCNode(key);
                DataManager.this.addRTCNode(rtcN);
            }
            return rtcN;
        }

        private boolean catContainsIfService(RTCCategory cat, RTCNodeKey key) {
            return cat.containsService(key.getSvcName()) && this.catContainsNode(cat, (int)key.getNodeID());
        }

        private boolean catContainsNode(RTCCategory cat, Integer nodeID) {
            Set<Integer> nodeIds = this.catGetNodeIds(cat);
            return nodeIds.contains(nodeID);
        }

        private Set<Integer> catGetNodeIds(RTCCategory cat) {
            Set<Integer> nodeIds = this.m_categoryNodeIdLists.get(cat.getLabel());
            if (nodeIds == null) {
                nodeIds = this.catConstructNodeIds(cat);
                this.m_categoryNodeIdLists.put(cat.getLabel(), nodeIds);
            }
            return nodeIds;
        }

        private Set<Integer> catConstructNodeIds(RTCCategory cat) {
            String filterRule = cat.getEffectiveRule();
            try {
                LOG.debug("Category: {}\t{}", (Object)cat.getLabel(), (Object)filterRule);
                Set<Integer> nodeIds = FilterDaoFactory.getInstance().getNodeMap(filterRule).keySet();
                LOG.debug("Number of nodes satisfying rule: {}", (Object)nodeIds.size());
                return nodeIds;
            }
            catch (FilterParseException e) {
                LOG.error("Unable to parse filter rule {} ignoring category {}", new Object[]{filterRule, cat.getLabel(), e});
                return Collections.emptySet();
            }
        }

        public void processOutage(RTCNodeKey key, Timestamp ifLostService, Timestamp ifRegainedService) {
            RTCNode rtcN = DataManager.this.m_map.getRTCNode(key);
            if (rtcN == null) {
                return;
            }
            DataManager.this.addOutageToRTCNode(rtcN, ifLostService, ifRegainedService);
        }
    }
}

