/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.Querier;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerEventProcessor;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.DbPollEvent;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class Poller
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Poller.class);
    private static final String LOG4J_CATEGORY = "poller";
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private PollerEventProcessor m_eventProcessor;
    private PollableNetwork m_network;
    @Autowired
    private QueryManager m_queryManager;
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private EventIpcManager m_eventMgr;
    @Autowired
    private DataSource m_dataSource;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private TransactionTemplate m_transactionTemplate;

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.m_transactionTemplate = transactionTemplate;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventMgr = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventMgr;
    }

    public Poller() {
        super(LOG4J_CATEGORY);
    }

    void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public PollerEventProcessor getEventProcessor() {
        return this.m_eventProcessor;
    }

    public void setEventProcessor(PollerEventProcessor eventProcessor) {
        this.m_eventProcessor = eventProcessor;
    }

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork network) {
        this.m_network = network;
    }

    void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public PollOutagesConfig getPollOutagesConfig() {
        return this.m_pollOutagesConfig;
    }

    public void setPollOutagesConfig(PollOutagesConfig pollOutagesConfig) {
        this.m_pollOutagesConfig = pollOutagesConfig;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    protected void onInit() {
        LOG.debug("init: serviceUnresponsive behavior: {}", (Object)(this.getPollerConfig().isServiceUnresponsiveEnabled() ? "enabled" : "disabled"));
        this.createScheduler();
        try {
            LOG.debug("init: Closing outages for unmanaged services");
            this.m_queryManager.closeOutagesForUnmanagedServices();
        }
        catch (Throwable e) {
            LOG.error("init: Failed to close ouates for unmanage services", e);
        }
        try {
            LOG.debug("start: Scheduling existing interfaces");
            this.scheduleExistingServices();
        }
        catch (Throwable sqlE) {
            LOG.error("start: Failed to schedule existing interfaces", sqlE);
        }
        try {
            LOG.debug("start: Creating event broadcast event processor");
            this.setEventProcessor(new PollerEventProcessor(this));
        }
        catch (Throwable t) {
            LOG.error("start: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_initialized = true;
    }

    private void createScheduler() {
        try {
            LOG.debug("init: Creating poller scheduler");
            this.setScheduler(new LegacyScheduler("Poller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create poller scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStart() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("start: Starting poller scheduler");
            }
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            LOG.error("start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            this.getScheduler().stop();
        }
        if (this.getEventProcessor() != null) {
            this.getEventProcessor().close();
        }
        this.releaseServiceMonitors();
        this.setScheduler(null);
    }

    private void releaseServiceMonitors() {
        this.getPollerConfig().releaseAllServiceMonitors();
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public ServiceMonitor getServiceMonitor(String svcName) {
        return this.getPollerConfig().getServiceMonitor(svcName);
    }

    private void scheduleExistingServices() throws Exception {
        this.scheduleMatchingServices(null);
        this.getNetwork().recalculateStatus();
        this.getNetwork().propagateInitialCause();
        this.getNetwork().resetStatusChanged();
        LOG.debug("scheduleExistingServices: dumping content of pollable network: ");
        this.getNetwork().dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleService(final int nodeId, String nodeLabel, final String ipAddr, final String svcName) {
        final String normalizedAddress = InetAddressUtils.normalize((String)ipAddr);
        try {
            PollableNode node;
            PollableNetwork pollableNetwork = this.getNetwork();
            synchronized (pollableNetwork) {
                node = this.getNetwork().getNode(nodeId);
                if (node == null) {
                    node = this.getNetwork().createNode(nodeId, nodeLabel);
                }
            }
            final PollableNode svcNode = node;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Poller.this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                            OnmsMonitoredService service = Poller.this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddressUtils.addr((String)ipAddr), svcName);
                            OnmsIpInterface iface = service.getIpInterface();
                            Set outages = service.getCurrentOutages();
                            OnmsOutage outage = outages == null || outages.size() < 1 ? null : (OnmsOutage)outages.iterator().next();
                            OnmsEvent event = outage == null ? null : outage.getServiceLostEvent();
                            if (Poller.this.scheduleService(service.getNodeId(), iface.getNode().getLabel(), InetAddressUtils.str((InetAddress)iface.getIpAddress()), service.getServiceName(), "A".equals(service.getStatus()), event == null ? null : event.getId(), outage == null ? null : outage.getIfLostService(), event == null ? null : event.getEventUei())) {
                                svcNode.recalculateStatus();
                                svcNode.processStatusChange(new Date());
                            } else {
                                LOG.warn("Attempt to schedule service {}/{}/{} found no active service", new Object[]{nodeId, normalizedAddress, svcName});
                            }
                        }
                    });
                }
            };
            node.withTreeLock(r);
        }
        catch (Throwable e) {
            LOG.error("Unable to schedule service {}/{}/{}", new Object[]{nodeId, normalizedAddress, svcName});
        }
    }

    private int scheduleMatchingServices(String criteria) {
        String sql = "SELECT ifServices.nodeId AS nodeId, node.nodeLabel AS nodeLabel, ifServices.ipAddr AS ipAddr, ifServices.serviceId AS serviceId, service.serviceName AS serviceName, ifServices.status as status, outages.svcLostEventId AS svcLostEventId, events.eventUei AS svcLostEventUei, outages.ifLostService AS ifLostService, outages.ifRegainedService AS ifRegainedService FROM ifServices JOIN node ON ifServices.nodeId = node.nodeId JOIN service ON ifServices.serviceId = service.serviceId LEFT OUTER JOIN outages ON ifServices.nodeId = outages.nodeId AND ifServices.ipAddr = outages.ipAddr AND ifServices.serviceId = outages.serviceId AND ifRegainedService IS NULL LEFT OUTER JOIN events ON outages.svcLostEventId = events.eventid WHERE ifServices.status in ('A','N')" + (criteria == null ? "" : " AND " + criteria);
        final AtomicInteger count = new AtomicInteger(0);
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                if (Poller.this.scheduleService(rs.getInt("nodeId"), rs.getString("nodeLabel"), rs.getString("ipAddr"), rs.getString("serviceName"), "A".equals(rs.getString("status")), (Number)rs.getObject("svcLostEventId"), rs.getTimestamp("ifLostService"), rs.getString("svcLostEventUei"))) {
                    count.incrementAndGet();
                }
            }
        };
        querier.execute(new Object[0]);
        return count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleService(int nodeId, String nodeLabel, String ipAddr, String serviceName, boolean active, Number svcLostEventId, Date date, String svcLostUei) {
        ServiceMonitor monitor;
        Package pkg = this.findPackageForService(ipAddr, serviceName);
        boolean verifyServer = OpennmsServerConfigFactory.getInstance().verifyServer();
        if (pkg == null) {
            if (active && !verifyServer) {
                LOG.warn("Active service {} on {} not configured for any package. Marking as Not Polled.", (Object)serviceName, (Object)ipAddr);
                this.m_queryManager.updateServiceStatus(nodeId, ipAddr, serviceName, "N");
            }
            return false;
        }
        if (!active && !verifyServer) {
            LOG.info("Active service {} on {} is now configured for a package. Marking as active.", (Object)serviceName, (Object)ipAddr);
            this.m_queryManager.updateServiceStatus(nodeId, ipAddr, serviceName, "A");
        }
        if ((monitor = this.m_pollerConfig.getServiceMonitor(serviceName)) == null) {
            LOG.info("Could not find service monitor associated with service {}", (Object)serviceName);
            return false;
        }
        InetAddress addr = InetAddressUtils.addr((String)ipAddr);
        if (addr == null) {
            LOG.error("Could not convert {} as an InetAddress {}", (Object)ipAddr, (Object)ipAddr);
            return false;
        }
        PollableService svc = this.getNetwork().createService(nodeId, nodeLabel, addr, serviceName);
        PollableServiceConfig pollConfig = new PollableServiceConfig(svc, this.m_pollerConfig, this.m_pollOutagesConfig, pkg, this.getScheduler());
        svc.setPollConfig(pollConfig);
        PollableService pollableService = svc;
        synchronized (pollableService) {
            if (svc.getSchedule() == null) {
                Schedule schedule = new Schedule(svc, pollConfig, this.getScheduler());
                svc.setSchedule(schedule);
            }
        }
        if (svcLostEventId == null) {
            if (svc.getParent().getStatus().isUnknown()) {
                svc.updateStatus(PollStatus.up());
            } else {
                svc.updateStatus(svc.getParent().getStatus());
            }
        } else {
            svc.updateStatus(PollStatus.down());
            DbPollEvent cause = new DbPollEvent(svcLostEventId.intValue(), svcLostUei, date);
            svc.setCause(cause);
        }
        svc.schedule();
        return true;
    }

    Package findPackageForService(String ipAddr, String serviceName) {
        Enumeration en = this.m_pollerConfig.enumeratePackage();
        Package lastPkg = null;
        while (en.hasMoreElements()) {
            Package pkg = (Package)en.nextElement();
            if (!this.pollableServiceInPackage(ipAddr, serviceName, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    protected boolean pollableServiceInPackage(String ipAddr, String serviceName, Package pkg) {
        if (pkg.getRemote().booleanValue()) {
            LOG.debug("pollableServiceInPackage: this package: {}, is a remote monitor package.", (Object)pkg.getName());
            return false;
        }
        if (!this.m_pollerConfig.isServiceInPackageAndEnabled(serviceName, pkg)) {
            return false;
        }
        boolean inPkg = this.m_pollerConfig.isInterfaceInPackage(ipAddr, pkg);
        if (inPkg) {
            return true;
        }
        if (this.m_initialized) {
            this.m_pollerConfig.rebuildPackageIpListMap();
            return this.m_pollerConfig.isInterfaceInPackage(ipAddr, pkg);
        }
        return false;
    }

    public boolean packageIncludesIfAndSvc(Package pkg, String ipAddr, String svcName) {
        if (!this.getPollerConfig().isServiceInPackageAndEnabled(svcName, pkg)) {
            LOG.debug("packageIncludesIfAndSvc: address/service: {}/{} not scheduled, service is not enabled or does not exist in package: {}", new Object[]{ipAddr, svcName, pkg.getName()});
            return false;
        }
        if (!this.getPollerConfig().isInterfaceInPackage(ipAddr, pkg)) {
            if (this.m_initialized) {
                this.getPollerConfig().rebuildPackageIpListMap();
                if (!this.getPollerConfig().isInterfaceInPackage(ipAddr, pkg)) {
                    LOG.debug("packageIncludesIfAndSvc: interface {} gained service {}, but the interface was not in package: {}", new Object[]{ipAddr, svcName, pkg.getName()});
                    return false;
                }
            } else {
                LOG.debug("packageIncludesIfAndSvc: address/service: {}/{} not scheduled, interface does not belong to package: {}", new Object[]{ipAddr, svcName, pkg.getName()});
                return false;
            }
        }
        return true;
    }

    public void refreshServicePackages() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            @Override
            public void visitService(PollableService service) {
                service.refreshConfig();
            }
        };
        this.getNetwork().visit(visitor);
    }

    public void refreshServiceThresholds() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            @Override
            public void visitService(PollableService service) {
                service.refreshThresholds();
            }
        };
        this.getNetwork().visit(visitor);
    }

    public long getNumPolls() {
        if (this.m_scheduler != null) {
            return this.m_scheduler.getNumTasksExecuted();
        }
        return 0L;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

