/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.PathOutageDao;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsPathOutage;
import org.opennms.netmgt.poller.PathOutageManager;
import org.springframework.beans.factory.annotation.Autowired;

public class PathOutageManagerDaoImpl
implements PathOutageManager {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private PathOutageDao pathOutageDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private OutageDao outageDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    public static final String NO_CRITICAL_PATH = "Not Configured";

    @Override
    public List<String[]> getAllCriticalPaths() throws SQLException {
        ArrayList<String[]> paths = new ArrayList<String[]>();
        List outs = this.pathOutageDao.findAll();
        for (OnmsPathOutage out : outs) {
            String[] path = new String[]{InetAddressUtils.str((InetAddress)out.getCriticalPathIp()), out.getCriticalPathServiceName()};
            paths.add(path);
        }
        return paths;
    }

    @Override
    public String getPrettyCriticalPath(int nodeID) {
        String result = NO_CRITICAL_PATH;
        OnmsPathOutage out = (OnmsPathOutage)this.pathOutageDao.get((Serializable)Integer.valueOf(nodeID));
        result = InetAddressUtils.str((InetAddress)out.getCriticalPathIp()) + " " + out.getCriticalPathServiceName();
        return result;
    }

    @Override
    public String[] getCriticalPath(int nodeId) {
        OnmsPathOutage out = (OnmsPathOutage)this.pathOutageDao.get((Serializable)Integer.valueOf(nodeId));
        String[] cpath = new String[]{InetAddressUtils.str((InetAddress)out.getCriticalPathIp()), out.getCriticalPathServiceName()};
        if (cpath[0] != null && cpath[1] != "") {
            cpath[0] = InetAddressUtils.str((InetAddress)out.getCriticalPathIp());
            cpath[1] = out.getCriticalPathServiceName();
        } else if (cpath[0] == null || cpath[0].equals("")) {
            cpath[0] = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathIp();
            cpath[1] = "ICMP";
        } else if (cpath[1] == null || cpath[1].equals("")) {
            cpath[1] = "ICMP";
        }
        return cpath;
    }

    @Override
    public Set<Integer> getNodesInPath(String criticalPathIp, String criticalPathServiceName) {
        TreeSet<Integer> pathNodes = new TreeSet<Integer>();
        List outs = this.pathOutageDao.findAll();
        for (OnmsPathOutage out : outs) {
            String node = out.getCriticalPathServiceName();
            if (!node.equals(criticalPathServiceName)) continue;
            pathNodes.add(out.getNode().getId());
        }
        return pathNodes;
    }

    @Override
    public String[] getLabelAndStatus(String nodeIDStr, Connection conn) {
        int countManagedSvcs = 0;
        int countOutages = 0;
        String[] result = new String[3];
        result[1] = "Cleared";
        result[2] = "Unmanaged";
        int nodeID = WebSecurityUtils.safeParseInt((String)nodeIDStr);
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeID));
        result[0] = node.getLabel();
        List serve = this.monitoredServiceDao.findAll();
        for (OnmsMonitoredService cur : serve) {
            if (!"A".equals(cur.getStatus()) || nodeID != cur.getNodeId()) continue;
            ++countManagedSvcs;
        }
        if (countManagedSvcs > 0) {
            List out = this.outageDao.findAll();
            for (OnmsOutage outs : out) {
                if (outs.getServiceRegainedEvent() != null) continue;
                ++countOutages;
            }
            if (countManagedSvcs == countOutages) {
                result[1] = "Critical";
                result[2] = "All Services Down";
            } else if (countOutages == 0) {
                result[1] = "Normal";
                result[2] = "All Services Up";
            } else {
                result[1] = "Minor";
                result[2] = "Some Services Down";
            }
        }
        return result;
    }

    @Override
    public String[] getCriticalPathData(String criticalPathIp, String criticalPathServiceName) {
        String[] result = new String[4];
        int count = 0;
        OnmsNode node = new OnmsNode();
        Criteria criteria = new Criteria(OnmsNode.class).setAliases(Arrays.asList(new Alias("ipInterfaces", "ipInterfaces", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("ipInterfaces.ipAddress", (Object)InetAddressUtils.addr((String)criticalPathIp))).addRestriction((Restriction)new NeRestriction("ipInterfaces.isManaged", (Object)"D"));
        List nList = this.nodeDao.findMatching(criteria);
        if (nList.size() < 1) {
            return result;
        }
        if (nList.size() == 1) {
            node = (OnmsNode)nList.get(0);
            result[0] = node.getLabel();
        } else if (nList.size() > 1) {
            result[0] = "(" + nList.size() + " nodes have this IP)";
        }
        result[1] = node.getNodeId();
        result[2] = Integer.toString(nList.size());
        Criteria crit = new Criteria(OnmsOutage.class).setAliases(Arrays.asList(new Alias("monitoredService", "monitoredService", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new NullRestriction("ifRegainedService")).addRestriction((Restriction)new EqRestriction("serviceType.name", (Object)criticalPathServiceName)).addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)criticalPathIp)));
        List oList = this.outageDao.findMatching(crit);
        count = oList.size();
        if (count > 0) {
            Criteria tres = new Criteria(OnmsMonitoredService.class).setAliases(Arrays.asList(new Alias("serviceType", "monitoredService.serviceType", Alias.JoinType.LEFT_JOIN))).addRestriction((Restriction)new EqRestriction("status", (Object)OnmsArpInterface.StatusType.ACTIVE)).addRestriction((Restriction)new EqRestriction("serviceType.name", (Object)criticalPathServiceName)).addRestriction((Restriction)new EqRestriction("ipAddress", (Object)InetAddressUtils.addr((String)criticalPathIp)));
            List oms = this.monitoredServiceDao.findMatching(tres);
            count = oms.size();
            result[3] = count > 0 ? "Critical" : "Normal";
            for (OnmsMonitoredService open : oms) {
                result[3] = open.getStatus();
            }
        } else {
            result[3] = "Cleared";
        }
        return result;
    }

    @Override
    public Set<Integer> getDependencyNodesByCriticalPath(String criticalPathip) {
        TreeSet<Integer> depNodes = new TreeSet<Integer>();
        Criteria crit = new Criteria(OnmsPathOutage.class).addRestriction((Restriction)new EqRestriction("criticalPathIp", (Object)criticalPathip)).setOrders(Arrays.asList(Order.asc((String)"nodeId")));
        List l = this.pathOutageDao.findMatching(crit);
        for (OnmsPathOutage cur : l) {
            List iface = this.ipInterfaceDao.findByNodeId(Integer.valueOf(cur.getNodeId()));
            for (OnmsIpInterface one : iface) {
                if (one.getIsManaged() == "D") continue;
                depNodes.add(cur.getNodeId());
            }
        }
        return depNodes;
    }

    @Override
    public Set<Integer> getDependencyNodesByNodeId(int nodeId) {
        TreeSet<Integer> depNodes = new TreeSet<Integer>();
        Criteria crit = new Criteria(OnmsPathOutage.class).addRestriction((Restriction)new EqRestriction("nodeId", (Object)nodeId));
        List l = this.pathOutageDao.findMatching(crit);
        for (OnmsPathOutage cur : l) {
            List iface = this.ipInterfaceDao.findByNodeId(Integer.valueOf(cur.getNodeId()));
            for (OnmsIpInterface one : iface) {
                if (!one.getIpAddress().equals(cur.getCriticalPathIp())) continue;
                depNodes.add(cur.getNodeId());
            }
        }
        return depNodes;
    }
}

