/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.plugins.IcmpPlugin;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.poller.PathOutageManagerJdbcImpl;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.PendingPollEvent;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPollContext
implements PollContext,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollContext.class);
    private static final String[] UEIS = new String[]{"uei.opennms.org/nodes/serviceUnresponsive", "uei.opennms.org/nodes/serviceResponsive", "uei.opennms.org/nodes/nodeRegainedService", "uei.opennms.org/nodes/nodeLostService", "uei.opennms.org/nodes/interfaceDown", "uei.opennms.org/nodes/interfaceUp", "uei.opennms.org/nodes/nodeDown", "uei.opennms.org/nodes/nodeUp"};
    private volatile PollerConfig m_pollerConfig;
    private volatile QueryManager m_queryManager;
    private volatile EventIpcManager m_eventManager;
    private volatile String m_name;
    private volatile String m_localHostName;
    private volatile boolean m_listenerAdded = false;
    private final List<PendingPollEvent> m_pendingPollEvents = new LinkedList<PendingPollEvent>();

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setLocalHostName(String localHostName) {
        this.m_localHostName = localHostName;
    }

    public String getLocalHostName() {
        return this.m_localHostName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    @Override
    public String getCriticalServiceName() {
        return this.getPollerConfig().getCriticalService();
    }

    @Override
    public boolean isNodeProcessingEnabled() {
        return this.getPollerConfig().isNodeOutageProcessingEnabled();
    }

    @Override
    public boolean isPollingAllIfCritServiceUndefined() {
        return this.getPollerConfig().shouldPollAllIfNoCriticalServiceDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollEvent sendEvent(Event event) {
        if (!this.m_listenerAdded) {
            this.getEventManager().addEventListener((EventListener)this, Arrays.asList(UEIS));
            this.m_listenerAdded = true;
        }
        PendingPollEvent pollEvent = new PendingPollEvent(event);
        List<PendingPollEvent> list = this.m_pendingPollEvents;
        synchronized (list) {
            this.m_pendingPollEvents.add(pollEvent);
        }
        this.getEventManager().sendNow(event);
        return pollEvent;
    }

    @Override
    public Event createEvent(String uei, int nodeId, InetAddress address, String svcName, Date date, String reason) {
        LOG.debug("createEvent: uei = {} nodeid = {}", (Object)uei, (Object)nodeId);
        EventBuilder bldr = new EventBuilder(uei, this.getName(), date);
        bldr.setNodeid((long)nodeId);
        if (address != null) {
            bldr.setInterface(address);
        }
        if (svcName != null) {
            bldr.setService(svcName);
        }
        bldr.setHost(this.getLocalHostName());
        if (uei.equals("uei.opennms.org/nodes/nodeDown") && this.getPollerConfig().isPathOutageEnabled()) {
            String[] criticalPath = PathOutageManagerJdbcImpl.getInstance().getCriticalPath(nodeId);
            if (criticalPath[0] != null && !"".equals(criticalPath[0].trim())) {
                if (!this.testCriticalPath(criticalPath)) {
                    LOG.debug("Critical path test failed for node {}", (Object)nodeId);
                    bldr.addParam("eventReason", "pathOutage");
                    bldr.addParam("criticalPathIp", criticalPath[0]);
                    bldr.addParam("criticalPathServiceName", criticalPath[1]);
                } else {
                    LOG.debug("Critical path test passed for node {}", (Object)nodeId);
                }
            } else {
                LOG.debug("No Critical path to test for node {}", (Object)nodeId);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeLostService")) {
            bldr.addParam("eventReason", reason == null ? "Unknown" : reason);
        }
        if (uei.equals("uei.opennms.org/nodes/nodeUp") || uei.equals("uei.opennms.org/nodes/nodeDown")) {
            String nodeLabel = this.getNodeLabel(nodeId);
            bldr.addParam("nodelabel", nodeLabel);
        }
        return bldr.getEvent();
    }

    @Override
    public void openOutage(final PollableService svc, final PollEvent svcLostEvent) {
        LOG.debug("openOutage: Opening outage for: {} with event:{}", (Object)svc, (Object)svcLostEvent);
        final int nodeId = svc.getNodeId();
        final String ipAddr = svc.getIpAddr();
        final String svcName = svc.getSvcName();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LOG.debug("run: Opening outage with query manager: {} with event:{}", (Object)svc, (Object)svcLostEvent);
                int eventId = svcLostEvent.getEventId();
                if (eventId > 0) {
                    DefaultPollContext.this.getQueryManager().openOutage(DefaultPollContext.this.getPollerConfig().getNextOutageIdSql(), nodeId, ipAddr, svcName, eventId, EventConstants.formatToString((Date)svcLostEvent.getDate()));
                } else {
                    LOG.warn("run: Failed to determine an eventId for service outage for: {} with event: {}", (Object)svc, (Object)svcLostEvent);
                }
            }
        };
        if (svcLostEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcLostEvent).addPending(r);
        } else {
            r.run();
        }
    }

    @Override
    public void resolveOutage(final PollableService svc, final PollEvent svcRegainEvent) {
        final int nodeId = svc.getNodeId();
        final String ipAddr = svc.getIpAddr();
        final String svcName = svc.getSvcName();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int eventId = svcRegainEvent.getEventId();
                if (eventId > 0) {
                    DefaultPollContext.this.getQueryManager().resolveOutage(nodeId, ipAddr, svcName, eventId, EventConstants.formatToString((Date)svcRegainEvent.getDate()));
                } else {
                    LOG.warn("run: Failed to determine an eventId for service regained for: {} with event: {}", (Object)svc, (Object)svcRegainEvent);
                }
            }
        };
        if (svcRegainEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcRegainEvent).addPending(r);
        } else {
            r.run();
        }
    }

    @Override
    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        this.getQueryManager().reparentOutages(ipAddr, oldNodeId, newNodeId);
    }

    @Override
    public boolean isServiceUnresponsiveEnabled() {
        return this.getPollerConfig().isServiceUnresponsiveEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event e) {
        LOG.debug("onEvent: Waiting to process event: {} uei: {}, dbid: {}", new Object[]{e, e.getUei(), e.getDbid()});
        List<PendingPollEvent> list = this.m_pendingPollEvents;
        synchronized (list) {
            LOG.debug("onEvent: Received event: {} uei: {}, dbid: {}, pendingEventCount: {}", new Object[]{e, e.getUei(), e.getDbid(), this.m_pendingPollEvents.size()});
            for (PendingPollEvent pollEvent : this.m_pendingPollEvents) {
                LOG.trace("onEvent: comparing events to poll event: {}", (Object)pollEvent);
                if (!e.equals(pollEvent.getEvent())) continue;
                LOG.trace("onEvent: completing pollevent: {}", (Object)pollEvent);
                pollEvent.complete(e);
            }
            Iterator<PendingPollEvent> it = this.m_pendingPollEvents.iterator();
            while (it.hasNext()) {
                PendingPollEvent pollEvent;
                pollEvent = it.next();
                LOG.trace("onEvent: determining if pollEvent is pending: {}", (Object)pollEvent);
                if (pollEvent.isPending()) continue;
                LOG.trace("onEvent: processing pending pollEvent...: {}", (Object)pollEvent);
                pollEvent.processPending();
                it.remove();
                LOG.trace("onEvent: processing of pollEvent completed.: {}", (Object)pollEvent);
            }
        }
        LOG.debug("onEvent: Finished processing event: {} uei: {}, dbid: {}", new Object[]{e, e.getUei(), e.getDbid()});
    }

    boolean testCriticalPath(String[] criticalPath) {
        InetAddress addr = null;
        boolean result = true;
        LOG.debug("Test critical path IP {}", (Object)criticalPath[0]);
        addr = InetAddressUtils.addr((String)criticalPath[0]);
        if (addr == null) {
            LOG.error("failed to convert string address to InetAddress {}", (Object)criticalPath[0]);
            return true;
        }
        IcmpPlugin p = new IcmpPlugin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("retry", Long.valueOf(OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathRetries()));
        map.put("timeout", Long.valueOf(OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathTimeout()));
        result = p.isProtocolSupported(addr, map);
        return result;
    }

    String getNodeLabel(int nodeId) {
        String nodeLabel = null;
        try {
            nodeLabel = this.getQueryManager().getNodeLabel(nodeId);
        }
        catch (SQLException sqlE) {
            LOG.warn("Failed to retrieve node label for nodeid {}", (Object)nodeId, (Object)sqlE);
        }
        if (nodeLabel == null) {
            nodeLabel = String.valueOf(nodeId);
        }
        return nodeLabel;
    }
}

