/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;

public abstract class Vlan
extends SnmpStore {
    private boolean hasVlanIndex = false;
    private Integer vlanIndex = null;
    public static final String VLAN_INDEX = "vlanIndex";
    public static final String VLAN_NAME = "vlanName";
    public static final String VLAN_STATUS = "vlanStatus";
    public static final String VLAN_TYPE = "vlanType";

    public Vlan(NamedSnmpVar[] list) {
        super(list);
    }

    public void storeResult(SnmpResult res) {
        if (!this.hasVlanIndex && !this.hasVlanIndexOid()) {
            this.vlanIndex = res.getInstance().getLastSubId();
            this.hasVlanIndex = true;
        }
        super.storeResult(res);
    }

    protected abstract boolean hasVlanIndexOid();

    public Integer getVlanIndex() {
        if (this.hasVlanIndex) {
            return this.vlanIndex;
        }
        return this.getInt32(VLAN_INDEX);
    }

    public String getVlanName() {
        return this.getDisplayString(VLAN_NAME);
    }

    public abstract OnmsVlan.VlanStatus getVlanStatus();

    public abstract OnmsVlan.VlanType getVlanType();

    public OnmsVlan getOnmsVlan() {
        return new OnmsVlan(this.getVlanIndex().intValue(), this.getVlanName(), this.getVlanStatus(), this.getVlanType());
    }
}

