/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.topology.AtInterface;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class Linkd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Linkd.class);
    protected static final String LOG_PREFIX = "linkd";
    private Scheduler m_scheduler;
    private QueryManager m_queryMgr;
    private LinkdConfig m_linkdConfig;
    private List<LinkableNode> m_nodes;
    private Map<String, Map<String, List<AtInterface>>> m_macToAtinterface = new HashMap<String, Map<String, List<AtInterface>>>();
    private Set<InetAddress> m_newSuspectEventsIpAddr = null;
    private volatile EventForwarder m_eventForwarder;

    public static InetAddress getNetwork(InetAddress ipaddress, InetAddress netmask) {
        byte[] ipAddress = ipaddress.getAddress();
        byte[] netMask = netmask.getAddress();
        byte[] netWork = new byte[4];
        for (int i = 0; i < 4; ++i) {
            netWork[i] = Integer.valueOf(ipAddress[i] & netMask[i]).byteValue();
        }
        return InetAddressUtils.getInetAddress((byte[])netWork);
    }

    public Linkd() {
        super(LOG_PREFIX);
        this.m_nodes = new ArrayList<LinkableNode>();
        Assert.notNull(this.m_nodes);
        this.m_newSuspectEventsIpAddr = Collections.synchronizedSet(new TreeSet(new InetAddressComparator()));
        this.m_newSuspectEventsIpAddr.add(InetAddressUtils.ONE_TWENTY_SEVEN);
        this.m_newSuspectEventsIpAddr.add(InetAddressUtils.ZEROS);
        Assert.notNull(this.m_newSuspectEventsIpAddr);
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        Assert.state((this.m_queryMgr != null ? 1 : 0) != 0, (String)"must set the queryManager property");
        Assert.state((this.m_linkdConfig != null ? 1 : 0) != 0, (String)"must set the linkdConfig property");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"must set the scheduler property");
        this.m_queryMgr.updateDeletedNodes();
        this.schedule(this.m_queryMgr.getSnmpNodeList());
        LOG.info("init: LINKD CONFIGURATION INITIALIZED");
    }

    private void schedule(List<LinkableSnmpNode> nodes) {
        for (LinkableSnmpNode node : nodes) {
            this.schedule(node);
        }
    }

    private void schedule(LinkableSnmpNode node) {
        for (SnmpCollection snmpcoll : this.getSnmpCollections(node.getNodeId(), node.getSnmpPrimaryIpAddr(), node.getSysoid())) {
            if (this.isDiscoveryLinkScheduled(snmpcoll.getPackageName())) {
                LOG.debug("schedule: package active: {}", (Object)snmpcoll.getPackageName());
            } else {
                DiscoveryLink discovery = this.getDiscoveryLink(snmpcoll.getPackageName());
                if (discovery.getScheduler() == null) {
                    discovery.setScheduler(this.m_scheduler);
                }
                LOG.debug("schedule:. Scheduling {}", (Object)discovery.getInfo());
                discovery.schedule();
            }
            if (snmpcoll.getScheduler() == null) {
                snmpcoll.setScheduler(this.m_scheduler);
            }
            this.m_nodes.add(new LinkableNode(node, snmpcoll.getPackageName()));
            LOG.debug("schedule: NodeId: {}. Scheduling {}", (Object)node.getNodeId(), (Object)snmpcoll.getInfo());
            snmpcoll.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDiscoveryLinkScheduled(String packageName) {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                if (!packageName.equals(node.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    public DiscoveryLink getDiscoveryLink(String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        if (pkg == null) {
            return null;
        }
        DiscoveryLink discoveryLink = new DiscoveryLink();
        discoveryLink.setLinkd(this);
        discoveryLink.setPackageName(pkg.getName());
        discoveryLink.setInitialSleepTime(this.m_linkdConfig.getInitialSleepTime());
        discoveryLink.setInterval(pkg.hasSnmp_poll_interval() ? pkg.getSnmp_poll_interval() : this.m_linkdConfig.getSnmpPollInterval());
        discoveryLink.setDiscoveryInterval(pkg.hasDiscovery_link_interval() ? pkg.getDiscovery_link_interval() : this.m_linkdConfig.getDiscoveryLinkInterval());
        discoveryLink.setDiscoveryUsingBridge(pkg.hasUseBridgeDiscovery() ? pkg.getUseBridgeDiscovery() : this.m_linkdConfig.useBridgeDiscovery());
        discoveryLink.setDiscoveryUsingCdp(pkg.hasUseCdpDiscovery() ? pkg.getUseCdpDiscovery() : this.m_linkdConfig.useCdpDiscovery());
        discoveryLink.setDiscoveryUsingRoutes(pkg.hasUseIpRouteDiscovery() ? pkg.getUseIpRouteDiscovery() : this.m_linkdConfig.useIpRouteDiscovery());
        discoveryLink.setDiscoveryUsingLldp(pkg.hasUseLldpDiscovery() ? pkg.getUseLldpDiscovery() : this.m_linkdConfig.useLldpDiscovery());
        discoveryLink.setDiscoveryUsingOspf(pkg.hasUseOspfDiscovery() ? pkg.getUseOspfDiscovery() : this.m_linkdConfig.useOspfDiscovery());
        discoveryLink.setDiscoveryUsingIsIs(pkg.hasUseIsisDiscovery() ? pkg.getUseIsisDiscovery() : this.m_linkdConfig.useIsIsDiscovery());
        discoveryLink.setDiscoveryUsingWifi(pkg.hasUseWifiDiscovery() ? pkg.getUseWifiDiscovery() : this.m_linkdConfig.useWifiDiscovery());
        return discoveryLink;
    }

    protected SnmpCollection getSnmpCollection(int nodeid, InetAddress ipaddr, String sysoid, String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        if (pkg != null) {
            SnmpCollection collection = this.createCollection(nodeid, ipaddr);
            this.populateSnmpCollection(collection, pkg, sysoid);
            return collection;
        }
        return null;
    }

    private List<SnmpCollection> getSnmpCollections(int nodeid, InetAddress ipaddr, String sysoid) {
        ArrayList<SnmpCollection> snmpcolls = new ArrayList<SnmpCollection>();
        for (String pkgName : this.m_linkdConfig.getAllPackageMatches(ipaddr)) {
            snmpcolls.add(this.getSnmpCollection(nodeid, ipaddr, sysoid, pkgName));
        }
        return snmpcolls;
    }

    private SnmpCollection createCollection(int nodeid, InetAddress ipaddr) {
        SnmpCollection coll = null;
        try {
            coll = new SnmpCollection(this, nodeid, this.getSnmpAgentConfig(ipaddr));
        }
        catch (Throwable t) {
            LOG.error("getSnmpCollection: Failed to load snmpcollection parameter from SNMP configuration file", t);
        }
        return coll;
    }

    public SnmpAgentConfig getSnmpAgentConfig(InetAddress ipaddr) {
        return SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
    }

    public boolean saveRouteTable(String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        return pkg.hasSaveRouteTable() ? pkg.getSaveRouteTable() : this.m_linkdConfig.saveRouteTable();
    }

    public boolean saveStpNodeTable(String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        return pkg.hasSaveStpNodeTable() ? pkg.getSaveStpNodeTable() : this.m_linkdConfig.saveStpNodeTable();
    }

    public boolean saveStpInterfaceTable(String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        return pkg.hasSaveStpInterfaceTable() ? pkg.getSaveStpInterfaceTable() : this.m_linkdConfig.saveStpInterfaceTable();
    }

    public boolean forceIpRoutediscoveryOnEthernet(String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        return pkg.hasForceIpRouteDiscoveryOnEthernet() ? pkg.getForceIpRouteDiscoveryOnEthernet() : this.m_linkdConfig.forceIpRouteDiscoveryOnEthernet();
    }

    private void populateSnmpCollection(SnmpCollection coll, Package pkg, String sysoid) {
        coll.setPackageName(pkg.getName());
        String ipRouteClassName = this.m_linkdConfig.getDefaultIpRouteClassName();
        if (this.m_linkdConfig.hasIpRouteClassName(sysoid)) {
            ipRouteClassName = this.m_linkdConfig.getIpRouteClassName(sysoid);
            LOG.debug("populateSnmpCollection: found class to get ipRoute: {}", (Object)ipRouteClassName);
        } else {
            LOG.debug("populateSnmpCollection: Using default class to get ipRoute: {}", (Object)ipRouteClassName);
        }
        long initialSleepTime = this.m_linkdConfig.getInitialSleepTime();
        long snmpPollInterval = pkg.hasSnmp_poll_interval() ? pkg.getSnmp_poll_interval() : this.m_linkdConfig.getSnmpPollInterval();
        boolean useCdpDiscovery = pkg.hasUseCdpDiscovery() ? pkg.getUseCdpDiscovery() : this.m_linkdConfig.useCdpDiscovery();
        boolean useIpRouteDiscovery = pkg.hasUseIpRouteDiscovery() ? pkg.getUseIpRouteDiscovery() : this.m_linkdConfig.useIpRouteDiscovery();
        boolean useLldpDiscovery = pkg.hasUseLldpDiscovery() ? pkg.getUseLldpDiscovery() : this.m_linkdConfig.useLldpDiscovery();
        boolean useOspfDiscovery = pkg.hasUseOspfDiscovery() ? pkg.getUseOspfDiscovery() : this.m_linkdConfig.useOspfDiscovery();
        boolean useIsIsDiscovery = pkg.hasUseIsisDiscovery() ? pkg.getUseIsisDiscovery() : this.m_linkdConfig.useIsIsDiscovery();
        boolean useBridgeDiscovery = pkg.hasUseBridgeDiscovery() ? pkg.getUseBridgeDiscovery() : this.m_linkdConfig.useBridgeDiscovery();
        boolean useWifiDiscovery = pkg.hasUseWifiDiscovery() ? pkg.getUseWifiDiscovery() : this.m_linkdConfig.useWifiDiscovery();
        coll.setIpRouteClass(ipRouteClassName);
        coll.setInitialSleepTime(initialSleepTime);
        coll.setPollInterval(snmpPollInterval);
        coll.collectCdp(useCdpDiscovery);
        coll.collectIpRoute(useIpRouteDiscovery || this.saveRouteTable(pkg.getName()));
        coll.collectLldp(useLldpDiscovery);
        coll.collectOspf(useOspfDiscovery);
        coll.collectIsIs(useIsIsDiscovery);
        coll.collectBridge(useBridgeDiscovery);
        coll.collectStp(useBridgeDiscovery || this.saveStpNodeTable(pkg.getName()) || this.saveStpInterfaceTable(pkg.getName()));
        coll.collectIpNetToMedia(useWifiDiscovery || useBridgeDiscovery);
        coll.collectWifi(useWifiDiscovery && sysoid.startsWith(".1.3.6.1.4.1.14988."));
        if (pkg.hasEnableVlanDiscovery() && pkg.getEnableVlanDiscovery() || !pkg.hasEnableVlanDiscovery() && this.m_linkdConfig.isVlanDiscoveryEnabled() && this.m_linkdConfig.hasClassName(sysoid)) {
            coll.setVlanClass(this.m_linkdConfig.getVlanClassName(sysoid));
            LOG.debug("populateSnmpCollection: found class to get Vlans: {}", (Object)coll.getVlanClass());
        } else {
            LOG.debug("populateSnmpCollection: no class found to get Vlans or VlanDiscoveryDisabled for Package: {}", (Object)pkg.getName());
        }
    }

    protected synchronized void onStart() {
        LOG.debug("start: Starting linkd scheduler");
        this.m_scheduler.start();
    }

    protected synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_scheduler = null;
    }

    protected synchronized void onPause() {
        this.m_scheduler.pause();
    }

    protected synchronized void onResume() {
        this.m_scheduler.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LinkableNode> getLinkableNodesOnPackage(String pkg) {
        ArrayList<LinkableNode> nodes = new ArrayList<LinkableNode>();
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                if (!node.getPackageName().equals(pkg)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public boolean isInterfaceInPackage(InetAddress ipaddr, String pkg) {
        return this.m_linkdConfig.isInterfaceInPackage(ipaddr, this.m_linkdConfig.getPackage(pkg));
    }

    public boolean scheduleNodeCollection(int nodeid) {
        if (this.isScheduled(nodeid)) {
            LOG.debug("scheduleNodeCollection: Found Scheduled Linkable node {}. Skipping ", (Object)nodeid);
            return false;
        }
        this.m_linkdConfig.update();
        LOG.debug("scheduleNodeCollection: Loading node {} from database", (Object)nodeid);
        LinkableSnmpNode node = this.m_queryMgr.getSnmpNode(nodeid);
        if (node == null) {
            LOG.debug("scheduleNodeCollection: Failed to get linkable node from database with nodeid {}. Exiting", (Object)nodeid);
            return false;
        }
        this.schedule(node);
        return true;
    }

    public boolean runSingleSnmpCollection(int nodeId) {
        LinkableSnmpNode node = this.m_queryMgr.getSnmpNode(nodeId);
        for (SnmpCollection snmpColl : this.getSnmpCollections(nodeId, node.getSnmpPrimaryIpAddr(), node.getSysoid())) {
            snmpColl.setScheduler(this.m_scheduler);
            snmpColl.run();
        }
        return true;
    }

    public boolean runSingleLinkDiscovery(String packageName) {
        DiscoveryLink link = this.getDiscoveryLink(packageName);
        link.setScheduler(this.m_scheduler);
        link.run();
        return true;
    }

    void wakeUpNodeCollection(int nodeid) {
        if (!this.isScheduled(nodeid)) {
            LOG.warn("wakeUpNodeCollection: node not found during scheduling with ID {}", (Object)nodeid);
            this.scheduleNodeCollection(nodeid);
        } else {
            LinkableSnmpNode node = this.m_queryMgr.getSnmpNode(nodeid);
            List<SnmpCollection> collections = this.getSnmpCollections(nodeid, node.getSnmpPrimaryIpAddr(), node.getSysoid());
            LOG.debug("wakeUpNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to wake them up", (Object)collections.size());
            for (SnmpCollection collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("wakeUpNodeCollection: found null ReadyRunnable for nodeid {}", (Object)nodeid);
                    continue;
                }
                rr.wakeUp();
            }
        }
    }

    void deleteNode(int nodeid) {
        LOG.debug("deleteNode: deleting LinkableNode for node {}", (Object)nodeid);
        this.m_queryMgr.update(nodeid, OnmsArpInterface.StatusType.DELETED);
        LinkableSnmpNode node = this.removeNode(nodeid);
        if (node == null) {
            LOG.warn("deleteNode: node not found: {}", (Object)nodeid);
        } else {
            List<SnmpCollection> collections = this.getSnmpCollections(nodeid, node.getSnmpPrimaryIpAddr(), node.getSysoid());
            LOG.debug("deleteNode: fetched SnmpCollections from scratch, iterating over {} objects to wake them up", (Object)collections.size());
            for (SnmpCollection collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("deleteNode: found null ReadyRunnable");
                    return;
                }
                rr.unschedule();
            }
        }
        this.m_linkdConfig.update();
    }

    void deleteInterface(int nodeid, String ipAddr, int ifIndex) {
        LOG.debug("deleteInterface: marking table entries as deleted for node {} with IP address {} and ifIndex {}", new Object[]{nodeid, ipAddr, ifIndex > -1 ? "" + ifIndex : "N/A"});
        this.m_queryMgr.updateForInterface(nodeid, ipAddr, ifIndex, OnmsArpInterface.StatusType.DELETED);
        this.m_linkdConfig.update();
    }

    void suspendNodeCollection(int nodeid) {
        LOG.debug("suspendNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        this.m_queryMgr.update(nodeid, OnmsArpInterface.StatusType.INACTIVE);
        if (!this.isScheduled(nodeid)) {
            LOG.warn("suspendNodeCollection: found null ReadyRunnable");
        } else {
            LinkableSnmpNode node = this.m_queryMgr.getSnmpNode(nodeid);
            List<SnmpCollection> collections = this.getSnmpCollections(nodeid, node.getSnmpPrimaryIpAddr(), node.getSysoid());
            LOG.debug("suspendNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to suspend them down", (Object)collections.size());
            for (SnmpCollection collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("suspendNodeCollection: suspend: node not found: {}", (Object)nodeid);
                    return;
                }
                rr.suspend();
            }
        }
    }

    private ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        LOG.debug("getReadyRunnable: get ReadyRunnable from scheduler: {}", (Object)runnable.getInfo());
        return this.m_scheduler.getReadyRunnable(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateNodeSnmpCollection(SnmpCollection snmpcoll) {
        LinkableSnmpNode snmpNode;
        LOG.debug("Updating SNMP collection for {}", (Object)InetAddressUtils.str((InetAddress)snmpcoll.getTarget()));
        LinkableNode node = this.removeNode(snmpcoll.getPackageName(), snmpcoll.getTarget());
        if (node == null) {
            LOG.error("No linkable node found for SNMP collection: {}!", (Object)snmpcoll.getInfo());
        }
        if ((snmpNode = this.m_queryMgr.getSnmpNode(node.getNodeId())) == null) {
            LOG.info("No node found in database for SNMP collection: {} unscheduling!", (Object)snmpcoll.getInfo());
            return;
        }
        node = new LinkableNode(snmpNode, snmpcoll.getPackageName());
        if ((node = this.m_queryMgr.storeSnmpCollection(node, snmpcoll)) != null) {
            List<LinkableNode> list = this.m_nodes;
            synchronized (list) {
                this.m_nodes.add(node);
            }
        }
        snmpcoll.schedule();
    }

    void updateDiscoveryLinkCollection(DiscoveryLink discover) {
        this.m_queryMgr.storeDiscoveryLink(discover);
        discover.schedule();
    }

    void sendNewSuspectEvent(InetAddress ipaddress, InetAddress ipowner, String pkgName) {
        if (ipaddress == null) {
            LOG.info("sendNewSuspectEvent: nothing to send,  IP addressis null");
            return;
        }
        if (this.m_newSuspectEventsIpAddr.contains(ipaddress)) {
            LOG.info("sendNewSuspectEvent: nothing to send, suspect event previously sent for IP address: {}", (Object)InetAddressUtils.str((InetAddress)ipaddress));
            return;
        }
        if (!this.isInterfaceInPackage(ipaddress, pkgName)) {
            LOG.info("sendNewSuspectEvent: nothing to send for IP address: {}, not in package: {}", (Object)InetAddressUtils.str((InetAddress)ipaddress), (Object)pkgName);
            return;
        }
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        boolean autodiscovery = false;
        autodiscovery = pkg.hasAutoDiscovery() ? pkg.getAutoDiscovery() : this.m_linkdConfig.isAutoDiscoveryEnabled();
        if (autodiscovery) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", LOG_PREFIX);
            bldr.setHost(InetAddressUtils.str((InetAddress)ipowner));
            bldr.setInterface(ipaddress);
            this.m_eventForwarder.sendNow(bldr.getEvent());
            this.m_newSuspectEventsIpAddr.add(ipaddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isScheduled(int nodeid) {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                if (node.getNodeId() != nodeid) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkableSnmpNode removeNode(int nodeid) {
        LinkableSnmpNode snmpnode = null;
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            Iterator<LinkableNode> ite = this.m_nodes.iterator();
            while (ite.hasNext()) {
                LinkableNode curNode = ite.next();
                if (curNode.getNodeId() != nodeid) continue;
                snmpnode = curNode.getLinkableSnmpNode();
                ite.remove();
            }
            return snmpnode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkableNode removeNode(String packageName, InetAddress ipaddr) {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            Iterator<LinkableNode> ite = this.m_nodes.iterator();
            while (ite.hasNext()) {
                LinkableNode curNode = ite.next();
                if (!curNode.getSnmpPrimaryIpAddr().equals(ipaddr) || !curNode.getPackageName().equals(packageName)) continue;
                ite.remove();
                return curNode;
            }
        }
        return null;
    }

    public QueryManager getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(QueryManager queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public LinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(LinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtInterface(String packageName, AtInterface atinterface) {
        LOG.debug("addAtInterface: adding at interface {}/{}", (Object)atinterface.getIpAddress().getHostAddress(), (Object)atinterface.getMacAddress());
        String macAddress = atinterface.getMacAddress();
        InetAddress ipAddress = atinterface.getIpAddress();
        if (!this.isInterfaceInPackage(ipAddress, packageName)) {
            LOG.debug("addAtInterface: ip {} not in package {}. Skipping", (Object)atinterface.getIpAddress().getHostAddress(), (Object)packageName);
            return;
        }
        Map<String, Map<String, List<AtInterface>>> map = this.m_macToAtinterface;
        synchronized (map) {
            List<Object> atis;
            if (!this.m_macToAtinterface.containsKey(packageName)) {
                LOG.debug("addAtInterface: creating map for package {}.", (Object)packageName);
                this.m_macToAtinterface.put(packageName, new HashMap());
            }
            if ((atis = this.m_macToAtinterface.get(packageName).containsKey(macAddress) ? this.m_macToAtinterface.get(packageName).get(macAddress) : new ArrayList()).contains(atinterface)) {
                LOG.debug("addAtInterface: Interface/package {}/{} found not adding.", (Object)atinterface.getIpAddress().getHostAddress(), (Object)packageName);
            } else {
                LOG.debug("addAtInterface: add ip/mac/ifindex {}/{}/{} on package {}.", new Object[]{atinterface.getIpAddress().getHostAddress(), atinterface.getMacAddress(), atinterface.getIfIndex(), packageName});
                atis.add(atinterface);
                this.m_macToAtinterface.get(packageName).put(macAddress, atis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMacAddressesOnPackage(String packageName) {
        Map<String, Map<String, List<AtInterface>>> map = this.m_macToAtinterface;
        synchronized (map) {
            Map<String, List<AtInterface>> interfaceMaps = this.m_macToAtinterface.get(packageName);
            if (interfaceMaps != null) {
                return Collections.unmodifiableSet(interfaceMaps.keySet());
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AtInterface> getAtInterfaces(String packageName, String macAddress) {
        Map<String, Map<String, List<AtInterface>>> map = this.m_macToAtinterface;
        synchronized (map) {
            List<AtInterface> interfaces;
            Map<String, List<AtInterface>> interfaceMaps = this.m_macToAtinterface.get(packageName);
            if (interfaceMaps != null && (interfaces = interfaceMaps.get(macAddress)) != null) {
                return Collections.unmodifiableList(interfaces);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPackageSavedData(String packageName) {
        Map<String, Map<String, List<AtInterface>>> map = this.m_macToAtinterface;
        synchronized (map) {
            Map<String, List<AtInterface>> interfaces = this.m_macToAtinterface.get(packageName);
            if (interfaces != null) {
                interfaces.clear();
            }
        }
    }

    public String getSource() {
        return LOG_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActivePackages() {
        HashSet<String> packages = new HashSet<String>();
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                packages.add(node.getPackageName());
            }
        }
        return packages;
    }
}

