/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.dao.util.AutoAction;
import org.opennms.netmgt.dao.util.Correlation;
import org.opennms.netmgt.dao.util.Forward;
import org.opennms.netmgt.dao.util.OperatorAction;
import org.opennms.netmgt.dao.util.SnmpInfo;
import org.opennms.netmgt.eventd.processor.AbstractJdbcPersister;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.Constants;
import org.opennms.netmgt.model.events.EventProcessor;
import org.opennms.netmgt.model.events.EventProcessorException;
import org.opennms.netmgt.model.events.Parameter;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Snmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public final class JdbcEventWriter
extends AbstractJdbcPersister
implements EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcEventWriter.class);

    public void process(Header eventHeader, Event event) throws EventProcessorException {
        Connection connection;
        if (!this.checkEventSanityAndDoWeProcess(event, "JdbcEventWriter")) {
            return;
        }
        LOG.debug("JdbcEventWriter: processing {} nodeid: {} ipaddr: {} serviceid: {} time: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService(), event.getTime()});
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new EventProcessorException((Throwable)e);
        }
        try {
            connection.setAutoCommit(false);
            try {
                this.insertEvent(eventHeader, event, connection);
                connection.commit();
            }
            catch (SQLException e) {
                LOG.warn("Error inserting event into the datastore.", (Throwable)e);
                try {
                    connection.rollback();
                }
                catch (Throwable e2) {
                    LOG.warn("Rollback of transaction failed.", e2);
                }
                throw e;
            }
            catch (DataAccessException e) {
                LOG.warn("Error inserting event into the datastore.", (Throwable)e);
                try {
                    connection.rollback();
                }
                catch (Throwable e2) {
                    LOG.warn("Rollback of transaction failed.", e2);
                }
                throw e;
            }
        }
        catch (DataAccessException e) {
            throw new EventProcessorException((Throwable)e);
        }
        catch (SQLException e) {
            throw new EventProcessorException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOG.warn("SQLException while closing database connection.", (Throwable)e);
            }
        }
        LOG.debug("EventWriter finished for : {}", (Object)event.getUei());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEvent(Header eventHeader, Event event, Connection connection) throws SQLException {
        int eventID = this.getNextId();
        LOG.debug("DBID: {}", (Object)eventID);
        Event event2 = event;
        synchronized (event2) {
            event.setDbid(Integer.valueOf(eventID));
        }
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement insStmt = connection.prepareStatement("INSERT into events (eventID, eventUei, nodeID, eventTime, eventHost, ipAddr, eventDpName, eventSnmpHost, serviceID, eventSnmp, eventParms, eventCreateTime, eventDescr, eventLoggroup, eventLogmsg, eventLog, eventDisplay, eventSeverity, eventPathOutage, eventCorrelation, eventSuppressedCount, eventOperInstruct, eventAutoAction, eventOperAction, eventOperActionMenuText, eventNotification, eventTticket, eventTticketState, eventForward, eventMouseOverText, eventAckUser, eventAckTime, eventSource,ifIndex) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            d.watch((Object)insStmt);
            insStmt.setInt(1, eventID);
            insStmt.setString(2, Constants.format((String)event.getUei(), (int)256));
            Long nodeid = event.getNodeid();
            this.set(insStmt, 3, event.hasNodeid() ? nodeid.intValue() : -1);
            insStmt.setTimestamp(4, this.getEventTime(event));
            String hostname = this.getEventHost(event);
            this.set(insStmt, 5, Constants.format((String)hostname, (int)256));
            this.set(insStmt, 6, Constants.format((String)event.getInterface(), (int)50));
            String dpName = "localhost";
            if (eventHeader != null && eventHeader.getDpName() != null) {
                dpName = Constants.format((String)eventHeader.getDpName(), (int)12);
            } else if (event.getDistPoller() != null) {
                dpName = Constants.format((String)event.getDistPoller(), (int)12);
            }
            insStmt.setString(7, dpName);
            this.set(insStmt, 8, Constants.format((String)event.getSnmphost(), (int)256));
            this.set(insStmt, 9, this.getEventServiceId(event));
            if (event.getSnmp() != null) {
                insStmt.setString(10, SnmpInfo.format((Snmp)event.getSnmp(), (int)256));
            } else {
                insStmt.setNull(10, 12);
            }
            String parametersString = Parameter.format((Event)event);
            this.set(insStmt, 11, Constants.format((String)parametersString, (int)0));
            Timestamp eventCreateTime = new Timestamp(System.currentTimeMillis());
            insStmt.setTimestamp(12, eventCreateTime);
            this.set(insStmt, 13, Constants.format((String)event.getDescr(), (int)0));
            this.set(insStmt, 14, event.getLoggroupCount() > 0 ? Constants.format((String[])event.getLoggroup(), (int)32) : null);
            if (event.getLogmsg() != null) {
                this.set(insStmt, 15, Constants.format((String)event.getLogmsg().getContent(), (int)0));
                String logdest = event.getLogmsg().getDest();
                if (logdest.equals("logndisplay")) {
                    this.set(insStmt, 16, 'Y');
                    this.set(insStmt, 17, 'Y');
                } else if (logdest.equals("logonly")) {
                    this.set(insStmt, 16, 'Y');
                    this.set(insStmt, 17, 'N');
                } else if (logdest.equals("displayonly")) {
                    this.set(insStmt, 16, 'N');
                    this.set(insStmt, 17, 'Y');
                } else if (logdest.equals("suppress")) {
                    this.set(insStmt, 16, 'N');
                    this.set(insStmt, 17, 'N');
                }
            } else {
                insStmt.setNull(15, 12);
                this.set(insStmt, 17, 'Y');
            }
            this.set(insStmt, 18, OnmsSeverity.get((String)event.getSeverity()).getId());
            this.set(insStmt, 19, event.getPathoutage() != null ? Constants.format((String)event.getPathoutage(), (int)1024) : null);
            this.set(insStmt, 20, event.getCorrelation() != null ? Correlation.format((org.opennms.netmgt.xml.event.Correlation)event.getCorrelation(), (int)1024) : null);
            insStmt.setNull(21, 4);
            this.set(insStmt, 22, Constants.format((String)event.getOperinstruct(), (int)0));
            this.set(insStmt, 23, event.getAutoactionCount() > 0 ? AutoAction.format((Autoaction[])event.getAutoaction(), (int)256) : null);
            if (event.getOperactionCount() > 0) {
                ArrayList<Operaction> a = new ArrayList<Operaction>();
                ArrayList<String> b = new ArrayList<String>();
                for (Operaction eoa : event.getOperactionCollection()) {
                    a.add(eoa);
                    b.add(eoa.getMenutext());
                }
                this.set(insStmt, 24, OperatorAction.format(a, (int)256));
                this.set(insStmt, 25, Constants.format(b, (int)64));
            } else {
                insStmt.setNull(24, 12);
                insStmt.setNull(25, 12);
            }
            insStmt.setNull(26, 12);
            if (event.getTticket() != null) {
                this.set(insStmt, 27, Constants.format((String)event.getTticket().getContent(), (int)128));
                this.set(insStmt, 28, event.getTticket().getState().equals("on") ? 1 : 0);
            } else {
                insStmt.setNull(27, 12);
                insStmt.setNull(28, 4);
            }
            this.set(insStmt, 29, event.getForwardCount() > 0 ? Forward.format((org.opennms.netmgt.xml.event.Forward[])event.getForward(), (int)256) : null);
            this.set(insStmt, 30, Constants.format((String)event.getMouseovertext(), (int)64));
            if (event.getAutoacknowledge() != null && event.getAutoacknowledge().getState().equals("on")) {
                this.set(insStmt, 31, Constants.format((String)event.getAutoacknowledge().getContent(), (int)256));
                this.set(insStmt, 32, eventCreateTime);
            } else {
                insStmt.setNull(31, 4);
                insStmt.setNull(32, 93);
            }
            this.set(insStmt, 33, Constants.format((String)event.getSource(), (int)128));
            if (event.hasIfIndex()) {
                this.set(insStmt, 34, event.getIfIndex());
            } else {
                insStmt.setNull(34, 4);
            }
            insStmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
        LOG.debug("SUCCESSFULLY added {} related  data into the EVENTS table.", (Object)event.getUei());
    }

    String getHostName(int nodeId, String hostip) throws SQLException {
        try {
            String hostname = (String)new JdbcTemplate(this.getDataSource()).queryForObject("SELECT ipHostname FROM ipinterface WHERE nodeId = ? AND ipAddr = ?", String.class, new Object[]{nodeId, hostip});
            return hostname != null ? hostname : hostip;
        }
        catch (EmptyResultDataAccessException e) {
            return hostip;
        }
    }

    private int getEventServiceId(Event event) {
        if (event.getService() == null) {
            return -1;
        }
        try {
            return this.getServiceID(event.getService());
        }
        catch (Throwable t) {
            LOG.warn("Error converting service name \"{}\" to an integer identifier, storing -1.", (Object)event.getService(), (Object)t);
            return -1;
        }
    }

    protected String getEventHost(Event event) {
        if (event.getHost() == null) {
            return null;
        }
        if (!event.hasNodeid()) {
            return event.getHost();
        }
        try {
            return this.getHostName(event.getNodeid().intValue(), event.getHost());
        }
        catch (Throwable t) {
            LOG.warn("Error converting host IP \"{}\" to a hostname, storing the IP.", (Object)event.getHost(), (Object)t);
            return event.getHost();
        }
    }
}

