/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.util.AutoAction;
import org.opennms.netmgt.dao.util.Correlation;
import org.opennms.netmgt.dao.util.Forward;
import org.opennms.netmgt.dao.util.OperatorAction;
import org.opennms.netmgt.dao.util.SnmpInfo;
import org.opennms.netmgt.eventd.processor.AbstractJdbcPersister;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.Constants;
import org.opennms.netmgt.model.events.EventProcessor;
import org.opennms.netmgt.model.events.EventProcessorException;
import org.opennms.netmgt.model.events.Parameter;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Snmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public final class HibernateEventWriter
extends AbstractJdbcPersister
implements EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateEventWriter.class);
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;
    @Autowired
    private DistPollerDao distPollerDao;
    @Autowired
    private EventDao eventDao;

    public void process(Header eventHeader, Event event) throws EventProcessorException {
        if (!this.checkEventSanityAndDoWeProcess(event, "HibernateEventWriter")) {
            return;
        }
        LOG.debug("HibernateEventWriter: processing {} nodeid: {} ipaddr: {} serviceid: {} time: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService(), event.getTime()});
        this.insertEvent(eventHeader, event, null);
    }

    private void insertEvent(Header eventHeader, Event event, Connection connection) {
        OnmsDistPoller poll = (OnmsDistPoller)this.distPollerDao.get((Serializable)((Object)event.getDistPoller()));
        OnmsServiceType serve = new OnmsServiceType(event.getService());
        OnmsEvent ovent = new OnmsEvent();
        ovent.setId(event.getDbid());
        ovent.setEventUei(event.getUei());
        ovent.setEventTime((java.util.Date)Date.valueOf(event.getTime()));
        ovent.setEventHost(event.getHost());
        ovent.setEventSource(event.getSource());
        ovent.setIpAddr(event.getInterfaceAddress());
        ovent.setDistPoller(poll);
        ovent.setEventSnmpHost(event.getSnmphost());
        ovent.setServiceType(serve);
        ovent.setEventSnmp(SnmpInfo.format((Snmp)event.getSnmp(), (int)256));
        String parms = Parameter.format((Event)event);
        ovent.setEventParms(parms);
        ovent.setEventCreateTime((java.util.Date)Date.valueOf(event.getCreationTime()));
        ovent.setEventDescr(event.getDescr());
        ovent.setEventLogGroup(Integer.toString(event.getLoggroupCount()));
        ovent.setEventSeverity(Integer.valueOf(event.getSeverity()));
        ovent.setEventPathOutage(event.getPathoutage());
        ovent.setEventCorrelation(event.getCorrelation() != null ? Correlation.format((org.opennms.netmgt.xml.event.Correlation)event.getCorrelation(), (int)1024) : null);
        ovent.setEventSuppressedCount(null);
        ovent.setEventOperInstruct(event.getOperinstruct());
        ovent.setEventAutoAction(event.getAutoactionCount() > 0 ? AutoAction.format((Autoaction[])event.getAutoaction(), (int)256) : null);
        if (event.getOperactionCount() > 0) {
            ArrayList<Operaction> a = new ArrayList<Operaction>();
            ArrayList<String> b = new ArrayList<String>();
            for (Operaction eoa : event.getOperactionCollection()) {
                a.add(eoa);
                b.add(eoa.getMenutext());
            }
            ovent.setEventOperAction(OperatorAction.format(a, (int)256));
            ovent.setEventOperActionMenuText(Constants.format(b, (int)256));
        } else {
            ovent.setEventOperAction(null);
            ovent.setEventOperActionMenuText(null);
        }
        ovent.setEventNotification(null);
        if (event.getTticket() != null) {
            ovent.setEventTTicket(event.getTticket().getContent());
            ovent.setEventTTicketState(Integer.valueOf(event.getTticket().getState()));
        } else {
            ovent.setEventTTicket(null);
            ovent.setEventTTicketState(null);
        }
        ovent.setEventForward(Forward.format((org.opennms.netmgt.xml.event.Forward[])event.getForward(), (int)256));
        ovent.setEventMouseOverText(event.getMouseovertext());
        if (event.getLogmsg() != null) {
            ovent.setEventLogMsg(event.getLogmsg().getContent());
            String logdest = event.getLogmsg().getDest();
            if (logdest.equals("logndisplay")) {
                ovent.setEventLog("Y");
                ovent.setEventDisplay("Y");
            } else if (logdest.equals("logonly")) {
                ovent.setEventLog("Y");
                ovent.setEventDisplay("N");
            } else if (logdest.equals("displayonly")) {
                ovent.setEventLog("N");
                ovent.setEventDisplay("Y");
            } else if (logdest.equals("suppress")) {
                ovent.setEventLog("N");
                ovent.setEventDisplay("N");
            }
        } else {
            ovent.setEventLogMsg(null);
            ovent.setEventLog("Y");
            ovent.setEventDisplay("Y");
        }
        if (event.getAutoacknowledge() != null && event.getAutoacknowledge().getState().equals("on")) {
            ovent.setEventAckUser(event.getAutoacknowledge().getContent());
            ovent.setEventAckTime((java.util.Date)Date.valueOf(event.getCreationTime()));
        } else {
            ovent.setEventAckUser(null);
            ovent.setEventAckTime(null);
        }
        this.eventDao.update((Object)ovent);
    }

    String getHostName(int nodeId, String hostip) throws SQLException {
        OnmsIpInterface ints = this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(nodeId), hostip);
        String hostname = ints.getIpHostName();
        return hostname != null ? hostname : hostip;
    }

    private int getEventServiceId(Event event) {
        if (event.getService() == null) {
            return -1;
        }
        return Integer.valueOf(event.getService());
    }

    protected String getEventHost(Event event) {
        if (event.getHost() == null) {
            return null;
        }
        if (!event.hasNodeid()) {
            return event.getHost();
        }
        try {
            return this.getHostName(event.getNodeid().intValue(), event.getHost());
        }
        catch (Throwable t) {
            LOG.warn("Error converting host IP \"{}\" to a hostname, storing the IP.", (Object)event.getHost(), (Object)t);
            return event.getHost();
        }
    }
}

