/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.eventd.EventExpander;
import org.opennms.netmgt.model.events.EventProcessor;
import org.opennms.netmgt.model.events.EventProcessorException;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class EventParmRegexFilterProcessor
implements EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventParmRegexFilterProcessor.class);
    private EventConfDao m_eventConfDao;
    private Map<String, Filter> m_filterMap = new HashMap<String, Filter>();

    public void process(Header eventHeader, org.opennms.netmgt.xml.event.Event event) throws EventProcessorException {
        Event econf = EventExpander.lookup(this.m_eventConfDao, event);
        if (econf.getFilters() != null) {
            for (Filter fConf : econf.getFilters().getFilterCollection()) {
                if (this.m_filterMap.containsKey(fConf.getEventparm() + "|" + event.getUei())) continue;
                this.m_filterMap.put(fConf.getEventparm() + "|" + event.getUei(), fConf);
                LOG.debug("adding [{}|{}] to filter map", (Object)fConf.getEventparm(), (Object)event.getUei());
            }
            for (Parm parm : event.getParmCollection()) {
                if (parm.getParmName() == null || parm.getValue().getContent() == null || !this.m_filterMap.containsKey(parm.getParmName() + "|" + event.getUei())) continue;
                Filter f = this.m_filterMap.get(parm.getParmName() + "|" + event.getUei());
                LOG.debug("filtering {} with {}", (Object)parm.getParmName(), (Object)f.getPattern());
                Pattern pattern = Pattern.compile(f.getPattern());
                Matcher matcher = pattern.matcher(parm.getValue().getContent().trim());
                parm.getValue().setContent(matcher.replaceAll(f.getReplacement()));
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_eventConfDao != null ? 1 : 0) != 0, (String)"property eventConfDao must be set");
    }

    public EventConfDao getEventConfDao() {
        return this.m_eventConfDao;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }
}

