/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.net.InetAddress;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.EventUtilJdbcImpl;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventUtil
implements EventUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventUtil.class);
    protected static final String TAG_EVENT_DB_ID = "eventid";
    protected static final String TAG_UEI = "uei";
    protected static final String TAG_SOURCE = "source";
    protected static final String TAG_DESCR = "descr";
    protected static final String TAG_LOGMSG = "logmsg";
    protected static final String TAG_TIME = "time";
    protected static final String TAG_SHORT_TIME = "shorttime";
    protected static final String TAG_DPNAME = "dpname";
    protected static final String TAG_NODEID = "nodeid";
    protected static final String TAG_NODELABEL = "nodelabel";
    protected static final String TAG_HOST = "host";
    protected static final String TAG_INTERFACE = "interface";
    protected static final String TAG_IFINDEX = "ifindex";
    protected static final String TAG_INTERFACE_RESOLVE = "interfaceresolve";
    protected static final String TAG_IFALIAS = "ifalias";
    protected static final String TAG_SNMP_ID = "id";
    protected static final String TAG_SNMP = "snmp";
    protected static final String TAG_SNMP_IDTEXT = "idtext";
    protected static final String TAG_SNMP_VERSION = "version";
    protected static final String TAG_SNMP_SPECIFIC = "specific";
    protected static final String TAG_SNMP_GENERIC = "generic";
    protected static final String TAG_SNMP_COMMUNITY = "community";
    protected static final String TAG_SNMPHOST = "snmphost";
    protected static final String TAG_SERVICE = "service";
    protected static final String TAG_SEVERITY = "severity";
    protected static final String TAG_OPERINSTR = "operinstruct";
    protected static final String TAG_MOUSEOVERTEXT = "mouseovertext";
    protected static final Object TAG_TTICKET_ID = "tticketid";
    protected static final String ASSET_BEGIN = "asset[";
    protected static final String ASSET_END_SUFFIX = "]";
    protected static final char PERCENT = '%';
    protected static final String PARMS_NAMES = "parm[names-all]";
    protected static final String PARMS_VALUES = "parm[values-all]";
    protected static final String PARMS_ALL = "parm[all]";
    protected static final String PARM_BEGIN = "parm[";
    protected static final int PARM_BEGIN_LENGTH = 5;
    protected static final String NUM_PARMS_STR = "parm[##]";
    protected static final String PARM_NUM_PREFIX = "parm[#";
    protected static final int PARM_NUM_PREFIX_LENGTH = 6;
    protected static final String PARM_NAME_NUMBERED_PREFIX = "parm[name-#";
    protected static final int PARM_NAME_NUMBERED_PREFIX_LENGTH = 11;
    protected static final String PARM_END_SUFFIX = "]";
    protected static final char NAME_VAL_DELIM = '=';
    protected static final char SPACE_DELIM = ' ';
    protected static final char ATTRIB_DELIM = ',';
    protected static final String TAG_PERCENT_SIGN = "pctsign";
    static final String HARDWARE_BEGIN = "hardware[";
    static final String HARDWARE_END_SUFFIX = "]";

    public static EventUtil getInstance() {
        return new EventUtilJdbcImpl();
    }

    public static String escape(String inStr, char delimchar) {
        char delim = delimchar;
        String delimEscStr = "%" + String.valueOf((int)delim);
        StringBuffer outBuffer = new StringBuffer(inStr);
        int index = 0;
        int delimIndex = inStr.indexOf(delimchar, index);
        while (delimIndex != -1) {
            outBuffer.deleteCharAt(delimIndex);
            outBuffer.insert(delimIndex, delimEscStr);
            index = delimIndex + delimEscStr.length() + 1;
            delimIndex = outBuffer.toString().indexOf(delimchar, index);
        }
        return outBuffer.toString();
    }

    @Override
    public final String getValueOfParm(String parm, Event event) {
        String retParmVal = null;
        String ifString = event.getInterface();
        if (parm.equals(TAG_UEI)) {
            retParmVal = event.getUei();
        }
        if (parm.equals(TAG_EVENT_DB_ID)) {
            retParmVal = event.hasDbid() ? Integer.toString(event.getDbid()) : "eventid-unknown";
        } else if (parm.equals(TAG_SOURCE)) {
            retParmVal = event.getSource();
        } else if (parm.equals(TAG_DPNAME)) {
            retParmVal = event.getDistPoller();
        } else if (parm.equals(TAG_DESCR)) {
            retParmVal = event.getDescr();
        } else if (parm.equals(TAG_LOGMSG)) {
            retParmVal = event.getLogmsg().getContent();
        } else if (parm.equals(TAG_NODEID)) {
            retParmVal = Long.toString(event.getNodeid());
        } else if (parm.equals(TAG_NODELABEL)) {
            retParmVal = Long.toString(event.getNodeid());
            String nodeLabel = null;
            if (event.getNodeid() > 0L) {
                try {
                    nodeLabel = this.getNodeLabel(event.getNodeid());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            retParmVal = nodeLabel != null ? WebSecurityUtils.sanitizeString(nodeLabel) : "Unknown";
        } else if (parm.equals(TAG_TIME)) {
            String eventTime = event.getTime();
            try {
                Date actualDate = EventConstants.parseToDate((String)eventTime);
                DateFormat df = DateFormat.getDateTimeInstance(0, 0);
                retParmVal = df.format(actualDate);
            }
            catch (ParseException e) {
                LOG.error("could not parse event date '{}'", (Object)eventTime, (Object)e);
                retParmVal = eventTime;
            }
        } else if (parm.equals(TAG_SHORT_TIME)) {
            String eventTime = event.getTime();
            try {
                Date actualDate = EventConstants.parseToDate((String)eventTime);
                DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                retParmVal = df.format(actualDate);
            }
            catch (ParseException e) {
                LOG.error("could not parse event date '{}'", (Object)eventTime, (Object)e);
                retParmVal = eventTime;
            }
        } else if (parm.equals(TAG_HOST)) {
            retParmVal = event.getHost();
        } else if (parm.equals(TAG_INTERFACE)) {
            retParmVal = ifString;
        } else if (parm.equals(TAG_IFINDEX)) {
            retParmVal = event.hasIfIndex() ? Integer.toString(event.getIfIndex()) : "N/A";
        } else if (parm.equals(TAG_INTERFACE_RESOLVE)) {
            InetAddress addr = event.getInterfaceAddress();
            if (addr != null) {
                retParmVal = addr.getHostName();
            }
        } else if (parm.equals(TAG_IFALIAS)) {
            String ifAlias = null;
            if (event.getNodeid() > 0L && event.getInterface() != null) {
                try {
                    ifAlias = this.getIfAlias(event.getNodeid(), ifString);
                }
                catch (SQLException e) {
                    LOG.info("ifAlias Unavailable for {}:{}", new Object[]{event.getNodeid(), event.getInterface(), e});
                }
            }
            retParmVal = ifAlias != null ? ifAlias : ifString;
        } else if (parm.equals(TAG_PERCENT_SIGN)) {
            String pctSign;
            retParmVal = pctSign = "%";
        } else if (parm.equals(TAG_SNMPHOST)) {
            retParmVal = event.getSnmphost();
        } else if (parm.equals(TAG_SERVICE)) {
            retParmVal = event.getService();
        } else if (parm.equals(TAG_SNMP)) {
            Snmp info = event.getSnmp();
            if (info == null) {
                retParmVal = null;
            } else {
                StringBuffer snmpStr = new StringBuffer(info.getId());
                if (info.getIdtext() != null) {
                    snmpStr.append(',' + AbstractEventUtil.escape(info.getIdtext().trim(), ','));
                } else {
                    snmpStr.append(",undefined");
                }
                snmpStr.append(',' + info.getVersion());
                if (info.hasSpecific()) {
                    snmpStr.append(',' + Integer.toString(info.getSpecific()));
                } else {
                    snmpStr.append(",undefined");
                }
                if (info.hasGeneric()) {
                    snmpStr.append(',' + Integer.toString(info.getGeneric()));
                } else {
                    snmpStr.append(",undefined");
                }
                if (info.getCommunity() != null) {
                    snmpStr.append(',' + info.getCommunity().trim());
                } else {
                    snmpStr.append(",undefined");
                }
                retParmVal = snmpStr.toString();
            }
        } else if (parm.equals(TAG_SNMP_ID)) {
            Snmp info = event.getSnmp();
            if (info != null) {
                retParmVal = info.getId();
            }
        } else if (parm.equals(TAG_SNMP_IDTEXT)) {
            Snmp info = event.getSnmp();
            if (info != null && info.getIdtext() != null) {
                retParmVal = info.getIdtext();
            }
        } else if (parm.equals(TAG_SNMP_VERSION)) {
            Snmp info = event.getSnmp();
            if (info != null) {
                retParmVal = info.getVersion();
            }
        } else if (parm.equals(TAG_SNMP_SPECIFIC)) {
            Snmp info = event.getSnmp();
            if (info != null && info.hasSpecific()) {
                retParmVal = Integer.toString(info.getSpecific());
            }
        } else if (parm.equals(TAG_SNMP_GENERIC)) {
            Snmp info = event.getSnmp();
            if (info != null && info.hasGeneric()) {
                retParmVal = Integer.toString(info.getGeneric());
            }
        } else if (parm.equals(TAG_SNMP_COMMUNITY)) {
            Snmp info = event.getSnmp();
            if (info != null && info.getCommunity() != null) {
                retParmVal = info.getCommunity();
            }
        } else if (parm.equals(TAG_SEVERITY)) {
            retParmVal = event.getSeverity();
        } else if (parm.equals(TAG_OPERINSTR)) {
            retParmVal = event.getOperinstruct();
        } else if (parm.equals(TAG_MOUSEOVERTEXT)) {
            retParmVal = event.getMouseovertext();
        } else if (parm.equals(TAG_TTICKET_ID)) {
            Tticket ticket = event.getTticket();
            retParmVal = ticket == null ? "" : ticket.getContent();
        } else if (parm.equals(PARMS_VALUES)) {
            retParmVal = AbstractEventUtil.getAllParmValues(event);
        } else if (parm.equals(PARMS_NAMES)) {
            retParmVal = AbstractEventUtil.getAllParmNames(event);
        } else if (parm.equals(PARMS_ALL)) {
            retParmVal = AbstractEventUtil.getAllParamValues(event);
        } else if (parm.equals(NUM_PARMS_STR)) {
            retParmVal = String.valueOf(event.getParmCollection().size());
        } else if (parm.startsWith(PARM_NUM_PREFIX)) {
            retParmVal = AbstractEventUtil.getNumParmValue(parm, event);
        } else if (parm.startsWith(PARM_NAME_NUMBERED_PREFIX)) {
            retParmVal = AbstractEventUtil.getNumParmName(parm, event);
        } else if (parm.startsWith(PARM_BEGIN)) {
            if (parm.length() > 5) {
                retParmVal = this.getNamedParmValue(parm, event);
            }
        } else if (parm.startsWith(ASSET_BEGIN)) {
            retParmVal = null;
            String assetFieldValue = null;
            if (event.getNodeid() > 0L) {
                assetFieldValue = this.getAssetFieldValue(parm, event.getNodeid());
            }
            retParmVal = assetFieldValue != null ? assetFieldValue : "Unknown";
        } else if (parm.startsWith(HARDWARE_BEGIN)) {
            retParmVal = null;
            String hwFieldValue = null;
            if (event.getNodeid() > 0L) {
                hwFieldValue = this.getHardwareFieldValue(parm, event.getNodeid());
            }
            retParmVal = hwFieldValue != null ? hwFieldValue : "Unknown";
        }
        return retParmVal == null ? null : retParmVal.trim();
    }

    protected static String getAllParmValues(Event event) {
        String retParmVal = null;
        if (event.getParmCollection().size() < 1) {
            retParmVal = null;
        } else {
            StringBuffer ret = new StringBuffer();
            for (Parm evParm : event.getParmCollection()) {
                String parmValueStr;
                Value parmValue = evParm.getValue();
                if (parmValue == null || (parmValueStr = EventConstants.getValueAsString((Value)parmValue)) == null) continue;
                if (ret.length() == 0) {
                    ret.append(parmValueStr);
                    continue;
                }
                ret.append(' ' + parmValueStr);
            }
            retParmVal = ret.toString();
        }
        return retParmVal;
    }

    protected static String getAllParmNames(Event event) {
        if (event.getParmCollection().size() <= 0) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (Parm evParm : event.getParmCollection()) {
            String parmName = evParm.getParmName();
            if (parmName == null) continue;
            if (ret.length() == 0) {
                ret.append(parmName.trim());
                continue;
            }
            ret.append(' ' + parmName.trim());
        }
        return ret.toString();
    }

    protected static String getAllParamValues(Event event) {
        if (event.getParmCollection().size() < 1) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (Parm evParm : event.getParmCollection()) {
            Value parmValue;
            String parmName = evParm.getParmName();
            if (parmName == null || (parmValue = evParm.getValue()) == null) continue;
            String parmValueStr = EventConstants.getValueAsString((Value)parmValue);
            if (ret.length() != 0) {
                ret.append(' ');
            }
            ret.append(parmName.trim()).append('=').append("\"").append(parmValueStr).append("\"");
        }
        return ret.toString().intern();
    }

    protected static String getNumParmName(String parm, Event event) {
        String retParmVal = null;
        List parms = event.getParmCollection();
        int end = parm.lastIndexOf("]");
        if (end != -1 && parms != null && parms.size() > 0) {
            String parmSpec = parm.substring(11, end);
            String eparmnum = null;
            String eparmsep = null;
            String eparmoffset = null;
            String eparmrangesep = null;
            String eparmrangelen = null;
            if (parmSpec.matches("^\\d+$")) {
                eparmnum = parmSpec;
            } else {
                Matcher m = Pattern.compile("^(\\d+)([^0-9+-]+)([+-]?\\d+)((:)([+-]?\\d+)?)?$").matcher(parmSpec);
                if (m.matches()) {
                    eparmnum = m.group(1);
                    eparmsep = m.group(2);
                    eparmoffset = m.group(3);
                    eparmrangesep = m.group(5);
                    eparmrangelen = m.group(6);
                }
            }
            int parmNum = -1;
            try {
                parmNum = Integer.parseInt(eparmnum);
            }
            catch (NumberFormatException nfe) {
                parmNum = -1;
                retParmVal = null;
            }
            if (parmNum > 0 && parmNum <= parms.size()) {
                Parm evParm = (Parm)parms.get(parmNum - 1);
                String eparmname = evParm.getParmName();
                if (eparmsep != null && eparmoffset != null) {
                    int parmOffset = Integer.parseInt(eparmoffset);
                    boolean doRange = ":".equals(eparmrangesep);
                    int parmRangeLen = eparmrangelen == null ? 0 : Integer.parseInt(eparmrangelen);
                    retParmVal = AbstractEventUtil.splitAndExtract(eparmname, eparmsep, parmOffset, doRange, parmRangeLen);
                } else {
                    retParmVal = eparmname;
                }
            } else {
                retParmVal = null;
            }
        }
        return retParmVal;
    }

    public static String splitAndExtract(String src, String sep, int offset, boolean doRange, int rangeLen) {
        String sepLiteral = Pattern.quote(sep);
        if (src.startsWith(sep)) {
            src = src.replaceFirst(sepLiteral, "");
        }
        String[] components = src.split(sepLiteral);
        if (Math.abs(offset) > components.length || offset == 0) {
            return null;
        }
        int startIndex = offset < 0 ? components.length + offset : offset - 1;
        int endIndex = startIndex;
        if (!doRange) {
            return components[startIndex];
        }
        endIndex = rangeLen == 0 ? components.length - 1 : (rangeLen < 0 ? startIndex + 1 + rangeLen : startIndex - 1 + rangeLen);
        StringBuffer retVal = new StringBuffer();
        for (int i = startIndex; i <= endIndex; ++i) {
            retVal.append(components[i]);
            if (i >= endIndex) continue;
            retVal.append(sep);
        }
        return retVal.toString();
    }

    protected static String getNumParmValue(String parm, Event event) {
        String retParmVal = null;
        List parms = event.getParmCollection();
        int end = parm.lastIndexOf("]");
        if (end != -1 && parms != null && parms.size() > 0) {
            String eparmname = parm.substring(6, end);
            int parmNum = -1;
            try {
                parmNum = Integer.parseInt(eparmname);
            }
            catch (NumberFormatException nfe) {
                parmNum = -1;
                retParmVal = null;
            }
            if (parmNum > 0 && parmNum <= parms.size()) {
                Parm evParm = (Parm)parms.get(parmNum - 1);
                Value eparmval = evParm.getValue();
                if (eparmval != null) {
                    retParmVal = EventConstants.getValueAsString((Value)eparmval);
                }
            } else {
                retParmVal = null;
            }
        }
        return retParmVal;
    }

    @Override
    public final String getNamedParmValue(String parm, Event event) {
        String retParmVal = null;
        int end = parm.indexOf("]", 5);
        if (end != -1) {
            String eparmname = parm.substring(5, end);
            for (Parm evParm : event.getParmCollection()) {
                Value eparmval;
                String parmName = evParm.getParmName();
                if (parmName == null || !parmName.trim().equals(eparmname) || (eparmval = evParm.getValue()) == null) continue;
                retParmVal = EventConstants.getValueAsString((Value)eparmval);
                break;
            }
        }
        return retParmVal;
    }

    @Override
    public final void expandMapValues(Map<String, String> map, Event event) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String expandedValue;
            String key = entry.getKey();
            String mapValue = entry.getValue();
            if (mapValue == null || (expandedValue = this.expandParms(map.get(key), event)) == null) continue;
            map.put(key, expandedValue);
        }
    }

    @Override
    public final String expandParms(String inp, Event event) {
        return this.expandParms(inp, event, null);
    }

    @Override
    public final String expandParms(String inp, Event event, Map<String, Map<String, String>> decode) {
        String retStr;
        int index1 = -1;
        int index2 = -1;
        if (inp == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        String tempInp = inp;
        int inpLen = inp.length();
        while (tempInp != null && (index1 = tempInp.indexOf(37)) != -1) {
            ret.append(tempInp.substring(0, index1));
            tempInp = tempInp.substring(index1);
            index2 = tempInp.indexOf(37, 1);
            if (index2 == -1) break;
            String parm = tempInp.substring(1, index2);
            if (parm.matches(".*\\s.*")) {
                ret.append('%');
                tempInp = tempInp.substring(1);
                continue;
            }
            String parmVal = this.getValueOfParm(parm, event);
            if (parmVal != null) {
                if (decode != null && decode.containsKey(parm) && decode.get(parm).containsKey(parmVal)) {
                    ret.append(decode.get(parm).get(parmVal));
                    ret.append("(");
                    ret.append(parmVal);
                    ret.append(")");
                } else {
                    ret.append(parmVal);
                }
            }
            if (index2 < inpLen - 1) {
                tempInp = tempInp.substring(index2 + 1);
                continue;
            }
            tempInp = null;
        }
        if ((index1 == -1 || index2 == -1) && tempInp != null) {
            ret.append(tempInp);
        }
        if ((retStr = ret.toString()) != null && !retStr.equals(inp)) {
            return retStr;
        }
        return null;
    }

    @Override
    public abstract String getNodeLabel(long var1) throws SQLException;

    @Override
    public abstract String getIfAlias(long var1, String var3) throws SQLException;

    @Override
    public abstract String getAssetFieldValue(String var1, long var2);
}

