/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.NumericCollectionAttributeType;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.config.MibObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericAttributeType
extends SnmpAttributeType
implements NumericCollectionAttributeType {
    private static final Logger LOG = LoggerFactory.getLogger(NumericAttributeType.class);
    static final String DST_COUNTER = "COUNTER";

    public NumericAttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        super(resourceType, collectionName, mibObj, groupType);
        LOG.debug("buildDataSourceList: ds_name: {} ds_oid: {}.{}", new Object[]{this.getName(), this.getOid(), this.getInstance()});
        String alias = this.getAlias();
        if (alias.length() > 19) {
            this.logNameTooLong();
        }
    }

    public String getMaxval() {
        return this.m_mibObj.getMaxval();
    }

    public String getMinval() {
        return this.m_mibObj.getMinval();
    }

    @Override
    public void storeAttribute(CollectionAttribute attribute, Persister persister) {
        persister.persistNumericAttribute(attribute);
    }

    void logNameTooLong() {
        LOG.warn("buildDataSourceList: Mib object name/alias '{}' exceeds 19 char maximum for RRD data source names, truncating.", (Object)this.getAlias());
    }
}

