/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenManageChassisPlugin
extends SnmpPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OpenManageChassisPlugin.class);
    private static final String PROTOCOL_NAME = "Dell_OpenManageChassis";
    private static final String CHASSIS_STATUS_OID = ".1.3.6.1.4.1.674.10892.1.200.10.1.4.1";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress ipaddr, Map<String, Object> qualifiers) {
        try {
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
            if (agentConfig == null) {
                throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
            }
            if (qualifiers != null) {
                SnmpObjId chassisStatusSnmpObject;
                SnmpValue chassisStatus;
                if (qualifiers.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (qualifiers.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (qualifiers.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (qualifiers.get("force version") != null) {
                    String version = (String)qualifiers.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                if ((chassisStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)(chassisStatusSnmpObject = SnmpObjId.get((String)CHASSIS_STATUS_OID)))) == null) {
                    LOG.warn("Cannot receive chassis status");
                    return false;
                }
                LOG.debug("poll: OpenManageChassis: {}", (Object)chassisStatus);
                if (Integer.parseInt(chassisStatus.toString()) >= DELL_STATUS.OTHER.value() && Integer.parseInt(chassisStatus.toString()) <= DELL_STATUS.NON_RECOVERABLE.value()) {
                    LOG.debug("poll: OpenManageChassis: is valid, protocol supported.");
                    return true;
                }
            }
        }
        catch (NullPointerException e) {
            LOG.warn("SNMP not available!");
        }
        catch (NumberFormatException e) {
            LOG.warn("Number operator used on a non-number {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid SNMP Criteria: {}", (Object)e.getMessage());
        }
        catch (Throwable t) {
            LOG.warn("Unexpected exception during SNMP poll of interface {}", (Object)ipaddr, (Object)t);
        }
        return false;
    }

    private static enum DELL_STATUS {
        OTHER(1),
        UNKNOWN(2),
        OK(3),
        NON_CRITICAL(4),
        CRITICAL(5),
        NON_RECOVERABLE(6);

        private final int state;

        private DELL_STATUS(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

