/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MSExchangePlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(MSExchangePlugin.class);
    private static final String PROTOCOL_NAME = "MSExchange";
    private static final String BANNER_STRING = "Microsoft Exchange";
    private static final int DEFAULT_POP3_PORT = 110;
    private static final int DEFAULT_IMAP_PORT = 143;
    private static final int DEFAULT_MAPI_PORT = 593;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int POP3_INDEX = 0;
    private static final int IMAP_INDEX = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                int rc;
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                LOG.debug("MSExchangePlugin: connected to host: {} on port: {}", (Object)host, (Object)port);
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = lineRdr.readLine();
                if (banner == null || (rc = banner.indexOf(BANNER_STRING)) <= -1) continue;
                isAServer = true;
                continue;
            }
            catch (ConnectException e) {
                LOG.debug("isServer: Connection refused to {}: {}", (Object)InetAddressUtils.str((InetAddress)host), (Object)port);
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                LOG.info("isServer: Failed to connect to host {}, no route to host", (Object)InetAddressUtils.str((InetAddress)host), (Object)e);
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                LOG.debug("MSExchangePlugin: did not connect to host within timeout: {} attempt: {}", (Object)timeout, (Object)attempts);
                continue;
            }
            catch (IOException e) {
                LOG.info("isServer: Unexpected I/O exception occured with host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)host), port, e});
                continue;
            }
            catch (Throwable t) {
                LOG.error("isServer: Undeclared throwable caught communicating with host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)host), port, t});
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    private boolean[] isServer(InetAddress host, int[] ports, int retries, int timeout) {
        boolean isExPop3 = false;
        boolean isExImap = false;
        boolean isExMapi = false;
        if (ports[0] > 0) {
            isExPop3 = this.isServer(host, ports[0], retries, timeout);
        }
        if (ports[1] > 0) {
            isExImap = this.isServer(host, ports[1], retries, timeout);
        }
        return new boolean[]{isExPop3, isExImap, isExMapi};
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        boolean[] result = this.isServer(address, new int[]{110, 143, 593}, 0, 5000);
        return result[0] || result[1] || result[2];
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int pop3port = 110;
        int imapport = 143;
        int mapiport = 593;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            pop3port = ParameterMap.getKeyedInteger(qualifiers, (String)"pop3 port", (int)110);
            imapport = ParameterMap.getKeyedInteger(qualifiers, (String)"imap port", (int)143);
            mapiport = ParameterMap.getKeyedInteger(qualifiers, (String)"mapi port", (int)593);
        }
        boolean[] result = this.isServer(address, new int[]{pop3port, imapport, mapiport}, retries, timeout);
        if (qualifiers != null) {
            if (result[0] && !qualifiers.containsKey("pop3 port")) {
                qualifiers.put("pop3 port", pop3port);
            }
            if (result[1] && !qualifiers.containsKey("imap port")) {
                qualifiers.put("imap port", imapport);
            }
            if (result[2] && !qualifiers.containsKey("mapi port")) {
                qualifiers.put("mapi port", mapiport);
            }
        }
        return result[0] || result[1] || result[2];
    }
}

