/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSocketFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.DefaultSocketWrapper;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.core.utils.TimeoutSocketFactory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(LdapPlugin.class);
    private static final String PROTOCOL_NAME = "LDAP";
    private static final int[] DEFAULT_PORTS = new int[]{389};
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    protected SocketWrapper getSocketWrapper() {
        return new DefaultSocketWrapper();
    }

    protected int[] determinePorts(Map<String, Object> parameters) {
        return ParameterMap.getKeyedIntegerArray(parameters, (String)"port", (int[])DEFAULT_PORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        boolean isAServer = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            socket.setSoTimeout(timeout);
            LOG.debug("LDAPPlugin.isServer: connect successful");
            for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
                LOG.debug("LDAPPlugin.isServer: attempt {} to connect host {}", (Object)attempts, (Object)InetAddressUtils.str((InetAddress)host));
                LDAPConnection lc = null;
                try {
                    lc = new LDAPConnection((LDAPSocketFactory)new TimeoutLDAPSocket(timeout));
                    lc.connect(InetAddressUtils.str((InetAddress)host), port);
                    isAServer = true;
                    continue;
                }
                catch (LDAPException e) {
                    isAServer = false;
                    continue;
                }
                finally {
                    try {
                        if (lc != null) {
                            lc.disconnect();
                        }
                    }
                    catch (LDAPException lDAPException) {}
                }
            }
        }
        catch (ConnectException e) {
            LOG.debug("{}: connection refused to {}:{}", new Object[]{this.getClass().getName(), InetAddressUtils.str((InetAddress)host), port});
        }
        catch (NoRouteToHostException e) {
            e.fillInStackTrace();
            LOG.info("{}: No route to host {}", new Object[]{this.getClass().getName(), InetAddressUtils.str((InetAddress)host), e});
            throw new UndeclaredThrowableException(e);
        }
        catch (InterruptedIOException e) {
            LOG.debug("LDAPPlugin: failed to connect within specified timeout");
        }
        catch (Throwable t) {
            LOG.warn("{}: An undeclared throwable exception caught contacting host {}", new Object[]{this.getClass().getName(), InetAddressUtils.str((InetAddress)host), t});
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {}
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        for (int i = 0; i < DEFAULT_PORTS.length; ++i) {
            if (!this.isServer(address, DEFAULT_PORTS[i], 0, 5000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
        int[] ports = this.determinePorts(qualifiers);
        for (int i = 0; i < ports.length; ++i) {
            if (!this.isServer(address, ports[i], retries, timeout)) continue;
            qualifiers.put("port", ports[i]);
            return true;
        }
        return false;
    }

    private class TimeoutLDAPSocket
    extends TimeoutSocketFactory
    implements LDAPSocketFactory {
        public TimeoutLDAPSocket(int timeout) {
            super(timeout, LdapPlugin.this.getSocketWrapper());
        }
    }
}

