/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.core.utils.ExecRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GpPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(GpPlugin.class);
    private static final String PROTOCOL_NAME = "GP";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    private boolean isServer(InetAddress host, int retry, int timeout, String script, String args, Pattern regex, StringBuffer bannerResult, String hoption, String toption) {
        boolean isAServer = false;
        LOG.debug("poll: address = {}, script = {}, arguments = {}, timeout(seconds) = {}, retry = {}", new Object[]{InetAddressUtils.str((InetAddress)host), script, args, timeout, retry});
        for (int attempts = 0; attempts <= retry && !isAServer; ++attempts) {
            try {
                int exitStatus = 100;
                ExecRunner er = new ExecRunner();
                er.setMaxRunTimeSecs(timeout);
                exitStatus = args == null ? er.exec(script + " " + hoption + " " + InetAddressUtils.str((InetAddress)host) + " " + toption + " " + timeout) : er.exec(script + " " + hoption + " " + InetAddressUtils.str((InetAddress)host) + " " + toption + " " + timeout + " " + args);
                if (exitStatus != 0) {
                    LOG.debug("{} failed with exit code {}", (Object)script, (Object)exitStatus);
                    isAServer = false;
                }
                if (er.isMaxRunTimeExceeded()) {
                    LOG.debug("{} failed. Timeout exceeded", (Object)script);
                    isAServer = false;
                    continue;
                }
                if (exitStatus != 0) continue;
                String response = "";
                String error = "";
                response = er.getOutString();
                error = er.getErrString();
                if (response.equals("")) {
                    LOG.debug("{} returned no output", (Object)script);
                }
                if (!error.equals("")) {
                    LOG.debug("{} error = {}", (Object)script, (Object)error);
                }
                if (regex == null || regex.matcher(response).find()) {
                    LOG.debug("isServer: matching response = {}", (Object)response);
                    isAServer = true;
                    if (bannerResult == null) continue;
                    bannerResult.append(response);
                    continue;
                }
                isAServer = false;
                LOG.debug("isServer: NON-matching response = {}", (Object)response);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                isAServer = false;
                e.fillInStackTrace();
                LOG.debug("{} ArrayIndexOutOfBoundsException", (Object)script);
                continue;
            }
            catch (InterruptedIOException e) {
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                isAServer = false;
                e.fillInStackTrace();
                LOG.debug("IOException occurred. Check for proper operation of {}", (Object)script);
                continue;
            }
            catch (Throwable e) {
                isAServer = false;
                e.fillInStackTrace();
                LOG.debug("{} Exception occurred", (Object)script);
            }
        }
        LOG.debug("poll: GP - isAServer = {} {}", (Object)isAServer, (Object)InetAddressUtils.str((InetAddress)host));
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected GP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retry = 0;
        int timeout = 5000;
        String banner = null;
        String match = null;
        String script = null;
        String args = null;
        String hoption = "--hostname";
        String toption = "--timeout";
        if (qualifiers != null) {
            retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            script = ParameterMap.getKeyedString(qualifiers, (String)"script", null);
            args = ParameterMap.getKeyedString(qualifiers, (String)"args", null);
            banner = ParameterMap.getKeyedString(qualifiers, (String)"banner", null);
            match = ParameterMap.getKeyedString(qualifiers, (String)"match", null);
            hoption = ParameterMap.getKeyedString(qualifiers, (String)"hoption", (String)"--hostname");
            toption = ParameterMap.getKeyedString(qualifiers, (String)"toption", (String)"--timeout");
        }
        if (script == null) {
            throw new RuntimeException("GpPlugin: required parameter 'script' is not present in supplied properties.");
        }
        timeout = 0 < timeout && timeout < 1000 ? 1 : (timeout /= 1000);
        try {
            StringBuffer bannerResult = null;
            Pattern regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = Pattern.compile(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = Pattern.compile(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, retry, timeout, script, args, regex, bannerResult, hoption, toption);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (PatternSyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

