/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class JdbcCapsdDbSyncer
implements InitializingBean,
CapsdDbSyncer {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCapsdDbSyncer.class);
    private static final String SQL_DB_RETRIEVE_IP_INTERFACE = "SELECT ip.nodeid, ip.ipaddr, ip.ismanaged FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr!='0.0.0.0' AND ip.isManaged!='D' AND ip.isManaged!='F' AND n.foreignSource is null";
    private static final String SQL_DB_RETRIEVE_IP_INTERFACE_IN_LOCAL_SERVER = "SELECT ip.nodeid, ip.ipaddr, ip.ismanaged FROM ipinterface as ip JOIN node as n ON n.nodeid = ip.nodeid JOIN servermap as s ON ip.ipaddr = s.ipaddr WHERE ip.ipaddr!='0.0.0.0' AND ip.isManaged!='D' AND ip.isManaged!='F' AND s.servername = ? AND n.foreignSource is null";
    private static final String SQL_DB_RETRIEVE_SNMP_IP_INTERFACES = "SELECT DISTINCT ipinterface.nodeid,ipinterface.ipaddr,ipinterface.ifindex,ipinterface.issnmpprimary,snmpinterface.snmpiftype,snmpinterface.snmpifindex FROM ipinterface JOIN node ON node.nodeid = ipinterface.nodeid JOIN snmpinterface ON ipinterface.snmpinterfaceid = snmpinterface.id JOIN ifservices ON ifservices.ipinterfaceid = ipinterface.id JOIN service ON ifservices.serviceid = service.serviceid WHERE ipinterface.ismanaged!='D' AND ifservices.status != 'D' AND service.servicename='SNMP' AND node.foreignSource is null";
    private static final String SQL_DB_UPDATE_SNMP_PRIMARY_STATE = "UPDATE ipinterface SET issnmpprimary=? WHERE nodeid=? AND ipaddr=? AND ismanaged!='D'";
    private static final String SQL_DB_RETRIEVE_IF_SERVICES = "SELECT serviceid, status FROM ifservices WHERE nodeid=? AND ipaddr=? AND status!='D' AND status!='F'";
    private static final String SQL_DB_UPDATE_IP_INTERFACE = "UPDATE ipinterface SET ismanaged=? WHERE nodeid=? AND ipaddr=? AND isManaged!='D' AND isManaged!='F'";
    private static final String SQL_DB_UPDATE_ALL_SERVICES_FOR_NIP = "UPDATE ifservices SET status=? WHERE nodeid=? AND ipaddr=? AND status!='D' AND status!='F'";
    private static final String SQL_DB_UPDATE_SERVICE_FOR_NIP = "UPDATE ifservices SET status=? WHERE nodeid=? AND ipaddr=? AND serviceid=? AND status!='D' AND status!='F'";
    private static final String SVCTBL_LOAD_SQL = "SELECT serviceID, serviceName FROM service";
    private static final String SVCTBL_ADD_SQL = "INSERT INTO service (serviceID, serviceName) VALUES (?,?)";
    private static final String DELETE_IFSERVICES_SQL = "update ifservices    set status = 'D'  where serviceid = ?   and id in (   select svc.id     from ifservices as svc     join ipinterface as ip       on (ip.id = svc.ipinterfaceid)     join node as n       on (n.nodeid = ip.nodeid)    where n.foreignsource is null)";
    private static final String DEFAULT_NEXT_SVC_ID_SQL = "SELECT nextval('serviceNxtId')";
    public static final String RETRIEVE_IPADDR_NODEID_SQL = "SELECT ip.nodeid FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr=? AND ip.ismanaged!='D' AND n.foreignSource is null";
    public static final String RETRIEVE_IPADDR_SQL = "SELECT ip.ipaddr FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr=? AND ip.ismanaged!='D'AND n.foreignSource is null";
    private CapsdConfig m_capsdConfig;
    private Map<Integer, String> m_serviceIdToName = new HashMap<Integer, String>();
    private Map<String, Integer> m_serviceNameToId = new HashMap<String, Integer>();
    private OpennmsServerConfigFactory m_opennmsServerConfig;
    private CollectdConfigFactory m_collectdConfig;
    private PollerConfig m_pollerConfig;
    private String m_nextSvcIdSql = "SELECT nextval('serviceNxtId')";
    private JdbcTemplate m_jdbcTemplate;

    @Override
    public Integer getServiceId(String name) {
        Assert.notNull((Object)name, (String)"name argument must not be null");
        return this.m_serviceNameToId.get(name);
    }

    @Override
    public String getServiceName(Integer id) {
        Assert.notNull((Object)id, (String)"id argument must not be null");
        return this.m_serviceIdToName.get(id);
    }

    @Override
    public void syncServices() {
        this.m_jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                JdbcCapsdDbSyncer.this.syncServices(con);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncServices(Connection conn) throws SQLException {
        List<String> serviceNames = this.syncServicesTable(conn);
        PreparedStatement delFromIfServicesStmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            List protocols = this.getCapsdConfig().getConfiguredProtocols();
            for (String service : serviceNames) {
                if (protocols.contains(service)) continue;
                LOG.debug("syncServices: service {} exists in the database but not in the Capsd config file.", (Object)service);
                Integer id = this.m_serviceNameToId.get(service);
                LOG.debug("syncServices: deleting all references to service id {} from the IfServices table.", (Object)id);
                delFromIfServicesStmt = conn.prepareStatement(DELETE_IFSERVICES_SQL);
                d.watch((Object)delFromIfServicesStmt);
                delFromIfServicesStmt.setInt(1, id);
                delFromIfServicesStmt.executeUpdate();
                LOG.info("syncServices: deleted service id {} for service '{}' from the IfServices table.", (Object)id, (Object)service);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    @Override
    public List<String> syncServicesTable() {
        return (List)this.m_jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<List<String>>(){

            public List<String> doInConnection(Connection con) throws SQLException, DataAccessException {
                return JdbcCapsdDbSyncer.this.syncServicesTable(con);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> syncServicesTable(Connection conn) throws SQLException {
        ArrayList<String> serviceNames;
        LOG.debug("syncServicesTable: synchronizing services list with the database");
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement insStmt = conn.prepareStatement(SVCTBL_ADD_SQL);
            d.watch((Object)insStmt);
            PreparedStatement nxtStmt = conn.prepareStatement(this.getNextSvcIdSql());
            d.watch((Object)nxtStmt);
            PreparedStatement loadStmt = conn.prepareStatement(SVCTBL_LOAD_SQL);
            d.watch((Object)loadStmt);
            serviceNames = new ArrayList<String>();
            ResultSet rs = loadStmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String name = rs.getString(2);
                this.m_serviceIdToName.put(id, name);
                this.m_serviceNameToId.put(name, id);
                serviceNames.add(name);
            }
            for (String protocol : this.getCapsdConfig().getConfiguredProtocols()) {
                LOG.debug("syncServicesTable: checking protocol '{}'.", (Object)protocol);
                if (serviceNames.contains(protocol)) continue;
                LOG.debug("syncServicesTable: protocol '{}' is not in the database... adding.", (Object)protocol);
                rs = nxtStmt.executeQuery();
                d.watch((Object)rs);
                rs.next();
                int id = rs.getInt(1);
                rs.close();
                LOG.debug("syncServicesTable: using id {} for protocol '{}'.", (Object)id, (Object)protocol);
                insStmt.setInt(1, id);
                insStmt.setString(2, protocol);
                insStmt.executeUpdate();
                this.m_serviceIdToName.put(id, protocol);
                this.m_serviceNameToId.put(protocol, id);
                serviceNames.add(protocol);
                LOG.info("syncServicesTable: added service entry to the database for protocol '{}' with id of {}", (Object)protocol, (Object)id);
            }
        }
        finally {
            d.cleanUp();
        }
        return serviceNames;
    }

    @Override
    public void syncManagementState() {
        this.m_jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                JdbcCapsdDbSyncer.this.syncManagementState(con);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncManagementState(Connection conn) throws SQLException {
        boolean verifyServer = this.getOpennmsServerConfig().verifyServer();
        String localServer = this.getOpennmsServerConfig().getServerName();
        LOG.debug("syncManagementState: local server: {} verify server: {}", (Object)localServer, (Object)verifyServer);
        if (conn == null) {
            LOG.error("CapsdConfigFactory.syncManagementState: Sync failed...must have valid database connection.");
            return;
        }
        String managementPolicy = this.getCapsdConfig().getConfiguration().getManagementPolicy();
        boolean managedByDefault = managementPolicy == null || managementPolicy.equalsIgnoreCase("managed");
        LOG.debug("syncManagementState: managed_by_default: {}", (Object)managedByDefault);
        PreparedStatement ipRetStmt = null;
        DBUtils d = new DBUtils(this.getClass());
        ArrayList<LightWeightIfEntry> ifList = new ArrayList<LightWeightIfEntry>();
        try {
            if (verifyServer) {
                ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IP_INTERFACE_IN_LOCAL_SERVER);
                d.watch((Object)ipRetStmt);
                ipRetStmt.setString(1, localServer);
            } else {
                ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IP_INTERFACE);
                d.watch((Object)ipRetStmt);
            }
            ResultSet result = null;
            result = ipRetStmt.executeQuery();
            d.watch((Object)result);
            while (result.next()) {
                int nodeId = result.getInt(1);
                String address = result.getString(2);
                if (address == null) {
                    LOG.warn("invalid ipInterface table entry, no IP address, skipping...");
                    continue;
                }
                char managedState = ' ';
                String str = result.getString(3);
                if (str != null) {
                    managedState = str.charAt(0);
                }
                ifList.add(new LightWeightIfEntry(nodeId, -1, address, managedState, ' ', -1));
            }
        }
        finally {
            d.cleanUp();
        }
        try {
            PreparedStatement ifUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_IP_INTERFACE);
            d.watch((Object)ifUpdateStmt);
            PreparedStatement allSvcUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_ALL_SERVICES_FOR_NIP);
            d.watch((Object)allSvcUpdateStmt);
            PreparedStatement svcRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IF_SERVICES);
            d.watch((Object)svcRetStmt);
            PreparedStatement svcUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_SERVICE_FOR_NIP);
            d.watch((Object)svcUpdateStmt);
            for (LightWeightIfEntry ifEntry : ifList) {
                String ipaddress = ifEntry.getAddress();
                InetAddress ifAddress = null;
                ifAddress = InetAddressUtils.addr((String)ipaddress);
                if (ifAddress == null) {
                    LOG.warn("Failed converting ip address {} to InetAddress.", (Object)ipaddress);
                    continue;
                }
                boolean address_is_unmanaged = this.getCapsdConfig().isAddressUnmanaged(ifAddress);
                LOG.debug("syncManagementState: {} unmanaged based on capsd config?: {}", (Object)ipaddress, (Object)address_is_unmanaged);
                if (address_is_unmanaged) {
                    if (ifEntry.getManagementState() == 'U') continue;
                    ifUpdateStmt.setString(1, new String(new char[]{'U'}));
                    ifUpdateStmt.setInt(2, ifEntry.getNodeId());
                    ifUpdateStmt.setString(3, ipaddress);
                    ifUpdateStmt.executeUpdate();
                    allSvcUpdateStmt.setString(1, new String(new char[]{'U'}));
                    allSvcUpdateStmt.setInt(2, ifEntry.getNodeId());
                    allSvcUpdateStmt.setString(3, ipaddress);
                    allSvcUpdateStmt.executeUpdate();
                    LOG.debug("syncManagementState: update completed for node/interface: {}/{} to unmanaged", (Object)ifEntry.getNodeId(), (Object)ipaddress);
                    continue;
                }
                PollerConfig pollerConfig = this.getPollerConfig();
                pollerConfig.getReadLock().lock();
                try {
                    Package ipPkg = pollerConfig.getFirstPackageMatch(ipaddress);
                    boolean ipToBePolled = false;
                    if (ipPkg != null) {
                        ipToBePolled = true;
                    }
                    LOG.debug("syncManagementState: {} to be polled based on poller config?: {}", (Object)ipaddress, (Object)ipToBePolled);
                    if (ifEntry.getManagementState() == 'M' && ipToBePolled || ifEntry.getManagementState() == 'N' && !ipToBePolled) {
                        LOG.debug("syncManagementState: {} - no change in status", (Object)ipaddress);
                    } else {
                        if (ipToBePolled) {
                            ifUpdateStmt.setString(1, new String(new char[]{'M'}));
                        } else {
                            ifUpdateStmt.setString(1, new String(new char[]{'N'}));
                        }
                        ifUpdateStmt.setInt(2, ifEntry.getNodeId());
                        ifUpdateStmt.setString(3, ipaddress);
                        ifUpdateStmt.executeUpdate();
                        LOG.debug("syncManagementState: update completed for node/interface: {}/{}", (Object)ifEntry.getNodeId(), (Object)ipaddress);
                    }
                    svcRetStmt.setInt(1, ifEntry.getNodeId());
                    svcRetStmt.setString(2, ipaddress);
                    ResultSet svcRS = svcRetStmt.executeQuery();
                    d.watch((Object)svcRS);
                    while (svcRS.next()) {
                        int svcId = svcRS.getInt(1);
                        char svcStatus = ' ';
                        String str = svcRS.getString(2);
                        if (str != null) {
                            svcStatus = str.charAt(0);
                        }
                        String svcName = this.getServiceName(svcId);
                        char oldStatus = svcStatus;
                        char newStatus = 'U';
                        boolean svcToBePolledLocally = this.isServicePolledLocally(ipaddress, svcName, ipPkg);
                        boolean svcToBePolledRemotely = this.isServicePolled(ipaddress, svcName, ipPkg);
                        LOG.debug("syncManagementState: {}/{} to be polled based on poller config?: {}", new Object[]{ipaddress, svcName, svcToBePolledLocally});
                        if (svcStatus == 'A' && svcToBePolledLocally || svcStatus == 'N' && !ipToBePolled) {
                            LOG.debug("syncManagementState: {}/{}/{} status = {} - no change in status", new Object[]{ifEntry.getNodeId(), ipaddress, svcName, Character.valueOf(svcStatus)});
                            continue;
                        }
                        if (svcStatus == 'S' && svcToBePolledLocally) {
                            svcUpdateStmt.setString(1, new String(new char[]{'F'}));
                            newStatus = 'F';
                        } else if (svcToBePolledLocally) {
                            svcUpdateStmt.setString(1, new String(new char[]{'A'}));
                            newStatus = 'A';
                        } else if (svcToBePolledRemotely) {
                            svcUpdateStmt.setString(1, new String(new char[]{'X'}));
                            newStatus = 'X';
                        } else {
                            svcUpdateStmt.setString(1, new String(new char[]{'N'}));
                            newStatus = 'N';
                        }
                        svcUpdateStmt.setInt(2, ifEntry.getNodeId());
                        svcUpdateStmt.setString(3, ipaddress);
                        svcUpdateStmt.setInt(4, svcId);
                        svcUpdateStmt.executeUpdate();
                        LOG.debug("syncManagementState: update completed for node/interface/svc: {}/{}/{} status changed from {} to {}", new Object[]{ifEntry.getNodeId(), ipaddress, svcName, Character.valueOf(oldStatus), Character.valueOf(newStatus)});
                    }
                }
                finally {
                    pollerConfig.getReadLock().unlock();
                }
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServicePolled(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null) {
            PollerConfig pollerConfig = this.getPollerConfig();
            pollerConfig.getReadLock().lock();
            try {
                svcToBePolled = pollerConfig.isPolled(svcName, ipPkg);
                if (!svcToBePolled) {
                    svcToBePolled = pollerConfig.isPolled(ifAddr, svcName);
                }
            }
            finally {
                pollerConfig.getReadLock().unlock();
            }
        }
        return svcToBePolled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServicePolledLocally(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !ipPkg.getRemote().booleanValue()) {
            PollerConfig pollerConfig = this.getPollerConfig();
            pollerConfig.getReadLock().lock();
            try {
                svcToBePolled = pollerConfig.isPolled(svcName, ipPkg);
                if (!svcToBePolled) {
                    svcToBePolled = pollerConfig.isPolledLocally(ifAddr, svcName);
                }
            }
            finally {
                pollerConfig.getReadLock().unlock();
            }
        }
        return svcToBePolled;
    }

    @Override
    public void syncSnmpPrimaryState() {
        this.m_jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                JdbcCapsdDbSyncer.this.syncSnmpPrimaryState(con);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void syncSnmpPrimaryState(Connection conn) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("Sync failed...must have valid database connection.");
        }
        LOG.debug("syncSnmpPrimaryState: building map of nodes to interfaces...");
        HashMap nodes = new HashMap();
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_SNMP_IP_INTERFACES);
            d.watch((Object)ipRetStmt);
            ResultSet result = ipRetStmt.executeQuery();
            d.watch((Object)result);
            List<LightWeightIfEntry> ifList = new ArrayList();
            while (result.next()) {
                int nodeId = result.getInt(1);
                String address = result.getString(2);
                if (address == null) {
                    LOG.warn("invalid ipInterface table entry, no IP address, skipping...");
                    continue;
                }
                int ifIndex = result.getInt(6);
                if (result.wasNull()) {
                    LOG.debug("ipInterface table entry for address {} does not have a valid ifIndex ", (Object)address);
                    ifIndex = -1;
                } else if (ifIndex < 1) {
                    if (ifIndex == -100) {
                        LOG.debug("Using ifIndex = {} for address {}", (Object)-100, (Object)address);
                    } else {
                        LOG.debug("ipInterface table entry for address {} does not have a valid ifIndex ", (Object)address);
                        ifIndex = -1;
                    }
                }
                char primarySnmpState = ' ';
                String str = result.getString(4);
                if (str != null) {
                    primarySnmpState = str.charAt(0);
                }
                int ifType = result.getInt(5);
                if (result.wasNull()) {
                    LOG.debug("snmpInterface table entry for address {} does not have a valid ifType", (Object)address);
                    ifType = -1;
                }
                if ((ifList = (List)nodes.get(nodeId)) == null) {
                    ifList = new ArrayList();
                    ifList.add(new LightWeightIfEntry(nodeId, ifIndex, address, ' ', primarySnmpState, ifType));
                    nodes.put(nodeId, ifList);
                    continue;
                }
                ifList.add(new LightWeightIfEntry(nodeId, ifIndex, address, ' ', primarySnmpState, ifType));
            }
        }
        finally {
            d.cleanUp();
        }
        LOG.debug("syncSnmpPrimaryState: iterating over nodes in map and checking primary SNMP interface, node count: {}", (Object)nodes.size());
        for (Integer nId : nodes.keySet()) {
            LOG.debug("building SNMP address list for node {}", (Object)nId);
            List ifEntries = (List)nodes.get(nId);
            ArrayList<InetAddress> addressList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> lbAddressList = new ArrayList<InetAddress>();
            for (LightWeightIfEntry lwIf : ifEntries) {
                if (lwIf.getIfIndex() == -1) {
                    LOG.debug("skipping address {}: does not have a valid ifIndex.", (Object)lwIf.getAddress());
                    continue;
                }
                InetAddress addr = InetAddressUtils.addr((String)lwIf.getAddress());
                addressList.add(addr);
                if (lwIf.getIfType() != 24) continue;
                lbAddressList.add(addr);
            }
            boolean strict = true;
            InetAddress primarySnmpIf = null;
            String psiType = null;
            if (lbAddressList != null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(lbAddressList, strict);
                psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
            }
            if (primarySnmpIf == null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(addressList, strict);
                psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
            }
            strict = false;
            if (primarySnmpIf == null && lbAddressList != null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(lbAddressList, strict);
                psiType = "DB loopback addresses";
            }
            if (primarySnmpIf == null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(addressList, strict);
                psiType = "DB addresses";
            }
            if (LOG.isDebugEnabled()) {
                if (primarySnmpIf == null) {
                    LOG.debug("syncSnmpPrimaryState: No primary SNMP interface found for node {}", (Object)nId);
                } else {
                    LOG.debug("syncSnmpPrimaryState: primary SNMP interface for node {} is: {}, selected from {}", new Object[]{nId, primarySnmpIf, psiType});
                }
            }
            for (LightWeightIfEntry lwIf : ifEntries) {
                if (lwIf.getIfIndex() == -1) {
                    lwIf.setSnmpPrimaryState('N');
                } else if (primarySnmpIf == null || !lwIf.getAddress().equals(InetAddressUtils.str((InetAddress)primarySnmpIf))) {
                    if (this.getCollectdConfig().isServiceCollectionEnabled(lwIf.getAddress(), "SNMP")) {
                        lwIf.setSnmpPrimaryState('S');
                    } else {
                        lwIf.setSnmpPrimaryState('N');
                    }
                } else {
                    lwIf.setSnmpPrimaryState('P');
                }
                if (!lwIf.hasSnmpPrimaryStateChanged()) continue;
                LOG.debug("syncSnmpPrimaryState: updating {}/{}, marking with state: {}", new Object[]{lwIf.getNodeId(), lwIf.getAddress(), Character.valueOf(lwIf.getSnmpPrimaryState())});
                try {
                    PreparedStatement updateStmt = conn.prepareStatement(SQL_DB_UPDATE_SNMP_PRIMARY_STATE);
                    d.watch((Object)updateStmt);
                    updateStmt.setString(1, new String(new char[]{lwIf.getSnmpPrimaryState()}));
                    updateStmt.setInt(2, lwIf.getNodeId());
                    updateStmt.setString(3, lwIf.getAddress());
                    updateStmt.executeUpdate();
                }
                finally {
                    d.cleanUp();
                }
            }
        }
        LOG.debug("syncSnmpPrimaryState: sync completed.");
    }

    public CapsdConfig getCapsdConfig() {
        return this.m_capsdConfig;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    public OpennmsServerConfigFactory getOpennmsServerConfig() {
        return this.m_opennmsServerConfig;
    }

    public void setOpennmsServerConfig(OpennmsServerConfigFactory serverConfigFactory) {
        this.m_opennmsServerConfig = serverConfigFactory;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public CollectdConfigFactory getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public void setCollectdConfig(CollectdConfigFactory collectdConfigFactory) {
        this.m_collectdConfig = collectdConfigFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_jdbcTemplate != null ? 1 : 0) != 0, (String)"property jdbcTemplate must be set to a non-null value");
        Assert.state((this.m_opennmsServerConfig != null ? 1 : 0) != 0, (String)"property opennmsServerConfig must be set to a non-null value");
        Assert.state((this.m_pollerConfig != null ? 1 : 0) != 0, (String)"property pollerConfig must be set to a non-null value");
        Assert.state((this.m_collectdConfig != null ? 1 : 0) != 0, (String)"property collectdConfig must be set to a non-null value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterfaceDbNodeId(Connection dbConn, InetAddress ifAddress, int ifIndex) throws SQLException {
        LOG.debug("getInterfaceDbNodeId: attempting to lookup interface {}/ifindex: {} in the database.", (Object)InetAddressUtils.str((InetAddress)ifAddress), (Object)ifIndex);
        StringBuffer qs = new StringBuffer(RETRIEVE_IPADDR_NODEID_SQL);
        if (ifIndex != -1) {
            qs.append(" AND ifindex=?");
        }
        int nodeid = -1;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement s = dbConn.prepareStatement(qs.toString());
            d.watch((Object)s);
            s.setString(1, InetAddressUtils.str((InetAddress)ifAddress));
            if (ifIndex != -1) {
                s.setInt(2, ifIndex);
            }
            ResultSet rs = s.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeid = rs.getInt(1);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeid;
    }

    @Override
    public boolean isInterfaceInDB(final InetAddress ifAddress) {
        return (Boolean)this.m_jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                return JdbcCapsdDbSyncer.this.isInterfaceInDB(con, ifAddress) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInterfaceInDB(Connection dbConn, InetAddress ifAddress) throws SQLException {
        boolean result = false;
        LOG.debug("isInterfaceInDB: attempting to lookup interface {} in the database.", (Object)InetAddressUtils.str((InetAddress)ifAddress));
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement s = dbConn.prepareStatement(RETRIEVE_IPADDR_SQL);
            d.watch((Object)s);
            s.setString(1, InetAddressUtils.str((InetAddress)ifAddress));
            rs = s.executeQuery();
            d.watch((Object)rs);
            result = rs.next();
        }
        finally {
            d.cleanUp();
        }
        return result;
    }

    private InetAddress compareAndSelectPrimaryCollectionInterface(String svcName, InetAddress currentIf, InetAddress oldPrimary, String method, boolean strict) {
        InetAddress newPrimary = null;
        if (oldPrimary == null && strict) {
            if (this.m_collectdConfig.isServiceCollectionEnabled(InetAddressUtils.str((InetAddress)currentIf), svcName)) {
                return currentIf;
            }
            return oldPrimary;
        }
        if (oldPrimary == null) {
            return currentIf;
        }
        int comparison = new ByteArrayComparator().compare(currentIf.getAddress(), oldPrimary.getAddress());
        if (method.equals("min")) {
            if (comparison < 0) {
                if (strict) {
                    if (this.m_collectdConfig.isServiceCollectionEnabled(InetAddressUtils.str((InetAddress)currentIf), svcName)) {
                        newPrimary = currentIf;
                    }
                } else {
                    newPrimary = currentIf;
                }
            }
        } else if (comparison > 0) {
            if (strict) {
                if (this.m_collectdConfig.isServiceCollectionEnabled(InetAddressUtils.str((InetAddress)currentIf), svcName)) {
                    newPrimary = currentIf;
                }
            } else {
                newPrimary = currentIf;
            }
        }
        if (newPrimary != null) {
            return newPrimary;
        }
        return oldPrimary;
    }

    @Override
    public InetAddress determinePrimarySnmpInterface(List<InetAddress> addressList, boolean strict) {
        InetAddress primaryIf = null;
        String method = "min";
        for (InetAddress ipAddr : addressList) {
            LOG.debug("determinePrimarySnmpIf: checking interface {}", (Object)InetAddressUtils.str((InetAddress)ipAddr));
            primaryIf = this.compareAndSelectPrimaryCollectionInterface("SNMP", ipAddr, primaryIf, method, strict);
        }
        if (primaryIf != null) {
            LOG.debug("determinePrimarySnmpInterface: candidate primary SNMP interface: {}", (Object)InetAddressUtils.str(primaryIf));
        } else {
            LOG.debug("determinePrimarySnmpInterface: no candidate primary SNMP interface found");
        }
        return primaryIf;
    }

    public void setNextSvcIdSql(String nextSvcIdSql) {
        this.m_nextSvcIdSql = nextSvcIdSql;
    }

    public String getNextSvcIdSql() {
        return this.m_nextSvcIdSql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.m_jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean isServiceCollectionEnabled(String addrString, String string) {
        return this.m_collectdConfig.isServiceCollectionEnabled(addrString, string);
    }

    protected static final class LightWeightIfEntry {
        protected static final int NULL_IFINDEX = -1;
        protected static final int NULL_IFTYPE = -1;
        protected static final int LOOPBACK_IFTYPE = 24;
        private int m_nodeId;
        private int m_ifIndex;
        private int m_ifType;
        private String m_address;
        private char m_managementState;
        private char m_snmpPrimaryState;
        private boolean m_primaryStateChanged;

        public LightWeightIfEntry(int nodeId, int ifIndex, String address, char managementState, char snmpPrimaryState, int ifType) {
            this.m_nodeId = nodeId;
            this.m_ifIndex = ifIndex;
            this.m_address = address;
            this.m_managementState = managementState;
            this.m_snmpPrimaryState = snmpPrimaryState;
            this.m_ifType = ifType;
            this.m_primaryStateChanged = false;
        }

        public String getAddress() {
            return this.m_address;
        }

        public int getNodeId() {
            return this.m_nodeId;
        }

        public int getIfIndex() {
            return this.m_ifIndex;
        }

        public int getIfType() {
            return this.m_ifType;
        }

        public char getManagementState() {
            return this.m_managementState;
        }

        public char getSnmpPrimaryState() {
            return this.m_snmpPrimaryState;
        }

        public void setSnmpPrimaryState(char state) {
            if (state != this.m_snmpPrimaryState) {
                this.m_snmpPrimaryState = state;
                this.m_primaryStateChanged = true;
            }
        }

        public boolean hasSnmpPrimaryStateChanged() {
            return this.m_primaryStateChanged;
        }
    }
}

