/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.JdbcCapsdDbSyncer;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.TestCapsdConfigManager;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.xmlrpcd.OpenNMSProvisioner;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class OpenNMSProvisionerTest {
    private OpenNMSProvisioner m_provisioner;
    private TestCapsdConfigManager m_capsdConfig;
    private TestPollerConfigManager m_pollerConfig;
    public static final String POLLER_CONFIG = "\n<poller-configuration\n   threads=\"10\"\n   nextOutageId=\"SELECT nextval('outageNxtId')\"\n   serviceUnresponsiveEnabled=\"false\">\n   <node-outage status=\"on\" pollAllIfNoCriticalServiceDefined=\"true\"></node-outage>\n   <package name=\"default\">\n       <filter>IPADDR IPLIKE *.*.*.*</filter>\n       <rrd step = \"300\">\n           <rra>RRA:AVERAGE:0.5:1:2016</rra>\n           <rra>RRA:AVERAGE:0.5:12:4464</rra>\n           <rra>RRA:MIN:0.5:12:4464</rra>\n           <rra>RRA:MAX:0.5:12:4464</rra>\n       </rrd>\n       <service name=\"ICMP\" interval=\"300000\">\n           <parameter key=\"retry\" value=\"2\" />\n           <parameter key=\"timeout\" value=\"3000\"/>\n       </service>\n       <downtime begin=\"10000\" end=\"40000\" interval=\"300000\"/>\n       <downtime begin=\"40000\" interval=\"300000\"/>\n   </package>\n   <package name=\"MyTcp\">\n       <filter>IPADDR IPLIKE *.*.*.*</filter>\n       <rrd step = \"300\">\n           <rra>RRA:AVERAGE:0.5:1:2016</rra>\n           <rra>RRA:AVERAGE:0.5:12:4464</rra>\n           <rra>RRA:MIN:0.5:12:4464</rra>\n           <rra>RRA:MAX:0.5:12:4464</rra>\n       </rrd>\n       <service name=\"MyTcp\" interval=\"1234\">\n           <parameter key=\"retry\" value=\"3\" />\n           <parameter key=\"timeout\" value=\"314159\"/>\n           <parameter key=\"port\" value=\"1776\"/>\n           <parameter key=\"banner\" value=\"Right back at ya!\"/>\n       </service>\n       <downtime begin=\"0\" end=\"1492\" interval=\"17\"/>\n       <downtime begin=\"1492\" interval=\"1234\"/>\n   </package>\n   <monitor service=\"ICMP\" class-name=\"org.opennms.netmgt.poller.monitors.LdapMonitor\"/>\n   <monitor service=\"MyTcp\" class-name=\"org.opennms.netmgt.poller.monitors.LdapMonitor\"/>\n</poller-configuration>\n";
    private static final String CAPSD_CONFIG = "\n<capsd-configuration max-suspect-thread-pool-size=\"2\" max-rescan-thread-pool-size=\"3\"\n   delete-propagation-enabled=\"true\">\n   <protocol-plugin protocol=\"ICMP\" class-name=\"org.opennms.netmgt.capsd.plugins.LdapPlugin\"/>\n   <protocol-plugin protocol=\"MyTcp\" class-name=\"org.opennms.netmgt.capsd.plugins.LdapPlugin\"/>\n</capsd-configuration>\n";
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private RrdStrategy<?, ?> m_strategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);
    private MockEventIpcManager m_eventManager;
    private JdbcCapsdDbSyncer m_syncer;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        MockDatabase db = new MockDatabase();
        DataSourceFactory.setInstance((DataSource)db);
        RrdUtils.setStrategy(this.m_strategy);
        this.m_provisioner = new OpenNMSProvisioner();
        this.m_eventManager = new MockEventIpcManager();
        this.m_provisioner.setEventManager((EventIpcManager)this.m_eventManager);
        this.m_capsdConfig = new TestCapsdConfigManager(CAPSD_CONFIG);
        CapsdConfigFactory.setInstance((CapsdConfig)this.m_capsdConfig);
        this.m_pollerConfig = new TestPollerConfigManager(POLLER_CONFIG, "localhost", false);
        PollerConfigFactory.setInstance((PollerConfig)this.m_pollerConfig);
        this.m_provisioner.setCapsdConfig((CapsdConfig)this.m_capsdConfig);
        this.m_provisioner.setPollerConfig((PollerConfig)this.m_pollerConfig);
        InputStream configStream = ConfigurationTestUtils.getInputStreamForConfigFile((String)"opennms-server.xml");
        OpennmsServerConfigFactory onmsSvrConfig = new OpennmsServerConfigFactory(configStream);
        configStream.close();
        OpennmsServerConfigFactory.setInstance((OpennmsServerConfigFactory)onmsSvrConfig);
        configStream = ConfigurationTestUtils.getInputStreamForConfigFile((String)"database-schema.xml");
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(configStream));
        configStream.close();
        configStream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/org/opennms/netmgt/capsd/collectd-configuration.xml");
        CollectdConfigFactory collectdConfigFactory = new CollectdConfigFactory(configStream, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
        configStream.close();
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)db);
        this.m_syncer = new JdbcCapsdDbSyncer();
        this.m_syncer.setJdbcTemplate(jdbcTemplate);
        this.m_syncer.setOpennmsServerConfig(OpennmsServerConfigFactory.getInstance());
        this.m_syncer.setCapsdConfig((CapsdConfig)this.m_capsdConfig);
        this.m_syncer.setPollerConfig((PollerConfig)this.m_pollerConfig);
        this.m_syncer.setCollectdConfig(collectdConfigFactory);
        this.m_syncer.setNextSvcIdSql(db.getNextServiceIdStatement());
        this.m_syncer.afterPropertiesSet();
        this.m_syncer.syncServices();
        this.m_provisioner.setCapsdDbSyncer((CapsdDbSyncer)this.m_syncer);
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testGetServiceConfiguration() throws Exception {
        this.checkServiceConfiguration("default", "ICMP", 2, 3000, 300000, 300000, 30000);
        this.checkTcpConfiguration("MyTcp", "MyTcp", 3, 314159, 1234, 17, 1492, 1776, "Right back at ya!");
    }

    private Map<String, Object> checkTcpConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration, int port, String banner) throws Exception {
        Map<String, Object> configParams = this.checkServiceConfiguration(pkgName, svcName, retries, timeout, interval, downtimeInterval, downtimeDuration);
        Assert.assertEquals((Object)port, (Object)configParams.get("port"));
        Assert.assertEquals((Object)banner, (Object)configParams.get("banner"));
        return configParams;
    }

    private Map<String, Object> checkServiceConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration) throws Exception {
        Map configParams = this.m_provisioner.getServiceConfiguration(pkgName, svcName);
        Assert.assertEquals((Object)svcName, configParams.get("serviceid"));
        Assert.assertEquals((Object)interval, configParams.get("interval"));
        Assert.assertEquals((Object)downtimeInterval, configParams.get("downtime_interval"));
        Assert.assertEquals((Object)downtimeDuration, configParams.get("downtime_duration"));
        Assert.assertNull(configParams.get("downtime_interval1"));
        Assert.assertNull(configParams.get("downtime_duration1"));
        Assert.assertEquals((Object)retries, configParams.get("retries"));
        Assert.assertEquals((Object)timeout, configParams.get("timeout"));
        TestPollerConfigManager mgr = new TestPollerConfigManager(this.m_pollerConfig.getXml(), "localhost", false);
        Package pkg = mgr.getPackage(pkgName);
        Assert.assertNotNull((Object)pkg);
        Service svc = mgr.getServiceInPackage(svcName, pkg);
        Assert.assertNotNull((Object)svc);
        Assert.assertEquals((Object)interval, (Object)svc.getInterval());
        Assert.assertNotNull((String)("Unables to find monitor for svc " + svcName + " in origonal config"), (Object)this.m_pollerConfig.getServiceMonitor(svcName));
        Assert.assertNotNull((String)("Unable to find monitor for svc " + svcName), (Object)mgr.getServiceMonitor(svcName));
        Assert.assertNotNull((String)("Unable to find protocol plugin in capsdConfig for svc " + svcName), (Object)this.m_capsdConfig.getProtocolPlugin(svcName));
        Assert.assertNotNull((String)("Unable to find service table entry in capsdConfig for svc " + svcName), (Object)this.m_syncer.getServiceId(svcName));
        return configParams;
    }

    @Test
    public void testGetServiceConfigNullPkgName() {
        try {
            this.m_provisioner.getServiceConfiguration(null, "ICMP");
            Assert.fail((String)"Expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetServiceConfigNullServiceId() {
        try {
            this.m_provisioner.getServiceConfiguration("default", null);
            Assert.fail((String)"Expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetServiceConfigInvalidPkg() {
        try {
            this.m_provisioner.getServiceConfiguration("invalid", "ICMP");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetServiceConfigInvalidServiceId() {
        try {
            this.m_provisioner.getServiceConfiguration("default", "invalid");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddServiceIcmp() throws Exception {
        this.m_provisioner.addServiceICMP("MyIcmp", 77, 1066, 36, 5, 1812);
        this.checkServiceConfiguration("MyIcmp", "MyIcmp", 77, 1066, 36, 5, 1812);
        TestPollerConfigManager mgr = new TestPollerConfigManager(this.m_pollerConfig.getXml(), "localhost", false);
        Package pkg = mgr.getPackage("MyIcmp");
        Assert.assertNotNull((Object)pkg);
        Assert.assertNotNull((Object)mgr.getServiceInPackage("MyIcmp", pkg));
    }

    @Test
    public void testAddServiceDatabase() throws Exception {
        this.expectUpdateEvent();
        this.m_mocks.replayAll();
        this.m_provisioner.addServiceDatabase("MyDB", 13, 2001, 54321, 71, 23456, "dbuser", "dbPasswd", "org.mydb.MyDriver", "jdbc://mydbhost:2");
        this.checkDatabaseConfiguration("MyDB", "MyDB", 13, 2001, 54321, 71, 23456, "dbuser", "dbPasswd", "org.mydb.MyDriver", "jdbc://mydbhost:2");
        this.m_mocks.verifyAll();
        this.verifyEvents();
    }

    @Test
    public void testAddServiceDNS() throws Exception {
        this.expectUpdateEvent();
        this.m_mocks.replayAll();
        this.m_provisioner.addServiceDNS("MyDNS", 11, 1111, 11111, 111, 111111, 101, "www.opennms.org");
        this.checkDNSConfiguration("MyDNS", "MyDNS", 11, 1111, 11111, 111, 111111, 101, "www.opennms.org");
        this.m_mocks.verifyAll();
        this.verifyEvents();
    }

    @Test
    public void testAddServiceHTTP() throws Exception {
        this.expectUpdateEvent();
        this.m_mocks.replayAll();
        this.m_provisioner.addServiceHTTP("MyHTTP", 22, 2222, 22222, 222, 222222, "opennms.com", 212, "200-203", "Home", "/index.html", "user", "passwd", null);
        this.checkHTTPConfiguration("MyHTTP", "MyHTTP", 22, 2222, 22222, 222, 222222, "opennms.com", 212, "200-203", "Home", "/index.html", "user", "passwd", null);
        this.m_mocks.verifyAll();
        this.verifyEvents();
    }

    @Test
    public void testAddServiceHTTPNoResponseCode() throws Exception {
        this.expectUpdateEvent();
        this.m_mocks.replayAll();
        this.m_provisioner.addServiceHTTP("MyHTTP", 22, 2222, 22222, 222, 222222, "opennms.com", 212, "", "Home", "/index.html", "user", "pw", "");
        this.checkHTTPConfiguration("MyHTTP", "MyHTTP", 22, 2222, 22222, 222, 222222, "opennms.com", 212, null, "Home", "/index.html", "user", "pw", "");
        this.m_mocks.verifyAll();
        this.verifyEvents();
    }

    private Map<String, Object> checkHTTPConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration, String hostName, int port, String responseCode, String contentCheck, String url, String user, String passwd, String agent) throws Exception {
        Map<String, Object> configParams = this.checkServiceConfiguration(pkgName, svcName, retries, timeout, interval, downtimeInterval, downtimeDuration);
        Assert.assertEquals((Object)hostName, (Object)configParams.get("hostname"));
        Assert.assertEquals((Object)port, (Object)configParams.get("port"));
        Assert.assertEquals((Object)responseCode, (Object)configParams.get("response"));
        Assert.assertEquals((Object)contentCheck, (Object)configParams.get("response_text"));
        Assert.assertEquals((Object)user, (Object)configParams.get("user"));
        Assert.assertEquals((Object)passwd, (Object)configParams.get("password"));
        Assert.assertEquals((Object)agent, (Object)configParams.get("agent"));
        Assert.assertEquals((Object)url, (Object)configParams.get("url"));
        return configParams;
    }

    @Test
    public void testAddServiceHTTPS() throws Exception {
        this.expectUpdateEvent();
        this.m_mocks.replayAll();
        this.m_provisioner.addServiceHTTPS("MyHTTPS", 33, 3333, 33333, 333, 333333, "opennms.com", 313, "303", "Secure", "/secure.html", "user", "pw", "");
        this.checkHTTPSConfiguration("MyHTTPS", "MyHTTPS", 33, 3333, 33333, 333, 333333, "opennms.com", 313, "303", "Secure", "/secure.html", "user", "pw", "");
        this.m_mocks.verifyAll();
        this.verifyEvents();
    }

    private Map<String, Object> checkHTTPSConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration, String hostName, int port, String responseCode, String contentCheck, String url, String user, String passwd, String agent) throws Exception {
        return this.checkHTTPConfiguration(pkgName, svcName, retries, timeout, interval, downtimeInterval, downtimeDuration, hostName, port, responseCode, contentCheck, url, user, passwd, agent);
    }

    @Test
    public void testAddServiceTCP() throws Exception {
        this.expectUpdateEvent();
        this.m_mocks.replayAll();
        this.m_provisioner.addServiceTCP("MyTCP", 4, 44, 444, 4444, 44444, 404, "HELO");
        this.checkTCPConfiguration("MyTCP", "MyTCP", 4, 44, 444, 4444, 44444, 404, "HELO");
        this.m_mocks.verifyAll();
        this.verifyEvents();
    }

    private void expectUpdateEvent() {
        this.m_eventManager.getEventAnticipator().anticipateEvent(MockEventUtil.createEventBuilder((String)"Test", (String)"uei.opennms.org/internal/schedOutagesChanged").getEvent());
    }

    private void verifyEvents() {
        this.m_eventManager.getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testReaddServiceTCP() throws Exception {
        this.testAddServiceTCP();
        this.expectUpdateEvent();
        this.m_provisioner.addServiceTCP("MyTCP", 5, 55, 555, 5555, 55555, 505, "AHOY");
        this.checkTCPConfiguration("MyTCP", "MyTCP", 5, 55, 555, 5555, 55555, 505, "AHOY");
        this.verifyEvents();
    }

    private Map<String, Object> checkTCPConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration, int port, String contentCheck) throws Exception {
        Map<String, Object> configParams = this.checkServiceConfiguration(pkgName, svcName, retries, timeout, interval, downtimeInterval, downtimeDuration);
        Assert.assertEquals((Object)port, (Object)configParams.get("port"));
        Assert.assertEquals((Object)contentCheck, (Object)configParams.get("banner"));
        return configParams;
    }

    private Map<String, Object> checkDNSConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration, int port, String lookup) throws Exception {
        Map<String, Object> configParams = this.checkServiceConfiguration(pkgName, svcName, retries, timeout, interval, downtimeInterval, downtimeDuration);
        Assert.assertEquals((Object)port, (Object)configParams.get("port"));
        Assert.assertEquals((Object)lookup, (Object)configParams.get("lookup"));
        return configParams;
    }

    private Map<String, Object> checkDatabaseConfiguration(String pkgName, String svcName, int retries, int timeout, int interval, int downtimeInterval, int downtimeDuration, String username, String password, String driver, String dbUrl) throws Exception {
        Map<String, Object> configParams = this.checkServiceConfiguration(pkgName, svcName, retries, timeout, interval, downtimeInterval, downtimeDuration);
        Assert.assertEquals((Object)username, (Object)configParams.get("user"));
        Assert.assertEquals((Object)password, (Object)configParams.get("password"));
        Assert.assertEquals((Object)driver, (Object)configParams.get("driver"));
        Assert.assertEquals((Object)dbUrl, (Object)configParams.get("url"));
        return configParams;
    }

    static class TestPollerConfigManager
    extends PollerConfigManager {
        String m_xml;

        public TestPollerConfigManager(String xml, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
            super((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), localServer, verifyServer);
            this.save();
        }

        public void update() throws IOException {
            this.m_config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (String)this.m_xml);
            this.setUpInternalData();
        }

        protected void saveXml(String xml) throws IOException {
            this.m_xml = xml;
        }

        public List<InetAddress> getIpList(Package pkg) {
            return new ArrayList<InetAddress>(0);
        }

        public String getXml() {
            return this.m_xml;
        }
    }
}

