/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.TransactionAwareEventForwarder;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/org/opennms/netmgt/utils/applicationContext-testTAEventForwarderTest.xml", "classpath:META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class TransactionAwareEventForwarderTest
implements InitializingBean {
    @Autowired
    private TransactionAwareEventForwarder m_proxy;
    private int m_eventNumber = 1;
    @Autowired
    private MockEventIpcManager m_eventIpcManager;
    @Autowired
    TransactionTemplate m_transTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @After
    public void verifyAnticipated() {
        this.getEventAnticipator().verifyAnticipated(1000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testSendEventsOnCommit() {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Event event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
                event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
                event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
                event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
            }
        });
    }

    @Test
    public void testSendEventsOnRollback() {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                TransactionAwareEventForwarderTest.this.sendEvent();
                status.setRollbackOnly();
            }
        });
    }

    @Test
    public void testTwoTransactions() {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Event event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Event event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
            }
        });
    }

    @Test
    public void testCommitRollbackCommit() {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Event event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.sendEvent();
                status.setRollbackOnly();
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Event event = TransactionAwareEventForwarderTest.this.sendEvent();
                TransactionAwareEventForwarderTest.this.getEventAnticipator().anticipateEvent(event);
            }
        });
    }

    private Event sendEvent() {
        Event event = new EventBuilder("uei.opennms.org/internal/capsd/addInterface", "Test").setNodeid((long)this.m_eventNumber++).getEvent();
        this.m_proxy.sendNow(event);
        return event;
    }

    private EventAnticipator getEventAnticipator() {
        return this.m_eventIpcManager.getEventAnticipator();
    }
}

