/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.Match;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.TcpEventProxy;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.SyslogClient;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.Syslogd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-eventDaemon.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/testEventProxy.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class SyslogdEventdLoadTest
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogdEventdLoadTest.class);
    private EventCounter m_eventCounter;
    private static final String MATCH_PATTERN = "^.*\\s(19|20)\\d\\d([-/.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])(\\s+)(\\S+)(\\s)(\\S.+)";
    private static final int HOST_GROUP = 6;
    private static final int MESSAGE_GROUP = 8;
    private static final HideMessage HIDE_MESSAGE = new HideMessage();
    private static final String DISCARD_UEI = "DISCARD-MATCHING-MESSAGES";
    private static final UeiList UEI_LIST = new UeiList();
    @Autowired
    @Qualifier(value="eventIpcManagerImpl")
    private EventIpcManager m_eventIpcManager;
    @Autowired
    private Eventd m_eventd;
    private Syslogd m_syslogd;
    private final ExecutorService m_executorService = Executors.newCachedThreadPool();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        this.loadSyslogConfiguration("/etc/syslogd-loadtest-configuration.xml");
        this.m_eventCounter = new EventCounter();
        this.m_eventIpcManager.addEventListener((EventListener)this.m_eventCounter);
    }

    @After
    public void tearDown() throws Exception {
        if (this.m_syslogd != null) {
            this.m_syslogd.stop();
        }
        MockLogAppender.assertNoErrorOrGreater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSyslogConfiguration(String configuration) throws IOException, MarshalException, ValidationException {
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)configuration);
            SyslogdConfigFactory cf = new SyslogdConfigFactory(stream);
            SyslogdConfigFactory.setInstance((SyslogdConfig)cf);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private void startSyslogdGracefully() {
        ConvertToEvent.invalidate();
        try {
            this.m_syslogd = new Syslogd();
            this.m_syslogd.init();
            this.m_syslogd.start();
        }
        catch (UndeclaredThrowableException ute) {
            if (ute.getCause() instanceof BindException) {
                LOG.warn("received a bind exception", (Throwable)ute);
            }
            throw ute;
        }
    }

    @Test
    @Transactional
    public void testDefaultSyslogd() throws Exception {
        this.startSyslogdGracefully();
        int eventCount = 100;
        ArrayList<Integer> foos = new ArrayList<Integer>();
        for (int i = 0; i < eventCount; ++i) {
            int eventNum = Double.valueOf(Math.random() * 10000.0).intValue();
            foos.add(eventNum);
        }
        this.m_eventCounter.setAnticipated(eventCount);
        long start = System.currentTimeMillis();
        String testPduFormat = "2010-08-19 localhost foo%d: load test %d on tty1";
        SyslogClient sc = new SyslogClient(null, 10, 7);
        for (int i = 0; i < eventCount; ++i) {
            int foo = (Integer)foos.get(i);
            DatagramPacket pkt = sc.getPacket(7, String.format(testPduFormat, foo, foo));
            WaterfallExecutor.waterfall((Executor)this.m_executorService, (Callable)new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI));
        }
        long mid = System.currentTimeMillis();
        this.m_eventCounter.waitForFinish(120000L);
        long end = System.currentTimeMillis();
        long total = end - start;
        double eventsPerSecond = (double)eventCount * 1000.0 / (double)total;
        System.err.println(String.format("total time: %d, wait time: %d, events per second: %8.4f", total, end - mid, eventsPerSecond));
    }

    @Test
    @Transactional
    public void testRfcSyslog() throws Exception {
        this.loadSyslogConfiguration("/etc/syslogd-rfc-configuration.xml");
        this.startSyslogdGracefully();
        this.m_eventCounter.anticipate();
        InetAddress address = InetAddress.getLocalHost();
        byte[] bytes = "<34>1 2010-08-19T22:14:15.000Z localhost - - - - BOMfoo0: load test 0 on tty1\u0000".getBytes();
        DatagramPacket pkt = new DatagramPacket(bytes, bytes.length, address, 10514);
        WaterfallExecutor.waterfall((Executor)this.m_executorService, (Callable)new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI));
        bytes = "<34>1 2003-10-11T22:14:15.000Z plonk -ev/pts/8\u0000".getBytes();
        pkt = new DatagramPacket(bytes, bytes.length, address, 10514);
        WaterfallExecutor.waterfall((Executor)this.m_executorService, (Callable)new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI));
        this.m_eventCounter.waitForFinish(120000L);
        Assert.assertEquals((long)1L, (long)this.m_eventCounter.getCount());
    }

    @Test
    @Transactional
    public void testNGSyslog() throws Exception {
        this.loadSyslogConfiguration("/etc/syslogd-syslogng-configuration.xml");
        this.startSyslogdGracefully();
        this.m_eventCounter.anticipate();
        InetAddress address = InetAddress.getLocalHost();
        byte[] bytes = "<34>main: 2010-08-19 localhost foo0: load test 0 on tty1\u0000".getBytes();
        DatagramPacket pkt = new DatagramPacket(bytes, bytes.length, address, 10514);
        WaterfallExecutor.waterfall((Executor)this.m_executorService, (Callable)new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI));
        bytes = "<34>monkeysatemybrain!\u0000".getBytes();
        pkt = new DatagramPacket(bytes, bytes.length, address, 10514);
        WaterfallExecutor.waterfall((Executor)this.m_executorService, (Callable)new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI));
        this.m_eventCounter.waitForFinish(120000L);
        Assert.assertEquals((long)1L, (long)this.m_eventCounter.getCount());
    }

    @Test
    @Transactional
    public void testEventd() throws Exception {
        this.m_eventd.start();
        EventProxy ep = SyslogdEventdLoadTest.createEventProxy();
        Log eventLog = new Log();
        Events events = new Events();
        eventLog.setEvents(events);
        int eventCount = 10000;
        this.m_eventCounter.setAnticipated(eventCount);
        for (int i = 0; i < eventCount; ++i) {
            int eventNum = Double.valueOf(Math.random() * 300.0).intValue();
            String expectedUei = "uei.example.org/syslog/loadTest/foo" + eventNum;
            EventBuilder eb = new EventBuilder(expectedUei, "SyslogdLoadTest");
            Event thisEvent = eb.setInterface(InetAddressUtils.addr((String)"127.0.0.1")).setLogDest("logndisplay").setLogMessage("A load test has been received as a Syslog Message").getEvent();
            events.addEvent(thisEvent);
        }
        long start = System.currentTimeMillis();
        ep.send(eventLog);
        long mid = System.currentTimeMillis();
        this.m_eventCounter.waitForFinish(120000L);
        long end = System.currentTimeMillis();
        this.m_eventd.stop();
        long total = end - start;
        double eventsPerSecond = (double)eventCount * 1000.0 / (double)total;
        System.err.println(String.format("total time: %d, wait time: %d, events per second: %8.4f", total, end - mid, eventsPerSecond));
    }

    private static EventProxy createEventProxy() throws UnknownHostException {
        String proxyHostName = "127.0.0.1";
        String proxyHostPort = "5837";
        String proxyHostTimeout = String.valueOf(2000);
        InetAddress proxyAddr = null;
        TcpEventProxy proxy = null;
        proxyAddr = InetAddressUtils.addr((String)proxyHostName);
        proxy = proxyAddr == null ? new TcpEventProxy() : new TcpEventProxy(new InetSocketAddress(proxyAddr, Integer.parseInt(proxyHostPort)), Integer.parseInt(proxyHostTimeout));
        return proxy;
    }

    static {
        for (int i = 0; i < 10000; ++i) {
            UeiMatch ueiMatch = new UeiMatch();
            Match match = new Match();
            match.setType("regex");
            match.setExpression(String.format(".*foo%d: .*load test (\\S+) on ((pts\\/\\d+)|(tty\\d+)).*", i));
            ueiMatch.setMatch(match);
            ueiMatch.setUei(String.format("uei.example.org/syslog/loadTest/foo%d", i));
            UEI_LIST.addUeiMatch(ueiMatch);
        }
    }

    public static class EventCounter
    implements EventListener {
        private AtomicInteger m_eventCount = new AtomicInteger(0);
        private int m_expectedCount = 0;

        public String getName() {
            return "eventCounter";
        }

        public void waitForFinish(long time) {
            long start = System.currentTimeMillis();
            while (this.getCount() < this.m_expectedCount) {
                if (System.currentTimeMillis() - start > time) {
                    LOG.warn("waitForFinish timeout ({}) reached", (Object)time);
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOG.warn("thread was interrupted while sleeping", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void setAnticipated(int eventCount) {
            this.m_expectedCount = eventCount;
        }

        public int getCount() {
            return this.m_eventCount.get();
        }

        public void anticipate() {
            ++this.m_expectedCount;
        }

        public void onEvent(Event e) {
            int current = this.m_eventCount.incrementAndGet();
            if (current % 100 == 0) {
                System.err.println(current + " < " + this.m_expectedCount);
            }
        }
    }
}

