/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.syslogd.BroadcastEventProcessor;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogProcessor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-eventDaemon.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/testEventProxy.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class SyslogdBroadcastEventProcessorTest {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogdBroadcastEventProcessorTest.class);
    private static final String MATCH_PATTERN = "^.*\\s(19|20)\\d\\d([-/.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])(\\s+)(\\S+)(\\s)(\\S.+)";
    private static final int HOST_GROUP = 6;
    private static final int MESSAGE_GROUP = 8;
    private static final HideMessage HIDE_MESSAGE = new HideMessage();
    private static final String DISCARD_UEI = "DISCARD-MATCHING-MESSAGES";
    private static final UeiList UEI_LIST = new UeiList();

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        this.loadSyslogConfiguration("/etc/syslogd-rfc-configuration.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSyslogConfiguration(String configuration) throws IOException, MarshalException, ValidationException {
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)configuration);
            SyslogdConfigFactory cf = new SyslogdConfigFactory(stream);
            SyslogdConfigFactory.setInstance((SyslogdConfig)cf);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    @Test
    @Transactional
    public void testUpdateSyslogIPMgr() throws Exception {
        byte[] bytes = "<34>1 2010-08-19T22:14:15.000Z localhost - - - - BOMfoo0: load test 0 on tty1\u0000".getBytes();
        DatagramPacket pkt = new DatagramPacket(bytes, bytes.length, InetAddressUtils.ONE_TWENTY_SEVEN, 10514);
        BroadcastEventProcessor eventProcessor = new BroadcastEventProcessor();
        SyslogConnection connection = new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI);
        SyslogProcessor processor = connection.call();
        Assert.assertTrue((String)("Node ID was unexpectedly present: " + processor.getConvertToEvent().getEvent().getNodeid()), (processor.getConvertToEvent().getEvent().getNodeid() < 1L ? 1 : 0) != 0);
        EventBuilder builder = new EventBuilder("uei.opennms.org/nodes/nodeGainedInterface", this.getClass().getSimpleName());
        builder.setNodeid(5467L);
        builder.setInterface(InetAddressUtils.ONE_TWENTY_SEVEN);
        eventProcessor.onEvent(builder.getEvent());
        connection = new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI);
        processor = connection.call();
        Assert.assertEquals((String)("Node ID was not present: " + processor.getConvertToEvent().getEvent().getNodeid()), (Object)5467L, (Object)processor.getConvertToEvent().getEvent().getNodeid());
        builder = new EventBuilder("uei.opennms.org/nodes/interfaceDeleted", this.getClass().getSimpleName());
        builder.setNodeid(5467L);
        builder.setInterface(InetAddressUtils.ONE_TWENTY_SEVEN);
        eventProcessor.onEvent(builder.getEvent());
        connection = new SyslogConnection(pkt, MATCH_PATTERN, 6, 8, UEI_LIST, HIDE_MESSAGE, DISCARD_UEI);
        processor = connection.call();
        Assert.assertTrue((String)("Node ID was unexpectedly present: " + processor.getConvertToEvent().getEvent().getNodeid()), (processor.getConvertToEvent().getEvent().getNodeid() < 1L ? 1 : 0) != 0);
    }
}

