/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogClient {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogClient.class);
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_PRIMASK = 7;
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 120;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final int LOG_FACMASK = 1016;
    public static final int LOG_PID = 1;
    public static final int LOG_CONS = 2;
    public static final int LOG_NDELAY = 8;
    public static final int LOG_NOWAIT = 16;
    public static final int PORT = 10514;
    private String ident;
    private int facility;
    private InetAddress address;
    private DatagramSocket socket;

    public SyslogClient(String ident, int logopt, int facility) throws UnknownHostException {
        this.ident = ident == null ? Thread.currentThread().getName() : ident;
        this.facility = facility;
        this.address = InetAddressUtils.getLocalHostAddress();
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException e) {
            LOG.warn("Unable to create datagram socket.", (Throwable)e);
        }
    }

    public void syslog(int priority, String msg) {
        DatagramPacket packet = this.getPacket(priority, msg);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            LOG.warn("Exception sending data.", (Throwable)e);
        }
    }

    private static int makePriorityCode(int facility, int priority) {
        return facility & 0x3F8 | priority;
    }

    public DatagramPacket getPacket(int priority, String msg) {
        byte[] bytes = SyslogClient.getPacketPayload(this.facility, this.ident, priority, msg);
        return new DatagramPacket(bytes, bytes.length, this.address, 10514);
    }

    public static byte[] getPacketPayload(int facility, String ident, int priority, String msg) {
        int pricode = SyslogClient.makePriorityCode(facility, priority);
        Integer priObj = pricode;
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(Integer.toString(priObj)).append(">");
        sb.append(ident).append(": ").append(msg).append("\u0000");
        return sb.toString().getBytes();
    }
}

