/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.syslogd.SyslogClient;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.Syslogd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false, tempDbClass=MockDatabase.class)
@Transactional
public class Nms4335Test
implements InitializingBean {
    String m_localhost = "127.0.0.1";
    private Syslogd m_syslogd;
    @Autowired
    private MockEventIpcManager m_eventIpcManager;
    private final ExecutorService m_executorServices = Executors.newCachedThreadPool();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Before
    public void setUp() throws Exception {
        block3: {
            MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
            ByteArrayInputStream stream = null;
            try {
                String config = "<?xml version=\"1.0\"?> \n<syslogd-configuration> \n    <configuration \n            syslog-port=\"10514\" \n            new-suspect-on-message=\"false\" \n            forwarding-regexp=\"^((.+?) (.*))\\n?$\" \n            matching-group-host=\"2\" \n            matching-group-message=\"3\" \n            discard-uei=\"DISCARD-MATCHING-MESSAGES\" \n            /> \n\n    <!-- Use the following to convert UEI ad-hoc --> \n    <ueiList> \n        <ueiMatch> \n            <match type=\"substr\" expression=\"CRISCO\"/> \n            <uei>CISCO</uei> \n        </ueiMatch> \n        <ueiMatch> \n            <match type=\"regex\" expression=\".*su:auth.*authentication failure.*\"/> \n            <uei>uei.opennms.org/syslog/pam/su/suFailure</uei> \n        </ueiMatch> \n        <!-- Use the following to discard a syslog message without ever creating an event for it. \n             If you change the value of \"discard-uei\" above, you must change the UEI used here to match. --> \n        <ueiMatch> \n            <match type=\"substr\" expression=\"JUNK\"/> \n            <uei>DISCARD-MATCHING-MESSAGES</uei> \n        </ueiMatch> \n    </ueiList> \n\n    <!-- Use the following to remove a syslog message from the event-trail --> \n\n    <hideMessage> \n        <hideMatch> \n            <match type=\"substr\" expression=\"SECRET\"/> \n        </hideMatch> \n        <hideMatch> \n            <match type=\"regex\" expression=\".*(double|triple)secret.*\"/> \n        </hideMatch> \n    </hideMessage> \n\n</syslogd-configuration>\n";
                stream = new ByteArrayInputStream("<?xml version=\"1.0\"?> \n<syslogd-configuration> \n    <configuration \n            syslog-port=\"10514\" \n            new-suspect-on-message=\"false\" \n            forwarding-regexp=\"^((.+?) (.*))\\n?$\" \n            matching-group-host=\"2\" \n            matching-group-message=\"3\" \n            discard-uei=\"DISCARD-MATCHING-MESSAGES\" \n            /> \n\n    <!-- Use the following to convert UEI ad-hoc --> \n    <ueiList> \n        <ueiMatch> \n            <match type=\"substr\" expression=\"CRISCO\"/> \n            <uei>CISCO</uei> \n        </ueiMatch> \n        <ueiMatch> \n            <match type=\"regex\" expression=\".*su:auth.*authentication failure.*\"/> \n            <uei>uei.opennms.org/syslog/pam/su/suFailure</uei> \n        </ueiMatch> \n        <!-- Use the following to discard a syslog message without ever creating an event for it. \n             If you change the value of \"discard-uei\" above, you must change the UEI used here to match. --> \n        <ueiMatch> \n            <match type=\"substr\" expression=\"JUNK\"/> \n            <uei>DISCARD-MATCHING-MESSAGES</uei> \n        </ueiMatch> \n    </ueiList> \n\n    <!-- Use the following to remove a syslog message from the event-trail --> \n\n    <hideMessage> \n        <hideMatch> \n            <match type=\"substr\" expression=\"SECRET\"/> \n        </hideMatch> \n        <hideMatch> \n            <match type=\"regex\" expression=\".*(double|triple)secret.*\"/> \n        </hideMatch> \n    </hideMessage> \n\n</syslogd-configuration>\n".getBytes());
                SyslogdConfigFactory.setInstance((SyslogdConfig)new SyslogdConfigFactory((InputStream)stream));
                if (stream == null) break block3;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        this.m_syslogd = new Syslogd();
        this.m_syslogd.init();
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoErrorOrGreater();
    }

    @Test
    public void testAuthFailureShouldLog() throws Exception {
        this.doMessageTest("Jan 7 12:42:46 192.168.0.1 su[25856]: pam_unix(su:auth): authentication failure; logname=jeffg uid=1004 euid=0 tty=pts/1 ruser=jeffg rhost= user=root", "192.168.0.1", "uei.opennms.org/syslog/pam/su/suFailure", "pam_unix(su:auth): authentication failure; logname=jeffg uid=1004 euid=0 tty=pts/1 ruser=jeffg rhost= user=root");
    }

    @Test
    @Ignore
    public void testAuthFailureShouldNotLog() throws Exception {
        this.doMessageTest("Jan 7 12:42:48 cartman su[25856]: pam_authenticate: Authentication failure", "192.168.0.1", "uei.opennms.org/blah", "");
    }

    private List<Event> doMessageTest(String testPDU, String expectedHost, String expectedUEI, String expectedLogMsg) throws UnknownHostException, InterruptedException, ExecutionException {
        this.startSyslogdGracefully();
        EventBuilder expectedEventBldr = new EventBuilder(expectedUEI, "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)expectedHost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage(expectedLogMsg);
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener((EventListener)ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient sc = new SyslogClient(null, 10, 24);
        DatagramPacket pkt = sc.getPacket(7, testPDU);
        SyslogdConfig config = SyslogdConfigFactory.getInstance();
        WaterfallExecutor.waterfall((Executor)this.m_executorServices, (Callable)new SyslogConnection(pkt, config.getForwardingRegexp(), config.getMatchingGroupHost(), config.getMatchingGroupMessage(), config.getUeiList(), config.getHideMessages(), config.getDiscardUei()));
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
        Event receivedEvent = (Event)ea.getAnticipatedEventsRecieved().get(0);
        Assert.assertEquals((String)"Log messages do not match", (Object)expectedLogMsg, (Object)receivedEvent.getLogmsg().getContent());
        return ea.getAnticipatedEventsRecieved();
    }

    private void startSyslogdGracefully() {
        block2: {
            try {
                this.m_syslogd.start();
            }
            catch (UndeclaredThrowableException ute) {
                if (ute.getCause() instanceof BindException) break block2;
                throw ute;
            }
        }
    }
}

