/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentSkipListMap;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.JUnitHttpServerExecutionListener;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.mock.MonitorTestUtils;
import org.opennms.netmgt.poller.monitors.HttpMonitor;
import org.opennms.netmgt.poller.monitors.HttpsMonitor;
import org.opennms.netmgt.utils.DnsUtils;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
@DirtiesContext
public class HttpMonitorTest {
    private boolean m_runTests = true;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testPollStatusReason() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        InetAddress address = DnsUtils.resolveHostname((String)"www.opennms.org");
        Assert.assertNotNull((String)"Failed to resolved address: www.opennms.org", (Object)address);
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (String)"www.opennms.org", (InetAddress)address, (String)"HTTP");
        p.setKey("port");
        p.setValue("3020");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=0)
    public void testResponseRange() throws UnknownHostException {
        this.callTestResponseRange(false);
    }

    @Test
    @JUnitHttpServer(port=0)
    public void testResponseRangeIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestResponseRange(true);
    }

    public void callTestResponseRange(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "1");
        m.put("timeout", "500");
        m.put("response", "100-199");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        m.put("response", "100,200,302,400-500");
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        m.put("response", "*");
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @Ignore
    public void testTimeout() throws UnknownHostException {
        this.callTestTimeout(false);
    }

    @Test
    public void testTimeoutIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestTimeout(true);
    }

    public void callTestTimeout(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (InetAddress)(preferIPv6 ? InetAddressUtils.UNPINGABLE_ADDRESS_IPV6 : InetAddressUtils.UNPINGABLE_ADDRESS), (String)"HTTP");
        m.put("port", "12345");
        m.put("retry", "1");
        m.put("timeout", "500");
        m.put("response", "100-199");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        String reason = status.getReason();
        MockUtil.println((String)("Reason: " + reason));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)reason);
        Assert.assertTrue((String)(reason + "should be 'HTTP connection timeout' or 'No route to host'"), (reason.contains("HTTP connection timeout") || reason.contains("No route to host") ? 1 : 0) != 0);
    }

    @Test
    @JUnitHttpServer
    public void testMatchingTextInResponse() throws UnknownHostException {
        this.callTestMatchingTextInResponse(false);
    }

    @Test
    @JUnitHttpServer
    public void testMatchingTextInResponseIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestMatchingTextInResponse(true);
    }

    public void callTestMatchingTextInResponse(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "0");
        m.put("timeout", "500");
        m.put("response", "100-499");
        m.put("verbose", "true");
        m.put("host-name", "localhost");
        m.put("url", "/");
        m.put("response-text", "opennmsrulz");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        m.put("response-text", "written by monkeys");
        MockUtil.println((String)"\nliteral text check: \"written by monkeys\"");
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        m.put("response-text", "~.*[Tt]est HTTP [Ss]erver.*");
        MockUtil.println((String)"\nregex check: \".*[Tt]est HTTP [Ss]erver.*\"");
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    public void testBase64Encoding() {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        m.put("basic-authentication", "Aladdin:open sesame");
        Assert.assertEquals((Object)"QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (Object)HttpMonitor.determineBasicAuthentication(m));
        Assert.assertFalse((boolean)"QWxhZGRpbjpvcZVuIHNlc2FtZQ==".equals(HttpMonitor.determineBasicAuthentication(m)));
    }

    @Test
    @JUnitHttpServer(basicAuth=true)
    public void testBasicAuthentication() throws UnknownHostException {
        this.callTestBasicAuthentication(false);
    }

    @Test
    @JUnitHttpServer(basicAuth=true)
    public void testBasicAuthenticationIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestBasicAuthentication(true);
    }

    public void callTestBasicAuthentication(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)1, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "0");
        m.put("timeout", "500");
        m.put("response", "100-302");
        m.put("verbose", "true");
        m.put("host-name", "localhost");
        m.put("url", "/");
        m.put("basic-authentication", "admin:istrator");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        m.put("basic-authentication", "admin:flagrator");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(https=true, basicAuth=true)
    public void testBasicAuthenticationWithHttps() throws UnknownHostException {
        this.callTestBasicAuthenticationWithHttps(false);
    }

    @Test
    @JUnitHttpServer(https=true, basicAuth=true)
    public void testBasicAuthenticationWithHttpsIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestBasicAuthenticationWithHttps(true);
    }

    public void callTestBasicAuthenticationWithHttps(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        PollStatus status = null;
        HttpsMonitor monitor = new HttpsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)1, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTPS");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "1");
        m.put("timeout", "500");
        m.put("response", "100-302");
        m.put("verbose", "true");
        m.put("host-name", "localhost");
        m.put("url", "/index.html");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertEquals((Object)("HTTP response value: 401. Expecting: 100-302./Ports: " + port), (Object)status.getReason());
        m.put("basic-authentication", "admin:istrator");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer
    public void testWithUrl() throws UnknownHostException {
        this.callTestWithUrl(false);
    }

    @Test
    @JUnitHttpServer
    public void testWithUrlIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestWithUrl(true);
    }

    public void callTestWithUrl(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "0");
        m.put("timeout", "500");
        m.put("response", "100-499");
        m.put("verbose", "true");
        m.put("host-name", "localhost");
        m.put("url", "/twinkies.html");
        m.put("response-text", "~.*Don.t you love twinkies..*");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer
    public void testWithInvalidNodelabelHostName() throws UnknownHostException {
        this.callTestWithInvalidNodelabelHostName(false);
    }

    @Test
    @JUnitHttpServer
    public void testWithInvalidNodelabelHostNameIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestWithInvalidNodelabelHostName(true);
    }

    public void callTestWithInvalidNodelabelHostName(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        svc.setNodeLabel("bad.virtual.host.example.com");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "0");
        m.put("timeout", "500");
        m.put("response", "404");
        m.put("verbose", "true");
        m.put("nodelabel-host-name", "true");
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(vhosts={"opennms.com"})
    public void testPollInInvalidVirtualDomain() throws UnknownHostException {
        this.callTestPollInInvalidVirtualDomain(false);
    }

    @Test
    @JUnitHttpServer(vhosts={"opennms.com"})
    public void testPollInInvalidVirtualDomainIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestPollInInvalidVirtualDomain(true);
    }

    public void callTestPollInInvalidVirtualDomain(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "0");
        m.put("timeout", "500");
        m.put("host-name", "www.google.com");
        m.put("url", "/twinkies.html");
        m.put("response-text", "~.*twinkies.*");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        Assert.assertEquals((String)"poll status available", (long)2L, (long)status.getStatusCode());
    }

    @Test
    @JUnitHttpServer(vhosts={"www.opennms.org"})
    public void testPollValidVirtualDomain() throws UnknownHostException {
        this.callTestPollValidVirtualDomain(false);
    }

    @Test
    @JUnitHttpServer(vhosts={"www.opennms.org"})
    public void testPollValidVirtualDomainIPv6() throws UnknownHostException {
        Assume.assumeTrue((!Boolean.getBoolean("skipIpv6Tests") ? 1 : 0) != 0);
        this.callTestPollValidVirtualDomain(true);
    }

    public void callTestPollValidVirtualDomain(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)preferIPv6), (String)"HTTP");
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        m.put("port", String.valueOf(port));
        m.put("retry", "1");
        m.put("timeout", "500");
        m.put("host-name", "www.opennms.org");
        m.put("url", "/twinkies.html");
        m.put("response-text", "~.*twinkies.*");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        Assert.assertEquals((String)"poll status not available", (long)1L, (long)status.getStatusCode());
    }

    @Test
    @JUnitHttpServer
    public void testNMS2702() throws UnknownHostException {
        HttpMonitor monitor = new HttpMonitor();
        ConcurrentSkipListMap<String, String> parameters = new ConcurrentSkipListMap<String, String>();
        int port = JUnitHttpServerExecutionListener.getPort();
        if (port <= 0) {
            throw new IllegalStateException("Unable to determine what port the HTTP server started on!");
        }
        parameters.put("port", String.valueOf(port));
        parameters.put("url", "/test-NMS2702.html");
        parameters.put("retry", "1");
        parameters.put("timeout", "500");
        parameters.put("verbose", "true");
        parameters.put("response-text", "~.*OK.*");
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)false), (String)"HTTP");
        PollStatus status = monitor.poll((MonitoredService)svc, parameters);
        Assert.assertTrue((boolean)status.isAvailable());
        parameters.put("response-text", "~.*Jetty.*");
        svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)false), (String)"HTTP");
        status = monitor.poll((MonitoredService)svc, parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }
}

