/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.Querier;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.api.PathOutageDao;
import org.opennms.netmgt.dao.support.NullRrdStrategy;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockOutageConfig;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.poller.DefaultPollContext;
import org.opennms.netmgt.poller.PathOutageManagerDaoImpl;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-pollerdTest.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
@Transactional
public class PathOutageManagerDaoTest
implements TemporaryDatabaseAware<MockDatabase> {
    private static final String CAPSD_CONFIG = "\n<capsd-configuration max-suspect-thread-pool-size=\"2\" max-rescan-thread-pool-size=\"3\"\n   delete-propagation-enabled=\"true\">\n   <protocol-plugin protocol=\"ICMP\" class-name=\"org.opennms.netmgt.capsd.plugins.LdapPlugin\"/>\n   <protocol-plugin protocol=\"SMTP\" class-name=\"org.opennms.netmgt.capsd.plugins.LdapPlugin\"/>\n   <protocol-plugin protocol=\"HTTP\" class-name=\"org.opennms.netmgt.capsd.plugins.LdapPlugin\"/>\n</capsd-configuration>\n";
    private MockNetwork m_network;
    private MockDatabase m_db;
    private MockPollerConfig m_pollerConfig;
    @Autowired
    private QueryManager m_queryManager;
    @Autowired
    private PathOutageDao m_pathOutageDao;
    @Autowired
    private PathOutageManagerDaoImpl m_pathOutageManager;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        MockUtil.println((String)"------------ Begin Test  --------------------------");
        MockLogAppender.setupLogging();
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addPathOutage(1, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addService("SNMP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addService("SMTP");
        this.m_network.addService("SNMP");
        this.m_network.addNode(3, "Firewall");
        this.m_network.addInterface("192.168.1.4");
        this.m_network.addService("SMTP");
        this.m_network.addPathOutage(3, InetAddressUtils.addr((String)"192.168.1.4"), "SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.5");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(4, "DownNode");
        this.m_network.addInterface("192.168.1.6");
        this.m_network.addService("SNMP");
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)this.m_db);
        this.m_pollerConfig = new MockPollerConfig(this.m_network);
        this.m_pollerConfig.setNextOutageIdSql(this.m_db.getNextOutageIdStatement());
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setCriticalService("ICMP");
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(this.m_network);
        this.m_pollerConfig.addPackage("TestPkg2");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(2000L);
        this.m_pollerConfig.addService(this.m_network.getService(2, "192.168.1.3", "HTTP"));
        DefaultPollContext pollContext = new DefaultPollContext();
        pollContext.setLocalHostName("localhost");
        pollContext.setName("Test.DefaultPollContext");
        pollContext.setPollerConfig((PollerConfig)this.m_pollerConfig);
        pollContext.setQueryManager(this.m_queryManager);
        PollableNetwork network = new PollableNetwork((PollContext)pollContext);
        MockOutageConfig config = new MockOutageConfig();
        config.setGetNextOutageID(this.m_db.getNextOutageIdStatement());
        RrdUtils.setStrategy((RrdStrategy)new NullRrdStrategy());
    }

    @After
    public void tearDown() throws Exception {
        PathOutageManagerDaoTest.sleep(200L);
        MockUtil.println((String)"------------ End Test  --------------------------");
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void createOutages(MockElement element, final Event event) {
        MockVisitorAdapter outageCreater = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if (svc.getMgmtStatus().equals((Object)MockService.SvcMgmtStatus.ACTIVE)) {
                    PathOutageManagerDaoTest.this.m_db.createOutage(svc, event);
                }
            }
        };
        element.visit((MockVisitor)outageCreater);
    }

    private void bringDownCritSvcs(MockElement element) {
        MockVisitorAdapter markCritSvcDown = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if ("ICMP".equals(svc.getSvcName())) {
                    svc.bringDown();
                }
            }
        };
        element.visit((MockVisitor)markCritSvcDown);
    }

    @Test
    public void test() throws SQLException {
        String[] ar = this.m_pathOutageManager.getLabelAndStatus("1", null);
        Assert.assertEquals((Object)"Router", (Object)ar[0]);
        Assert.assertEquals((Object)"Normal", (Object)ar[1]);
        Assert.assertEquals((Object)"All Services Up", (Object)ar[2]);
        String[] cr = this.m_pathOutageManager.getLabelAndStatus("3", null);
        Assert.assertEquals((Object)"Firewall", (Object)cr[0]);
        Assert.assertEquals((Object)"Normal", (Object)cr[1]);
        Assert.assertEquals((Object)"All Services Up", (Object)cr[2]);
        Set lno = this.m_pathOutageManager.getNodesInPath("192.168.1.1", "ICMP");
        Assert.assertEquals((Object)new Integer(1), lno.iterator().next());
        Set vno = this.m_pathOutageManager.getNodesInPath("192.168.1.4", "SMTP");
        Assert.assertEquals((Object)new Integer(3), vno.iterator().next());
        List all = this.m_pathOutageManager.getAllCriticalPaths();
        Assert.assertEquals((Object)"192.168.1.1", (Object)((String[])all.get(0))[0]);
        Assert.assertEquals((Object)"ICMP", (Object)((String[])all.get(0))[1]);
        Assert.assertEquals((Object)"192.168.1.4", (Object)((String[])all.get(1))[0]);
        Assert.assertEquals((Object)"SMTP", (Object)((String[])all.get(1))[1]);
        String[] dat = this.m_pathOutageManager.getCriticalPathData("192.168.1.1", "ICMP");
        Assert.assertEquals((Object)"Router", (Object)dat[0]);
        Assert.assertEquals((Object)"1", (Object)dat[1]);
        Assert.assertEquals((Object)"1", (Object)dat[2]);
        Assert.assertEquals((Object)"Cleared", (Object)dat[3]);
        String mm = this.m_pathOutageManager.getPrettyCriticalPath(1);
        Assert.assertEquals((Object)"192.168.1.1 ICMP", (Object)mm);
        String nn = this.m_pathOutageManager.getPrettyCriticalPath(3);
        Assert.assertEquals((Object)"192.168.1.4 SMTP", (Object)nn);
        String[] pa = this.m_pathOutageManager.getCriticalPath(1);
        Assert.assertEquals((Object)"192.168.1.1", (Object)pa[0]);
        Assert.assertEquals((Object)"ICMP", (Object)pa[1]);
        String[] nc = this.m_pathOutageManager.getCriticalPath(3);
        Assert.assertEquals((Object)"192.168.1.4", (Object)nc[0]);
        Assert.assertEquals((Object)"SMTP", (Object)nc[1]);
        Set test = this.m_pathOutageManager.getDependencyNodesByCriticalPath("192.168.1.1");
        Assert.assertEquals((long)1L, (long)test.size());
        Set less = this.m_pathOutageManager.getDependencyNodesByNodeId(3);
        Assert.assertEquals((long)1L, (long)less.size());
    }

    @Ignore
    @Test
    public void testMethod500Times() throws SQLException {
        for (int i = 0; i < 500; ++i) {
            this.test();
        }
    }

    class OutageChecker
    extends Querier {
        private Event m_lostSvcEvent;
        private Timestamp m_lostSvcTime;
        private MockService m_svc;
        private Event m_regainedSvcEvent;
        private Timestamp m_regainedSvcTime;

        OutageChecker(MockService svc, Event lostSvcEvent) throws Exception {
            this(svc, lostSvcEvent, null);
        }

        OutageChecker(MockService svc, Event lostSvcEvent, Event regainedSvcEvent) {
            super((DataSource)PathOutageManagerDaoTest.this.m_db, "select * from outages where nodeid = ? and ipAddr = ? and serviceId = ?");
            this.m_svc = svc;
            this.m_lostSvcEvent = lostSvcEvent;
            this.m_lostSvcTime = PathOutageManagerDaoTest.this.m_db.convertEventTimeToTimeStamp(this.m_lostSvcEvent.getTime());
            this.m_regainedSvcEvent = regainedSvcEvent;
            if (this.m_regainedSvcEvent != null) {
                this.m_regainedSvcTime = PathOutageManagerDaoTest.this.m_db.convertEventTimeToTimeStamp(this.m_regainedSvcEvent.getTime());
            }
        }

        public void processRow(ResultSet rs) throws SQLException {
            Assert.assertEquals((long)this.m_svc.getNodeId(), (long)rs.getInt("nodeId"));
            Assert.assertEquals((Object)this.m_svc.getIpAddr(), (Object)rs.getString("ipAddr"));
            Assert.assertEquals((long)this.m_svc.getId(), (long)rs.getInt("serviceId"));
            Assert.assertEquals((Object)this.m_lostSvcEvent.getDbid(), (Object)rs.getInt("svcLostEventId"));
            Assert.assertEquals((Object)this.m_lostSvcTime, (Object)rs.getTimestamp("ifLostService"));
            Assert.assertEquals((Object)this.getRegainedEventId(), (Object)rs.getObject("svcRegainedEventId"));
            Assert.assertEquals((Object)this.m_regainedSvcTime, (Object)rs.getTimestamp("ifRegainedService"));
        }

        private Integer getRegainedEventId() {
            if (this.m_regainedSvcEvent == null) {
                return null;
            }
            return (int)this.m_regainedSvcEvent.getDbid();
        }
    }
}

