/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NotificationsTestCase;
import org.opennms.netmgt.xml.event.Event;

public class BroadcastEventProcessorTest
extends NotificationsTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_anticipator.setExpectedDifference(3000L);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown(true);
    }

    @Test
    public void testExpandNotifParms() throws Exception {
        String expandResult = NotificationManager.expandNotifParms((String)"%foo%", new TreeMap());
        Assert.assertEquals((Object)"%foo%", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"%foo%", Collections.singletonMap("foo", "bar"));
        Assert.assertEquals((Object)"%foo%", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"Notice #%noticeid% RESOLVED: ", Collections.singletonMap("noticeid", "999"));
        Assert.assertEquals((Object)"Notice #999 RESOLVED: ", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"RESOLVED: ", Collections.singletonMap("noticeid", "999"));
        Assert.assertEquals((Object)"RESOLVED: ", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"Notice %noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", new TreeMap());
        Assert.assertEquals((Object)"Notice %noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Object)expandResult);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/threshold/highThresholdExceeded", "testExpandNotifParms");
        bldr.setDescription("High threshold exceeded for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
        bldr.setLogMessage("High threshold exceeded for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
        bldr.setNodeid(0L);
        bldr.setInterface(InetAddressUtils.addr((String)"0.0.0.0"));
        bldr.addParam("ds", "dsk-usr-pcent");
        bldr.addParam("value", "Crap! There's only 15% free on the SAN and we need 20%! RUN AWAY!");
        bldr.addParam("threshold", "");
        bldr.addParam("trigger", "");
        bldr.addParam("rearm", "");
        bldr.addParam("label", "");
        bldr.addParam("ifIndex", "");
        Notification[] notifications = null;
        notifications = this.m_notificationManager.getNotifForEvent(null);
        Assert.assertNull((Object)notifications);
        notifications = this.m_notificationManager.getNotifForEvent(bldr.getEvent());
        Assert.assertNotNull((Object)notifications);
        Assert.assertEquals((long)1L, (long)notifications.length);
        Map paramMap = BroadcastEventProcessor.buildParameterMap((Notification)notifications[0], (Event)bldr.getEvent(), (int)9999);
        Assert.assertEquals((Object)"High disk Threshold exceeded on 0.0.0.0, dsk-usr-pcent with Crap! There's only 15% free on the SAN and we need 20%! RUN AWAY!", paramMap.get("-tm"));
        expandResult = NotificationManager.expandNotifParms((String)"Notice #%noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Map)paramMap);
        Assert.assertEquals((Object)"Notice #9999: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Object)expandResult);
    }

    @Test
    public void testExpandNoticeId_Bug1745() throws Exception {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Event event = MockEventUtil.createServiceEvent((String)"Test", (String)"uei.opennms.org/test/noticeIdExpansion", (MockService)svc, null);
        String antNID = Integer.toString(this.m_notificationManager.getNoticeId() + 1);
        Date testDate = new Date();
        long finishedNotifs = this.anticipateNotificationsForGroup("notification '" + antNID + "'", "Notification '" + antNID + "'", "InitialGroup", testDate, 0L);
        MockEventUtil.setEventTime((Event)event, (Date)testDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.verifyAnticipated(finishedNotifs, 1000L);
    }
}

