/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.nb;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.nb.NmsNetworkBuilder;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-capsd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/capsdTest.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.provisiond.enableDiscovery=false"})
@JUnitTemporaryDatabase
public class LinkdTestCapsdNetworkBuilder
extends NmsNetworkBuilder
implements InitializingBean {
    @Autowired
    private Capsd m_capsd;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.hibernate.SQL", "WARN");
        MockLogAppender.setupLogging((Properties)p);
        Assert.assertTrue((String)"Capsd must not be null", (this.m_capsd != null ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.108.191.171", port=161, resource="classpath:linkd/nms0002ciscoalcatel/s-se-malm-nobe-561.txt")})
    @Transactional
    public final void testCapsd() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("10.108.191.171");
        this.printNode("10.108.191.171", "SSeMalmNobe");
        this.m_capsd.stop();
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.1", port=161, resource="classpath:linkd/nms7467/192.0.2.1-walk.txt")})
    @Transactional
    public final void testCapsdA() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("192.0.2.1");
        this.printNode("192.0.2.1", "CISCO_C870");
        this.m_capsd.stop();
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt")})
    @Transactional
    public final void testCapsdB() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("192.168.239.51");
        this.printNode("192.168.239.51", "FROH");
        this.m_capsd.stop();
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt")})
    @Transactional
    public final void testCapsdC() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("192.168.239.62");
        this.printNode("192.168.239.62", "OEDIPUS");
        this.m_capsd.stop();
    }

    @Test
    @Ignore
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    @Transactional
    public final void testCapsdD() throws MarshalException, ValidationException, IOException {
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface("192.168.239.54");
        this.printNode("192.168.239.54", "SIEGFRIE");
        this.m_capsd.stop();
    }

    protected final void printNode(String ipAddr, String prefix) {
        List ips = this.m_ipInterfaceDao.findByIpAddress(ipAddr);
        Assert.assertTrue((String)"Has only one ip interface", (ips.size() == 1 ? 1 : 0) != 0);
        OnmsIpInterface ip = (OnmsIpInterface)ips.get(0);
        for (OnmsIpInterface ipinterface : ip.getNode().getIpInterfaces()) {
            if (ipinterface.getIfIndex() == null) continue;
            this.printipInterface(prefix, ipinterface);
        }
        for (OnmsSnmpInterface snmpinterface : ip.getNode().getSnmpInterfaces()) {
            this.printSnmpInterface(prefix, snmpinterface);
        }
    }

    protected void printipInterface(String nodeStringId, OnmsIpInterface ipinterface) {
        System.out.println(nodeStringId + "_IP_IF_MAP.put(InetAddressUtils.addr(\"" + ipinterface.getIpHostName() + "\"), " + ipinterface.getIfIndex() + ");");
    }

    protected void printSnmpInterface(String nodeStringId, OnmsSnmpInterface snmpinterface) {
        if (snmpinterface.getIfName() != null) {
            System.out.println(nodeStringId + "_IF_IFNAME_MAP.put(" + snmpinterface.getIfIndex() + ", \"" + snmpinterface.getIfName() + "\");");
        }
        if (snmpinterface.getIfDescr() != null) {
            System.out.println(nodeStringId + "_IF_IFDESCR_MAP.put(" + snmpinterface.getIfIndex() + ", \"" + snmpinterface.getIfDescr() + "\");");
        }
        if (snmpinterface.getPhysAddr() != null) {
            System.out.println(nodeStringId + "_IF_MAC_MAP.put(" + snmpinterface.getIfIndex() + ", \"" + snmpinterface.getPhysAddr() + "\");");
        }
        if (snmpinterface.getIfAlias() != null) {
            System.out.println(nodeStringId + "_IF_IFALIAS_MAP.put(" + snmpinterface.getIfIndex() + ", \"" + snmpinterface.getIfAlias() + "\");");
        }
        if (snmpinterface.getNetMask() != null && !snmpinterface.getNetMask().getHostAddress().equals("127.0.0.1")) {
            System.out.println(nodeStringId + "_IF_NETMASK_MAP.put(" + snmpinterface.getIfIndex() + ", InetAddressUtils.addr(\"" + snmpinterface.getNetMask().getHostAddress() + "\"));");
        }
    }
}

