/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms10205bNetworkBuilder;

public class Nms10205bTest
extends LinkdTestBuilder {
    Nms10205bNetworkBuilder builder = new Nms10205bNetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.5", port=161, resource="classpath:linkd/nms10205b/Mumbai_10.205.56.5.txt"), @JUnitSnmpAgent(host="10.205.56.7", port=161, resource="classpath:linkd/nms10205b/Delhi_10.205.56.7.txt"), @JUnitSnmpAgent(host="10.205.56.9", port=161, resource="classpath:linkd/nms10205b/Bangalore_10.205.56.9.txt"), @JUnitSnmpAgent(host="10.205.56.20", port=161, resource="classpath:linkd/nms10205b/Bagmane_10.205.56.20.txt"), @JUnitSnmpAgent(host="10.205.56.22", port=161, resource="classpath:linkd/nms10205b/Mysore_10.205.56.22.txt"), @JUnitSnmpAgent(host="10.205.56.1", port=161, resource="classpath:linkd/nms10205b/Space-EX-SW1_10.205.56.1.txt"), @JUnitSnmpAgent(host="10.205.56.2", port=161, resource="classpath:linkd/nms10205b/Space-EX-SW2_10.205.56.2.txt"), @JUnitSnmpAgent(host="10.205.56.42", port=161, resource="classpath:linkd/nms10205b/J6350-42_10.205.56.42.txt"), @JUnitSnmpAgent(host="10.205.56.23", port=161, resource="classpath:linkd/nms10205b/SRX-100_10.205.56.23.txt")})
    public void testNetwork10205bLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMumbai());
        this.m_nodeDao.save((Object)this.builder.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getBangalore());
        this.m_nodeDao.save((Object)this.builder.getBagmane());
        this.m_nodeDao.save((Object)this.builder.getMysore());
        this.m_nodeDao.save((Object)this.builder.getSpaceExSw1());
        this.m_nodeDao.save((Object)this.builder.getSpaceExSw2());
        this.m_nodeDao.save((Object)this.builder.getJ635042());
        this.m_nodeDao.save((Object)this.builder.getSRX100());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        example1.setUseCdpDiscovery(false);
        OnmsNode mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai");
        OnmsNode delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi");
        OnmsNode bangalore = this.m_nodeDao.findByForeignId("linkd", "Bangalore");
        OnmsNode bagmane = this.m_nodeDao.findByForeignId("linkd", "Bagmane");
        OnmsNode mysore = this.m_nodeDao.findByForeignId("linkd", "Mysore");
        OnmsNode spaceexsw1 = this.m_nodeDao.findByForeignId("linkd", "Space-EX-SW1");
        OnmsNode spaceexsw2 = this.m_nodeDao.findByForeignId("linkd", "Space-EX-SW2");
        OnmsNode j635042 = this.m_nodeDao.findByForeignId("linkd", "J6350-2");
        OnmsNode srx100 = this.m_nodeDao.findByForeignId("linkd", "SRX_56.23");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mumbai.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delhi.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(bangalore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(bagmane.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mysore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(spaceexsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(spaceexsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(j635042.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(srx100.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mumbai.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delhi.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(bangalore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(bagmane.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mysore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(spaceexsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(spaceexsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(j635042.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(srx100.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)27L, (long)links.size());
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            int id = datalinkinterface.getId();
            if (start == id) {
                this.checkLink(mumbai, delhi, 519, 28503, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 12 == id) {
                this.checkLink(delhi, mumbai, 28503, 519, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 1 == id) {
                this.checkLink(mumbai, bangalore, 507, 2401, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 13 == id) {
                this.checkLink(bangalore, mumbai, 2401, 507, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 2 == id) {
                this.checkLink(mumbai, bagmane, 977, 534, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 14 == id) {
                this.checkLink(bagmane, mumbai, 534, 977, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 3 == id) {
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                this.checkLink(mumbai, mysore, 978, 508, datalinkinterface);
                continue;
            }
            if (start + 15 == id) {
                this.checkLink(mysore, mumbai, 508, 978, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 4 == id) {
                this.checkLink(delhi, bangalore, 3674, 2397, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 16 == id) {
                this.checkLink(bangalore, delhi, 2397, 3674, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 5 == id) {
                this.checkLink(delhi, spaceexsw1, 17619, 528, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 17 == id) {
                this.checkLink(spaceexsw1, delhi, 528, 17619, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 24 == id) {
                this.checkLink(spaceexsw1, delhi, 528, 28520, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 6 == id) {
                this.checkLink(bangalore, spaceexsw2, 2398, 551, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 19 == id) {
                this.checkLink(spaceexsw2, bangalore, 551, 2398, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 7 == id) {
                this.checkLink(bangalore, bagmane, 2396, 1732, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 18 == id) {
                this.checkLink(bagmane, bangalore, 1732, 2396, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 8 == id) {
                this.checkLink(bagmane, mysore, 654, 520, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 20 == id) {
                this.checkLink(mysore, bagmane, 520, 654, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 9 == id) {
                this.checkLink(bagmane, j635042, 540, 549, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 21 == id) {
                this.checkLink(j635042, bagmane, 549, 540, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 25 == id) {
                this.checkLink(j635042, bagmane, 549, 514, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 10 == id) {
                this.checkLink(spaceexsw1, spaceexsw2, 1361, 531, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 22 == id) {
                this.checkLink(spaceexsw2, spaceexsw1, 531, 1361, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 26 == id) {
                this.checkLink(spaceexsw2, spaceexsw1, 531, 1361, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 11 == id) {
                this.checkLink(spaceexsw2, mumbai, 34, 508, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (start + 23 == id) {
                this.checkLink(bagmane, delhi, 513, 28519, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            this.checkLink(mumbai, mumbai, -1, -1, datalinkinterface);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.5", port=161, resource="classpath:linkd/nms10205b/Mumbai_10.205.56.5.txt"), @JUnitSnmpAgent(host="10.205.56.7", port=161, resource="classpath:linkd/nms10205b/Delhi_10.205.56.7.txt"), @JUnitSnmpAgent(host="10.205.56.9", port=161, resource="classpath:linkd/nms10205b/Bangalore_10.205.56.9.txt"), @JUnitSnmpAgent(host="10.205.56.20", port=161, resource="classpath:linkd/nms10205b/Bagmane_10.205.56.20.txt"), @JUnitSnmpAgent(host="10.205.56.22", port=161, resource="classpath:linkd/nms10205b/Mysore_10.205.56.22.txt"), @JUnitSnmpAgent(host="10.205.56.1", port=161, resource="classpath:linkd/nms10205b/Space-EX-SW1_10.205.56.1.txt"), @JUnitSnmpAgent(host="10.205.56.2", port=161, resource="classpath:linkd/nms10205b/Space-EX-SW2_10.205.56.2.txt"), @JUnitSnmpAgent(host="10.205.56.42", port=161, resource="classpath:linkd/nms10205b/J6350-42_10.205.56.42.txt"), @JUnitSnmpAgent(host="10.205.56.23", port=161, resource="classpath:linkd/nms10205b/SRX-100_10.205.56.23.txt")})
    public void testNetwork10205bLldpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMumbai());
        this.m_nodeDao.save((Object)this.builder.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getBangalore());
        this.m_nodeDao.save((Object)this.builder.getBagmane());
        this.m_nodeDao.save((Object)this.builder.getMysore());
        this.m_nodeDao.save((Object)this.builder.getSpaceExSw1());
        this.m_nodeDao.save((Object)this.builder.getSpaceExSw2());
        this.m_nodeDao.save((Object)this.builder.getJ635042());
        this.m_nodeDao.save((Object)this.builder.getSRX100());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        OnmsNode mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai");
        OnmsNode delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi");
        OnmsNode bangalore = this.m_nodeDao.findByForeignId("linkd", "Bangalore");
        OnmsNode bagmane = this.m_nodeDao.findByForeignId("linkd", "Bagmane");
        OnmsNode mysore = this.m_nodeDao.findByForeignId("linkd", "Mysore");
        OnmsNode spaceexsw1 = this.m_nodeDao.findByForeignId("linkd", "Space-EX-SW1");
        OnmsNode spaceexsw2 = this.m_nodeDao.findByForeignId("linkd", "Space-EX-SW2");
        OnmsNode j635042 = this.m_nodeDao.findByForeignId("linkd", "J6350-2");
        OnmsNode srx100 = this.m_nodeDao.findByForeignId("linkd", "SRX_56.23");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mumbai.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delhi.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(bangalore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(bagmane.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mysore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(spaceexsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(spaceexsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(j635042.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(srx100.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mumbai.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delhi.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(bangalore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(bagmane.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mysore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(spaceexsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(spaceexsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(j635042.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(srx100.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)4L, (long)links.size());
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            int id = datalinkinterface.getId();
            Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
            if (start == id) {
                this.checkLink(bagmane, delhi, 513, 28519, datalinkinterface);
                continue;
            }
            if (start + 1 == id) {
                this.checkLink(spaceexsw1, delhi, 528, 28520, datalinkinterface);
                continue;
            }
            if (start + 2 == id) {
                this.checkLink(j635042, bagmane, 549, 514, datalinkinterface);
                continue;
            }
            if (start + 3 == id) {
                this.checkLink(spaceexsw2, spaceexsw1, 531, 1361, datalinkinterface);
                continue;
            }
            this.checkLink(mumbai, mumbai, -1, -1, datalinkinterface);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.5", port=161, resource="classpath:linkd/nms10205b/Mumbai_10.205.56.5.txt"), @JUnitSnmpAgent(host="10.205.56.7", port=161, resource="classpath:linkd/nms10205b/Delhi_10.205.56.7.txt"), @JUnitSnmpAgent(host="10.205.56.9", port=161, resource="classpath:linkd/nms10205b/Bangalore_10.205.56.9.txt"), @JUnitSnmpAgent(host="10.205.56.20", port=161, resource="classpath:linkd/nms10205b/Bagmane_10.205.56.20.txt"), @JUnitSnmpAgent(host="10.205.56.22", port=161, resource="classpath:linkd/nms10205b/Mysore_10.205.56.22.txt"), @JUnitSnmpAgent(host="10.205.56.1", port=161, resource="classpath:linkd/nms10205b/Space-EX-SW1_10.205.56.1.txt"), @JUnitSnmpAgent(host="10.205.56.2", port=161, resource="classpath:linkd/nms10205b/Space-EX-SW2_10.205.56.2.txt"), @JUnitSnmpAgent(host="10.205.56.42", port=161, resource="classpath:linkd/nms10205b/J6350-42_10.205.56.42.txt"), @JUnitSnmpAgent(host="10.205.56.23", port=161, resource="classpath:linkd/nms10205b/SRX-100_10.205.56.23.txt")})
    public void testNetwork10205bOspfLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMumbai());
        this.m_nodeDao.save((Object)this.builder.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getBangalore());
        this.m_nodeDao.save((Object)this.builder.getBagmane());
        this.m_nodeDao.save((Object)this.builder.getMysore());
        this.m_nodeDao.save((Object)this.builder.getSpaceExSw1());
        this.m_nodeDao.save((Object)this.builder.getSpaceExSw2());
        this.m_nodeDao.save((Object)this.builder.getJ635042());
        this.m_nodeDao.save((Object)this.builder.getSRX100());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setForceIpRouteDiscoveryOnEthernet(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai");
        OnmsNode delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi");
        OnmsNode bangalore = this.m_nodeDao.findByForeignId("linkd", "Bangalore");
        OnmsNode bagmane = this.m_nodeDao.findByForeignId("linkd", "Bagmane");
        OnmsNode mysore = this.m_nodeDao.findByForeignId("linkd", "Mysore");
        OnmsNode spaceexsw1 = this.m_nodeDao.findByForeignId("linkd", "Space-EX-SW1");
        OnmsNode spaceexsw2 = this.m_nodeDao.findByForeignId("linkd", "Space-EX-SW2");
        OnmsNode j635042 = this.m_nodeDao.findByForeignId("linkd", "J6350-2");
        OnmsNode srx100 = this.m_nodeDao.findByForeignId("linkd", "SRX_56.23");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mumbai.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delhi.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(bangalore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(bagmane.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mysore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(spaceexsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(spaceexsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(j635042.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(srx100.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mumbai.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delhi.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(bangalore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(bagmane.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mysore.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(spaceexsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(spaceexsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(j635042.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(srx100.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)11L, (long)links.size());
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            int id = datalinkinterface.getId();
            Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
            if (start == id) {
                this.checkLink(delhi, mumbai, 28503, 519, datalinkinterface);
                continue;
            }
            if (start + 1 == id) {
                this.checkLink(bangalore, mumbai, 2401, 507, datalinkinterface);
                continue;
            }
            if (start + 2 == id) {
                this.checkLink(bagmane, mumbai, 534, 977, datalinkinterface);
                continue;
            }
            if (start + 3 == id) {
                this.checkLink(mysore, mumbai, 508, 978, datalinkinterface);
                continue;
            }
            if (start + 4 == id) {
                this.checkLink(bangalore, delhi, 2397, 3674, datalinkinterface);
                continue;
            }
            if (start + 5 == id) {
                this.checkLink(spaceexsw1, delhi, 528, 17619, datalinkinterface);
                continue;
            }
            if (start + 6 == id) {
                this.checkLink(bagmane, bangalore, 1732, 2396, datalinkinterface);
                continue;
            }
            if (start + 7 == id) {
                this.checkLink(spaceexsw2, bangalore, 551, 2398, datalinkinterface);
                continue;
            }
            if (start + 8 == id) {
                this.checkLink(mysore, bagmane, 520, 654, datalinkinterface);
                continue;
            }
            if (start + 9 == id) {
                this.checkLink(j635042, bagmane, 549, 540, datalinkinterface);
                continue;
            }
            if (start + 10 == id) {
                this.checkLink(spaceexsw2, spaceexsw1, 531, 1361, datalinkinterface);
                continue;
            }
            this.checkLink(mumbai, mumbai, -1, -1, datalinkinterface);
        }
    }
}

