/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms007NetworkBuilder;

public class Nms007Test
extends LinkdTestBuilder {
    Nms007NetworkBuilder builder = new Nms007NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.168.170", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.170.txt"), @JUnitSnmpAgent(host="192.168.168.171", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.171.txt"), @JUnitSnmpAgent(host="192.168.168.172", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.172.txt"), @JUnitSnmpAgent(host="192.168.168.173", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.173.txt"), @JUnitSnmpAgent(host="192.168.168.174", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.174.txt"), @JUnitSnmpAgent(host="192.168.168.175", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.175.txt"), @JUnitSnmpAgent(host="192.168.168.176", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.176.txt"), @JUnitSnmpAgent(host="192.168.168.177", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.177.txt"), @JUnitSnmpAgent(host="192.168.168.189", port=161, resource="classpath:linkd/nms007/mib2_192.168.168.189.txt")})
    public void testOspfLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getFireFly170());
        this.m_nodeDao.save((Object)this.builder.getFireFly171());
        this.m_nodeDao.save((Object)this.builder.getFireFly172());
        this.m_nodeDao.save((Object)this.builder.getFireFly173());
        this.m_nodeDao.save((Object)this.builder.getFireFly174());
        this.m_nodeDao.save((Object)this.builder.getFireFly175());
        this.m_nodeDao.save((Object)this.builder.getFireFly176());
        this.m_nodeDao.save((Object)this.builder.getFireFly177());
        this.m_nodeDao.save((Object)this.builder.getFireFly189());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        this.m_linkdConfig.update();
        OnmsNode fireFly170 = this.m_nodeDao.findByForeignId("linkd", "FireFly_170");
        OnmsNode fireFly171 = this.m_nodeDao.findByForeignId("linkd", "FireFly_171");
        OnmsNode fireFly172 = this.m_nodeDao.findByForeignId("linkd", "FireFly_172");
        OnmsNode fireFly173 = this.m_nodeDao.findByForeignId("linkd", "FireFly_173");
        OnmsNode fireFly174 = this.m_nodeDao.findByForeignId("linkd", "FireFly_174");
        OnmsNode fireFly175 = this.m_nodeDao.findByForeignId("linkd", "FireFly_175");
        OnmsNode fireFly176 = this.m_nodeDao.findByForeignId("linkd", "FireFly_176");
        OnmsNode fireFly177 = this.m_nodeDao.findByForeignId("linkd", "FireFly_177");
        OnmsNode fireFly189 = this.m_nodeDao.findByForeignId("linkd", "FireFly_189");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly170.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly171.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly172.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly173.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly174.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly175.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly176.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly177.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(fireFly189.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly170.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly171.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly172.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly173.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly174.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly175.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly176.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly177.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(fireFly189.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)10L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            int linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(fireFly171, fireFly170, 514, 507, datalinkinterface);
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(fireFly175, fireFly170, 517, 517, datalinkinterface);
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(fireFly189, fireFly170, 517, 517, datalinkinterface);
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(fireFly172, fireFly171, 517, 517, datalinkinterface);
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(fireFly173, fireFly171, 517, 517, datalinkinterface);
                continue;
            }
            if (linkid == start + 5) {
                this.checkLink(fireFly173, fireFly172, 517, 517, datalinkinterface);
                continue;
            }
            if (linkid == start + 6) {
                this.checkLink(fireFly174, fireFly173, 507, 507, datalinkinterface);
                continue;
            }
            if (linkid == start + 7) {
                this.checkLink(fireFly176, fireFly175, 507, 514, datalinkinterface);
                continue;
            }
            if (linkid == start + 8) {
                this.checkLink(fireFly189, fireFly175, 517, 517, datalinkinterface);
                continue;
            }
            if (linkid == start + 9) {
                this.checkLink(fireFly177, fireFly176, 517, 517, datalinkinterface);
                continue;
            }
            this.checkLink(fireFly177, fireFly177, -1, -1, datalinkinterface);
        }
    }
}

